/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import play.api.mvc.Cookie;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesImpl;
import play.libs.Scala;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

@Singleton
public class MessagesApi {
    private final play.api.i18n.MessagesApi messages;

    @Inject
    public MessagesApi(play.api.i18n.MessagesApi messagesApi) {
        this.messages = messagesApi;
    }

    public play.api.i18n.MessagesApi asScala() {
        return this.messages;
    }

    private static Seq<Object> convertArgsToScalaBuffer(Object ... objectArray) {
        return CollectionConverters.asScala(MessagesApi.wrapArgsToListIfNeeded(objectArray)).toList();
    }

    @SafeVarargs
    private static <T> List<T> wrapArgsToListIfNeeded(T ... TArray) {
        List<Object> list = TArray == null ? Collections.emptyList() : (TArray.length == 1 && TArray[0] instanceof List ? (List<Object>)TArray[0] : Arrays.asList(TArray));
        return list;
    }

    public String get(play.api.i18n.Lang lang, String string, Object ... objectArray) {
        Seq<Object> seq = MessagesApi.convertArgsToScalaBuffer(objectArray);
        return this.messages.apply(string, seq, lang);
    }

    public String get(play.api.i18n.Lang lang, List<String> list, Object ... objectArray) {
        Buffer buffer = CollectionConverters.asScala(list);
        Seq<Object> seq = MessagesApi.convertArgsToScalaBuffer(objectArray);
        return this.messages.apply((Seq<String>)buffer.toSeq(), seq, lang);
    }

    public Boolean isDefinedAt(play.api.i18n.Lang lang, String string) {
        return this.messages.isDefinedAt(string, lang);
    }

    public Messages preferred(Collection<Lang> collection) {
        play.api.i18n.Messages messages = this.messages.preferred(Scala.asScala(collection));
        return new MessagesImpl(new Lang(messages.lang()), this);
    }

    public Messages preferred(Http.RequestHeader requestHeader) {
        play.api.i18n.Messages messages = this.messages.preferred(requestHeader);
        return new MessagesImpl(new Lang(messages.lang()), this);
    }

    public Result setLang(Result result, Lang lang) {
        return this.messages.setLang(result.asScala(), lang).asJava();
    }

    public Result clearLang(Result result) {
        return this.messages.clearLang(result.asScala()).asJava();
    }

    public String langCookieName() {
        return this.messages.langCookieName();
    }

    public OptionalInt langCookieMaxAge() {
        Option<Object> option = this.messages.langCookieMaxAge();
        return option.isEmpty() ? OptionalInt.empty() : OptionalInt.of((Integer)option.get());
    }

    public boolean langCookieSecure() {
        return this.messages.langCookieSecure();
    }

    public boolean langCookieHttpOnly() {
        return this.messages.langCookieHttpOnly();
    }

    public Optional<Http.Cookie.SameSite> langCookieSameSite() {
        return OptionConverters.toJava(this.messages.langCookieSameSite()).map(Cookie.SameSite::asJava);
    }

    public boolean langCookiePartitioned() {
        return this.messages.langCookiePartitioned();
    }
}

