/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import jakarta.inject.Inject;
import play.api.http.SecretConfiguration;
import play.api.http.SecretConfiguration$;
import play.api.http.SessionConfiguration;
import play.api.http.SessionConfiguration$;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.mvc.Cookie;
import play.api.mvc.CookieBaker;
import play.api.mvc.DefaultJWTCookieDataCodec;
import play.api.mvc.DefaultUrlEncodedCookieDataCodec;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.FallbackCookieDataCodec;
import play.api.mvc.JWTCookieDataCodec;
import play.api.mvc.Session;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.UrlEncodedCookieDataCodec;
import scala.Option;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001D\u0007\u0001)!A!\u0005\u0001BC\u0002\u0013\u00051\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003%\u0011!Y\u0003A!b\u0001\n\u0003a\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\nIBQA\u000f\u0001\u0005\u0002mBq!\u0013\u0001C\u0002\u0013\u0005#\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0011Q\u0011\u0019!\u0006\u0001)A\u0005#\")!\b\u0001C\u0001+\nIB)\u001a4bk2$8+Z:tS>t7i\\8lS\u0016\u0014\u0015m[3s\u0015\tqq\"A\u0002nm\u000eT!\u0001E\t\u0002\u0007\u0005\u0004\u0018NC\u0001\u0013\u0003\u0011\u0001H.Y=\u0004\u0001M!\u0001!F\u000e !\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u001b%\u0011a$\u0004\u0002\u0013'\u0016\u001c8/[8o\u0007>|7.[3CC.,'\u000f\u0005\u0002\u001dA%\u0011\u0011%\u0004\u0002\u0018\r\u0006dGNY1dW\u000e{wn[5f\t\u0006$\u0018mQ8eK\u000e\faaY8oM&<W#\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dz\u0011\u0001\u00025uiBL!!\u000b\u0014\u0003)M+7o]5p]\u000e{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c4jO\u0002\n1c]3de\u0016$8i\u001c8gS\u001e,(/\u0019;j_:,\u0012!\f\t\u0003K9J!a\f\u0014\u0003'M+7M]3u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)M,7M]3u\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u00031\u0019wn\\6jKNKwM\\3s!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0004def\u0004Ho\u001c\u0006\u0003o=\tA\u0001\\5cg&\u0011\u0011\b\u000e\u0002\r\u0007>|7.[3TS\u001etWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqjdh\u0010\t\u00039\u0001AQA\t\u0004A\u0002\u0011BQa\u000b\u0004A\u00025BQ!\r\u0004A\u0002IB#AB!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015AB5oU\u0016\u001cGOC\u0001G\u0003\u001dQ\u0017m[1si\u0006L!\u0001S\"\u0003\r%s'.Z2u\u0003!Qw\u000f^\"pI\u0016\u001cW#A&\u0011\u0005qa\u0015BA'\u000e\u0005IQu\u000bV\"p_.LW\rR1uC\u000e{G-Z2\u0002\u0013)<HoQ8eK\u000e\u0004\u0013aC:jO:,GmQ8eK\u000e,\u0012!\u0015\t\u00039IK!aU\u0007\u00033U\u0013H.\u00128d_\u0012,GmQ8pW&,G)\u0019;b\u0007>$WmY\u0001\rg&<g.\u001a3D_\u0012,7\r\t\u000b\u0002y\u0001")
public class DefaultSessionCookieBaker
implements SessionCookieBaker,
FallbackCookieDataCodec {
    private final SessionConfiguration config;
    private final SecretConfiguration secretConfiguration;
    private final JWTCookieDataCodec jwtCodec;
    private final UrlEncodedCookieDataCodec signedCodec;
    private Session emptyCookie;
    private boolean isSigned;
    private volatile boolean bitmap$0;

    @Override
    public String encode(Map<String, String> data) {
        return FallbackCookieDataCodec.encode$(this, data);
    }

    @Override
    public Map<String, String> decode(String encodedData) {
        return FallbackCookieDataCodec.decode$(this, encodedData);
    }

    @Override
    public String COOKIE_NAME() {
        return SessionCookieBaker.COOKIE_NAME$(this);
    }

    @Override
    public boolean secure() {
        return SessionCookieBaker.secure$(this);
    }

    @Override
    public Option<Object> maxAge() {
        return SessionCookieBaker.maxAge$(this);
    }

    @Override
    public boolean httpOnly() {
        return SessionCookieBaker.httpOnly$(this);
    }

    @Override
    public String path() {
        return SessionCookieBaker.path$(this);
    }

    @Override
    public Option<String> domain() {
        return SessionCookieBaker.domain$(this);
    }

    @Override
    public Option<Cookie.SameSite> sameSite() {
        return SessionCookieBaker.sameSite$(this);
    }

    @Override
    public boolean partitioned() {
        return SessionCookieBaker.partitioned$(this);
    }

    @Override
    public Session deserialize(Map<String, String> data) {
        return SessionCookieBaker.deserialize$(this, data);
    }

    @Override
    public Map<String, String> serialize(Session session) {
        return SessionCookieBaker.serialize$(this, session);
    }

    @Override
    public Cookie encodeAsCookie(Object data) {
        return CookieBaker.encodeAsCookie$(this, data);
    }

    @Override
    public Map<String, String> decodeCookieToMap(Option<Cookie> cookie) {
        return CookieBaker.decodeCookieToMap$(this, cookie);
    }

    @Override
    public Object decodeFromCookie(Option cookie) {
        return CookieBaker.decodeFromCookie$(this, cookie);
    }

    @Override
    public DiscardingCookie discard() {
        return CookieBaker.discard$(this);
    }

    private Session emptyCookie$lzycompute() {
        DefaultSessionCookieBaker defaultSessionCookieBaker = this;
        synchronized (defaultSessionCookieBaker) {
            if (!this.bitmap$0) {
                this.emptyCookie = SessionCookieBaker.emptyCookie$(this);
                this.bitmap$0 = true;
            }
        }
        return this.emptyCookie;
    }

    @Override
    public Session emptyCookie() {
        if (!this.bitmap$0) {
            return this.emptyCookie$lzycompute();
        }
        return this.emptyCookie;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public void play$api$mvc$SessionCookieBaker$_setter_$isSigned_$eq(boolean x$1) {
        this.isSigned = x$1;
    }

    @Override
    public SessionConfiguration config() {
        return this.config;
    }

    public SecretConfiguration secretConfiguration() {
        return this.secretConfiguration;
    }

    @Override
    public JWTCookieDataCodec jwtCodec() {
        return this.jwtCodec;
    }

    @Override
    public UrlEncodedCookieDataCodec signedCodec() {
        return this.signedCodec;
    }

    @Inject
    public DefaultSessionCookieBaker(SessionConfiguration config, SecretConfiguration secretConfiguration, CookieSigner cookieSigner) {
        this.config = config;
        this.secretConfiguration = secretConfiguration;
        CookieBaker.$init$(this);
        SessionCookieBaker.$init$(this);
        FallbackCookieDataCodec.$init$(this);
        this.jwtCodec = new DefaultJWTCookieDataCodec(secretConfiguration, config.jwt());
        this.signedCodec = new DefaultUrlEncodedCookieDataCodec(this.isSigned(), cookieSigner);
        Statics.releaseFence();
    }

    public DefaultSessionCookieBaker() {
        this(new SessionConfiguration(SessionConfiguration$.MODULE$.apply$default$1(), SessionConfiguration$.MODULE$.apply$default$2(), SessionConfiguration$.MODULE$.apply$default$3(), SessionConfiguration$.MODULE$.apply$default$4(), SessionConfiguration$.MODULE$.apply$default$5(), SessionConfiguration$.MODULE$.apply$default$6(), SessionConfiguration$.MODULE$.apply$default$7(), SessionConfiguration$.MODULE$.apply$default$8(), SessionConfiguration$.MODULE$.apply$default$9()), new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2()), new CookieSignerProvider(new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2())).get());
    }
}

