/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import com.typesafe.config.ConfigMemorySize;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.http.ActionCompositionConfiguration;
import play.api.http.ActionCompositionConfiguration$;
import play.api.http.CookiesConfiguration;
import play.api.http.CookiesConfiguration$;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.FileMimeTypesConfiguration$;
import play.api.http.FlashConfiguration;
import play.api.http.FlashConfiguration$;
import play.api.http.HttpConfiguration;
import play.api.http.JWTConfiguration;
import play.api.http.JWTConfigurationParser$;
import play.api.http.ParserConfiguration;
import play.api.http.ParserConfiguration$;
import play.api.http.SecretConfiguration;
import play.api.http.SecretConfiguration$;
import play.api.http.SessionConfiguration;
import play.api.http.SessionConfiguration$;
import play.api.libs.Codecs$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$SameSite$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class HttpConfiguration$
implements Serializable {
    public static final HttpConfiguration$ MODULE$ = new HttpConfiguration$();
    private static final Logger logger = LoggerFactory.getLogger(HttpConfiguration.class);

    public String $lessinit$greater$default$1() {
        return "/";
    }

    public ParserConfiguration $lessinit$greater$default$2() {
        return new ParserConfiguration(ParserConfiguration$.MODULE$.apply$default$1(), ParserConfiguration$.MODULE$.apply$default$2(), ParserConfiguration$.MODULE$.apply$default$3());
    }

    public ActionCompositionConfiguration $lessinit$greater$default$3() {
        return new ActionCompositionConfiguration(ActionCompositionConfiguration$.MODULE$.apply$default$1(), ActionCompositionConfiguration$.MODULE$.apply$default$2(), ActionCompositionConfiguration$.MODULE$.apply$default$3());
    }

    public CookiesConfiguration $lessinit$greater$default$4() {
        return new CookiesConfiguration(CookiesConfiguration$.MODULE$.apply$default$1());
    }

    public SessionConfiguration $lessinit$greater$default$5() {
        return new SessionConfiguration(SessionConfiguration$.MODULE$.apply$default$1(), SessionConfiguration$.MODULE$.apply$default$2(), SessionConfiguration$.MODULE$.apply$default$3(), SessionConfiguration$.MODULE$.apply$default$4(), SessionConfiguration$.MODULE$.apply$default$5(), SessionConfiguration$.MODULE$.apply$default$6(), SessionConfiguration$.MODULE$.apply$default$7(), SessionConfiguration$.MODULE$.apply$default$8(), SessionConfiguration$.MODULE$.apply$default$9());
    }

    public FlashConfiguration $lessinit$greater$default$6() {
        return new FlashConfiguration(FlashConfiguration$.MODULE$.apply$default$1(), FlashConfiguration$.MODULE$.apply$default$2(), FlashConfiguration$.MODULE$.apply$default$3(), FlashConfiguration$.MODULE$.apply$default$4(), FlashConfiguration$.MODULE$.apply$default$5(), FlashConfiguration$.MODULE$.apply$default$6(), FlashConfiguration$.MODULE$.apply$default$7(), FlashConfiguration$.MODULE$.apply$default$8());
    }

    public FileMimeTypesConfiguration $lessinit$greater$default$7() {
        return new FileMimeTypesConfiguration(FileMimeTypesConfiguration$.MODULE$.apply$default$1());
    }

    public SecretConfiguration $lessinit$greater$default$8() {
        return new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2());
    }

    private Logger logger() {
        return logger;
    }

    public Option<Cookie.SameSite> parseSameSite(Configuration config, String key) {
        return ((Option)config.get(key, ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).flatMap((Function1 & Serializable)value -> {
            Option<Cookie.SameSite> result;
            block0: {
                result = Cookie$SameSite$.MODULE$.parse((String)value);
                if (!result.isEmpty()) break block0;
                String values = Cookie$SameSite$.MODULE$.values().mkString(", ");
                MODULE$.logger().warn("Assuming " + key + " = null, since \"" + value + "\" is not a valid SameSite value (" + values + ")");
            }
            return result;
        });
    }

    public Map<String, String> parseFileMimeTypes(Configuration config) {
        return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString((String)config.get("play.http.fileMimeTypes", ConfigLoader$.MODULE$.stringLoader())), '\n'))).flatMap((Function1 & Serializable)l -> {
            String string;
            String line = l.trim();
            Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line), 1);
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if ("".equals(string2) && "".equals(string3)) {
                    return Option$.MODULE$.empty();
                }
            }
            if (tuple2 != null && "#".equals(string = (String)tuple2._1())) {
                return Option$.MODULE$.empty();
            }
            Tuple2 tuple22 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HttpConfiguration$.$anonfun$parseFileMimeTypes$2(BoxesRunTime.unboxToChar((Object)x$1))));
            if (tuple22 != null) {
                String key = (String)tuple22._1();
                String v = (String)tuple22._2();
                return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(v), 1)));
            }
            return Option$.MODULE$.empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public HttpConfiguration fromConfiguration(Configuration config, Environment environment) {
        String context = HttpConfiguration$.getPath$1("play.http.context", (Option)new Some((Object)"application.context"), config);
        String sessionPath = HttpConfiguration$.getPath$1("play.http.session.path", HttpConfiguration$.getPath$default$2$1(), config);
        String flashPath = HttpConfiguration$.getPath$1("play.http.flash.path", HttpConfiguration$.getPath$default$2$1(), config);
        if (config.has("mimetype")) {
            throw config.globalError("mimetype replaced by play.http.fileMimeTypes map", config.globalError$default$2());
        }
        SecretConfiguration secretConfiguration = this.getSecretConfiguration(config, environment);
        String x$1 = (String)config.getDeprecated("play.http.session.cookieName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean x$2 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.secure", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.secure"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option x$3 = (Option)config.getDeprecated("play.http.session.maxAge", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.maxAge"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()));
        boolean x$4 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.httpOnly", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.httpOnly"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option x$5 = (Option)config.getDeprecated("play.http.session.domain", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.domain"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> x$6 = this.parseSameSite(config, "play.http.session.sameSite");
        String x$7 = sessionPath;
        boolean x$8 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.partitioned", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.partitioned"}), ConfigLoader$.MODULE$.booleanLoader()));
        JWTConfiguration x$9 = JWTConfigurationParser$.MODULE$.apply(config, secretConfiguration, "play.http.session.jwt");
        String x$10 = (String)config.getDeprecated("play.http.flash.cookieName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"flash.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean x$11 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.secure", ConfigLoader$.MODULE$.booleanLoader()));
        boolean x$12 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.httpOnly", ConfigLoader$.MODULE$.booleanLoader()));
        Option x$13 = (Option)config.get("play.http.flash.domain", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> x$14 = this.parseSameSite(config, "play.http.flash.sameSite");
        String x$15 = flashPath;
        boolean x$16 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.partitioned", ConfigLoader$.MODULE$.booleanLoader()));
        JWTConfiguration x$17 = JWTConfigurationParser$.MODULE$.apply(config, secretConfiguration, "play.http.flash.jwt");
        return new HttpConfiguration(context, new ParserConfiguration(((ConfigMemorySize)config.getDeprecated("play.http.parser.maxMemoryBuffer", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parsers.text.maxLength"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes(), ((ConfigMemorySize)config.get("play.http.parser.maxDiskBuffer", ConfigLoader$.MODULE$.bytesLoader())).toBytes(), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.parser.allowEmptyFiles", ConfigLoader$.MODULE$.booleanLoader()))), new ActionCompositionConfiguration(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.controllerAnnotationsFirst", ConfigLoader$.MODULE$.booleanLoader())), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.executeActionCreatorActionFirst", ConfigLoader$.MODULE$.booleanLoader())), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.includeWebSocketActions", ConfigLoader$.MODULE$.booleanLoader()))), new CookiesConfiguration(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.cookies.strict", ConfigLoader$.MODULE$.booleanLoader()))), new SessionConfiguration(x$1, x$2, (Option<FiniteDuration>)x$3, x$4, (Option<String>)x$5, x$7, x$6, x$8, x$9), new FlashConfiguration(x$10, x$11, x$12, (Option<String>)x$13, x$15, x$14, x$16, x$17), new FileMimeTypesConfiguration(this.parseFileMimeTypes(config)), secretConfiguration);
    }

    private SecretConfiguration getSecretConfiguration(Configuration config, Environment environment) {
        Object object;
        Option option;
        Some some;
        String string;
        Some some2;
        String string2;
        Option option2;
        Some some3;
        String string3;
        Some some4;
        String string4;
        Regex Blank = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s*"));
        Option option3 = (Option)config.get("play.http.secret.key", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        if (option3 instanceof Some && "changeme".equals(string4 = (String)(some4 = (Some)option3).value()) ? true : (option3 instanceof Some && (string3 = (String)(some3 = (Some)option3).value()) != null && !(option2 = Blank.unapplySeq((CharSequence)string3)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0 ? true : None$.MODULE$.equals(option3))) {
            Mode mode = environment.mode();
            Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
            if (!(mode != null ? !mode.equals(prod$) : prod$ != null)) {
                String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |The application secret has not been set, and we are in prod mode. Your application is not secure.\n              |To set the application secret, please read https://playframework.com/documentation/latest/ApplicationSecret\n              |"));
                throw config.reportError("play.http.secret", message, config.reportError$default$3());
            }
        }
        if (option3 instanceof Some && "changeme".equals(string2 = (String)(some2 = (Some)option3).value()) ? true : (option3 instanceof Some && (string = (String)(some = (Some)option3).value()) != null && !(option = Blank.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0 ? true : None$.MODULE$.equals(option3))) {
            Option appConfLocation = environment.resource("application.conf");
            String secret = (String)appConfLocation.fold((Function0 & Serializable)() -> "she sells sea shells on the sea shore", (Function1 & Serializable)x$2 -> x$2.toString());
            String md5Secret = Codecs$.MODULE$.md5(secret) + Codecs$.MODULE$.md5("the shells she sells are sea-shells");
            this.logger().debug("Generated dev mode secret " + md5Secret + " for app at " + appConfLocation.getOrElse((Function0 & Serializable)() -> "unknown location"));
            object = md5Secret;
        } else if (option3 instanceof Some) {
            Some some5 = (Some)option3;
            String s = (String)some5.value();
            object = s;
        } else {
            throw new MatchError((Object)option3);
        }
        String secret = object;
        Option provider = (Option)config.getDeprecated("play.http.secret.provider", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"play.crypto.provider"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        return new SecretConfiguration(String.valueOf(secret), (Option<String>)provider);
    }

    public HttpConfiguration createWithDefaults() {
        return new HttpConfiguration(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
    }

    public HttpConfiguration apply(String context, ParserConfiguration parser2, ActionCompositionConfiguration actionComposition, CookiesConfiguration cookies, SessionConfiguration session, FlashConfiguration flash, FileMimeTypesConfiguration fileMimeTypes, SecretConfiguration secret) {
        return new HttpConfiguration(context, parser2, actionComposition, cookies, session, flash, fileMimeTypes, secret);
    }

    public String apply$default$1() {
        return "/";
    }

    public ParserConfiguration apply$default$2() {
        return new ParserConfiguration(ParserConfiguration$.MODULE$.apply$default$1(), ParserConfiguration$.MODULE$.apply$default$2(), ParserConfiguration$.MODULE$.apply$default$3());
    }

    public ActionCompositionConfiguration apply$default$3() {
        return new ActionCompositionConfiguration(ActionCompositionConfiguration$.MODULE$.apply$default$1(), ActionCompositionConfiguration$.MODULE$.apply$default$2(), ActionCompositionConfiguration$.MODULE$.apply$default$3());
    }

    public CookiesConfiguration apply$default$4() {
        return new CookiesConfiguration(CookiesConfiguration$.MODULE$.apply$default$1());
    }

    public SessionConfiguration apply$default$5() {
        return new SessionConfiguration(SessionConfiguration$.MODULE$.apply$default$1(), SessionConfiguration$.MODULE$.apply$default$2(), SessionConfiguration$.MODULE$.apply$default$3(), SessionConfiguration$.MODULE$.apply$default$4(), SessionConfiguration$.MODULE$.apply$default$5(), SessionConfiguration$.MODULE$.apply$default$6(), SessionConfiguration$.MODULE$.apply$default$7(), SessionConfiguration$.MODULE$.apply$default$8(), SessionConfiguration$.MODULE$.apply$default$9());
    }

    public FlashConfiguration apply$default$6() {
        return new FlashConfiguration(FlashConfiguration$.MODULE$.apply$default$1(), FlashConfiguration$.MODULE$.apply$default$2(), FlashConfiguration$.MODULE$.apply$default$3(), FlashConfiguration$.MODULE$.apply$default$4(), FlashConfiguration$.MODULE$.apply$default$5(), FlashConfiguration$.MODULE$.apply$default$6(), FlashConfiguration$.MODULE$.apply$default$7(), FlashConfiguration$.MODULE$.apply$default$8());
    }

    public FileMimeTypesConfiguration apply$default$7() {
        return new FileMimeTypesConfiguration(FileMimeTypesConfiguration$.MODULE$.apply$default$1());
    }

    public SecretConfiguration apply$default$8() {
        return new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2());
    }

    public Option<Tuple8<String, ParserConfiguration, ActionCompositionConfiguration, CookiesConfiguration, SessionConfiguration, FlashConfiguration, FileMimeTypesConfiguration, SecretConfiguration>> unapply(HttpConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.context(), (Object)x$0.parser(), (Object)x$0.actionComposition(), (Object)x$0.cookies(), (Object)x$0.session(), (Object)x$0.flash(), (Object)x$0.fileMimeTypes(), (Object)x$0.secret()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpConfiguration$.class);
    }

    public static final /* synthetic */ boolean $anonfun$parseFileMimeTypes$2(char x$1) {
        return x$1 != '=';
    }

    private static final String getPath$1(String key, Option deprecatedKey, Configuration config$1) {
        String string;
        Option option = deprecatedKey;
        if (option instanceof Some) {
            Some some = (Some)option;
            String depKey = (String)some.value();
            string = (String)config$1.getDeprecated(key, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{depKey}), ConfigLoader$.MODULE$.stringLoader());
        } else if (None$.MODULE$.equals(option)) {
            string = (String)config$1.get(key, ConfigLoader$.MODULE$.stringLoader());
        } else {
            throw new MatchError((Object)option);
        }
        String path = string;
        if (!path.startsWith("/")) {
            throw config$1.globalError(key + " must start with a /", config$1.globalError$default$2());
        }
        return path;
    }

    private static final Option getPath$default$2$1() {
        return None$.MODULE$;
    }

    private HttpConfiguration$() {
    }
}

