/*
 * Decompiled with CFR 0.152.
 */
package play;

import com.typesafe.config.Config;
import jakarta.inject.Inject;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.slf4j.ILoggerFactory;
import play.Environment;
import play.LoggerConfigurator;
import play.Mode;
import play.api.Configuration;
import play.libs.Scala;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

class DelegateLoggerConfigurator
implements LoggerConfigurator {
    private final play.api.LoggerConfigurator delegate;

    @Inject
    public DelegateLoggerConfigurator(play.api.LoggerConfigurator loggerConfigurator) {
        this.delegate = loggerConfigurator;
    }

    @Override
    public void init(File file, Mode mode) {
        this.delegate.init(file, mode.asScala());
    }

    @Override
    public void configure(Environment environment) {
        this.delegate.configure(environment.asScala());
    }

    @Override
    public void configure(Environment environment, Config config, Map<String, String> map2) {
        this.delegate.configure(environment.asScala(), new Configuration(config), Scala.asScala(map2));
    }

    @Override
    public void configure(Map<String, String> map2, Optional<URL> optional) {
        this.delegate.configure(Scala.asScala(map2), (Option<URL>)OptionConverters.toScala(optional));
    }

    @Override
    public ILoggerFactory loggerFactory() {
        return this.delegate.loggerFactory();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }
}

