/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.ContentTypeOf$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HttpErrorConfig;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.routing.Router;
import play.core.SourceMapper;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import views.html.defaultpages.badRequest$;
import views.html.defaultpages.devError$;
import views.html.defaultpages.devNotFound$;
import views.html.defaultpages.error$;
import views.html.defaultpages.notFound$;
import views.html.defaultpages.unauthorized$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\u000f\u001f\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!Aa\b\u0001B\u0001J\u0003%q\bC\u0003J\u0001\u0011\u0005!\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rU\u0003\u0001\u0015!\u0003R\u0011\u0015I\u0005\u0001\"\u0001W\u0011\u0015I\u0005\u0001\"\u0001d\u0011\u001d9\b\u00011A\u0005\naD\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\t\u000f\u0005e\u0001\u0001)Q\u0005s\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003/\u0002A\u0011CA-\u0011\u001d\ty\u0006\u0001C\t\u0003CBq!a\u001a\u0001\t#\tI\u0007C\u0004\u0002p\u0001!\t\"!\u001d\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0013\u0001\u0005\u0012\u0005]\u0005bBAO\u0001\u0011E\u0011q\u0014\u0005\b\u0003[\u0003A\u0011CAX\u0011\u001d\t)\f\u0001C\t\u0003o;q!!2\u001f\u0011\u0003\t9M\u0002\u0004\u001e=!\u0005\u0011\u0011\u001a\u0005\u0007\u0013b!\t!a3\t\u0013\u00055\u0007$%A\u0005\u0002\u0005=\u0007\"CAs1E\u0005I\u0011AAt\u0011%\tY\u000fGI\u0001\n\u0003\tiOA\fEK\u001a\fW\u000f\u001c;IiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe*\u0011q\u0004I\u0001\u0005QR$\bO\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0003\r\nA\u0001\u001d7bs\u000e\u00011c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003!!#H\u000f]#se>\u0014\b*\u00198eY\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u0002.e%\u00111G\b\u0002\u0010\u0011R$\b/\u0012:s_J\u001cuN\u001c4jO\u0006a1o\\;sG\u0016l\u0015\r\u001d9feB\u0019qE\u000e\u001d\n\u0005]B#AB(qi&|g\u000e\u0005\u0002:y5\t!H\u0003\u0002<E\u0005!1m\u001c:f\u0013\ti$H\u0001\u0007T_V\u00148-Z'baB,'/\u0001\u0004s_V$XM\u001d\t\u0004O\u0001\u0013\u0015BA!)\u0005!a$-\u001f8b[\u0016t\u0004cA\u00147\u0007B\u0011AiR\u0007\u0002\u000b*\u0011a\tI\u0001\be>,H/\u001b8h\u0013\tAUI\u0001\u0004S_V$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-cUJ\u0014\t\u0003[\u0001Aq\u0001\r\u0003\u0011\u0002\u0003\u0007\u0011\u0007C\u00045\tA\u0005\t\u0019A\u001b\t\u000fy\"\u0001\u0013\"a\u0001\u007f\u00051An\\4hKJ,\u0012!\u0015\t\u0003%Nk\u0011\u0001I\u0005\u0003)\u0002\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000f\t\u000b\u0006\u0017^c\u0016M\u0019\u0005\u00061\u001e\u0001\r!W\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0002S5&\u00111\f\t\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000fC\u0003^\u000f\u0001\u0007a,A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003%~K!\u0001\u0019\u0011\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015!t\u00011\u00016\u0011\u0019qt\u0001\"a\u0001\u007fQ)1\nZ3gU\")\u0001\f\u0003a\u00013\")Q\f\u0003a\u0001=\")A\u0007\u0003a\u0001OB\u0011!\u000b[\u0005\u0003S\u0002\u0012Ac\u00149uS>t\u0017\r\\*pkJ\u001cW-T1qa\u0016\u0014\b\"\u0002 \t\u0001\u0004Y\u0007c\u00017r\u00076\tQN\u0003\u0002o_\u00061\u0011N\u001c6fGRT\u0011\u0001]\u0001\u0006U\u00064\u0018\r_\u0005\u0003e6\u0014\u0001\u0002\u0015:pm&$WM\u001d\u0015\u0003\u0011Q\u0004\"\u0001\\;\n\u0005Yl'AB%oU\u0016\u001cG/\u0001\u0006qY\u0006LX\tZ5u_J,\u0012!\u001f\t\u0004OYR\bcA>\u0002\u00069\u0019A0!\u0001\u0011\u0005uDS\"\u0001@\u000b\u0005}$\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0004!\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002Q\u0005q\u0001\u000f\\1z\u000b\u0012LGo\u001c:`I\u0015\fH\u0003BA\b\u0003+\u00012aJA\t\u0013\r\t\u0019\u0002\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0018)\t\t\u00111\u0001z\u0003\rAH%M\u0001\fa2\f\u00170\u00123ji>\u0014\b%A\u0007tKR\u0004F.Y=FI&$xN\u001d\u000b\u0005\u0003\u001f\ty\u0002\u0003\u0004\u0002\"1\u0001\rA_\u0001\u0007K\u0012LGo\u001c:\u0002\u001b=t7\t\\5f]R,%O]8s)!\t9#a\u0010\u0002J\u0005M\u0003CBA\u0015\u0003_\t\u0019$\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00022\u0005-\"A\u0002$viV\u0014X\r\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004I\u0001\u0004[Z\u001c\u0017\u0002BA\u001f\u0003o\u0011aAU3tk2$\bbBA!\u001b\u0001\u0007\u00111I\u0001\be\u0016\fX/Z:u!\u0011\t)$!\u0012\n\t\u0005\u001d\u0013q\u0007\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\u0005-S\u00021\u0001\u0002N\u0005Q1\u000f^1ukN\u001cu\u000eZ3\u0011\u0007\u001d\ny%C\u0002\u0002R!\u00121!\u00138u\u0011!\t)&\u0004I\u0001\u0002\u0004Q\u0018aB7fgN\fw-Z\u0001\r_:\u0014\u0015\r\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003O\tY&!\u0018\t\u000f\u0005\u0005c\u00021\u0001\u0002D!1\u0011Q\u000b\bA\u0002i\f1b\u001c8G_J\u0014\u0017\u000e\u001a3f]R1\u0011qEA2\u0003KBq!!\u0011\u0010\u0001\u0004\t\u0019\u0005\u0003\u0004\u0002V=\u0001\rA_\u0001\u000b_:tu\u000e\u001e$pk:$GCBA\u0014\u0003W\ni\u0007C\u0004\u0002BA\u0001\r!a\u0011\t\r\u0005U\u0003\u00031\u0001{\u0003Iygn\u0014;iKJ\u001cE.[3oi\u0016\u0013(o\u001c:\u0015\u0011\u0005\u001d\u00121OA;\u0003oBq!!\u0011\u0012\u0001\u0004\t\u0019\u0005C\u0004\u0002LE\u0001\r!!\u0014\t\r\u0005U\u0013\u00031\u0001{\u00035ygnU3sm\u0016\u0014XI\u001d:peR1\u0011qEA?\u0003\u007fBq!!\u0011\u0013\u0001\u0004\t\u0019\u0005C\u0004\u0002\u0002J\u0001\r!a!\u0002\u0013\u0015D8-\u001a9uS>t\u0007\u0003BAC\u0003\u001fsA!a\"\u0002\f:\u0019Q0!#\n\u0003%J1!!$)\u0003\u001d\u0001\u0018mY6bO\u0016LA!!%\u0002\u0014\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u001bC\u0013!\u00054bi\u0006dWI\u001d:pe6+7o]1hKR)!0!'\u0002\u001c\"9\u0011\u0011I\nA\u0002\u0005\r\u0003bBAA'\u0001\u0007\u00111Q\u0001\u000fY><7+\u001a:wKJ,%O]8s)\u0019\ty!!)\u0002$\"9\u0011\u0011\t\u000bA\u0002\u0005\r\u0003bBAS)\u0001\u0007\u0011qU\u0001\u0010kN,g-\u001e7Fq\u000e,\u0007\u000f^5p]B\u0019!+!+\n\u0007\u0005-\u0006EA\bVg\u00164W\u000f\\#yG\u0016\u0004H/[8o\u0003Ayg\u000eR3w'\u0016\u0014h/\u001a:FeJ|'\u000f\u0006\u0004\u0002(\u0005E\u00161\u0017\u0005\b\u0003\u0003*\u0002\u0019AA\"\u0011\u001d\t\t)\u0006a\u0001\u0003O\u000b\u0011c\u001c8Qe>$7+\u001a:wKJ,%O]8s)\u0019\t9#!/\u0002<\"9\u0011\u0011\t\fA\u0002\u0005\r\u0003bBAA-\u0001\u0007\u0011q\u0015\u0015\u0004\u0001\u0005}\u0006c\u00017\u0002B&\u0019\u00111Y7\u0003\u0013MKgn\u001a7fi>t\u0017a\u0006#fM\u0006,H\u000e\u001e%uiB,%O]8s\u0011\u0006tG\r\\3s!\ti\u0003d\u0005\u0002\u0019\u0017R\u0011\u0011qY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E'fA\u0019\u0002T.\u0012\u0011Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003%)hn\u00195fG.,GMC\u0002\u0002`\"\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019/!7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003ST3!NAj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001e\u0016\u0004\u0005\u0006M\u0007")
public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final HttpErrorConfig config;
    private final Option<SourceMapper> sourceMapper;
    private final Function0<Option<Router>> router;
    private final Logger logger;
    private Option<String> playEditor;

    public static Option<Router> $lessinit$greater$default$3() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static HttpErrorConfig $lessinit$greater$default$1() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler.onClientError$default$3$(this);
    }

    private Logger logger() {
        return this.logger;
    }

    private Option<String> playEditor() {
        return this.playEditor;
    }

    private void playEditor_$eq(Option<String> x$1) {
        this.playEditor = x$1;
    }

    public void setPlayEditor(String editor) {
        this.playEditor_$eq((Option<String>)Option$.MODULE$.apply((Object)editor));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        int n = statusCode;
        if (Status$.MODULE$.BAD_REQUEST() == n) {
            return this.onBadRequest(request, message);
        }
        if (Status$.MODULE$.FORBIDDEN() == n) {
            return this.onForbidden(request, message);
        }
        if (Status$.MODULE$.NOT_FOUND() == n) {
            return this.onNotFound(request, message);
        }
        if (statusCode >= 400 && statusCode < 500) {
            return this.onOtherClientError(request, statusCode, message);
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + statusCode + ": " + message);
    }

    public Future<Result> onBadRequest(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.BadRequest().apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onForbidden(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden().apply(unauthorized$.MODULE$.apply(request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onNotFound(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)(this.config.showDevErrors() ? Results$.MODULE$.NotFound().apply(devNotFound$.MODULE$.apply(request.method(), request.uri(), (Option<Router>)((Option)this.router.apply()), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))) : Results$.MODULE$.NotFound().apply(notFound$.MODULE$.apply(request.method(), request.uri(), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8())))));
    }

    public Future<Result> onOtherClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Object object;
        try {
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, !this.config.showDevErrors(), exception);
            this.logServerError(request, usefulException);
            object = this.config.showDevErrors() ? this.onDevServerError(request, usefulException) : this.onProdServerError(request, usefulException);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logger().error((Function0<String>)(Function0 & Serializable)() -> "Error while handling error", (Function0<Throwable>)(Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                object = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorMessage(request, throwable2), Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())));
            }
            throw throwable;
        }
        return object;
    }

    public String fatalErrorMessage(RequestHeader request, Throwable exception) {
        return "";
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger().error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$1.id, request.method(), request.uri()})), (Function0<Throwable>)(Function0 & Serializable)() -> usefulException, MarkerContext$.MODULE$.NoMarker());
    }

    public Future<Result> onDevServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(devError$.MODULE$.apply(this.playEditor(), exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onProdServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(error$.MODULE$.apply(exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public DefaultHttpErrorHandler(HttpErrorConfig config, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        this.config = config;
        this.sourceMapper = sourceMapper;
        this.router = router;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.playEditor = config.playEditor();
    }

    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        Mode mode = environment.mode();
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        this(new HttpErrorConfig(mode == null ? prod$ != null : !mode.equals(prod$), (Option<String>)configuration.getOptional("play.editor", ConfigLoader$.MODULE$.stringLoader())), sourceMapper, router);
    }

    @Inject
    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        this(environment, configuration, sourceMapper.sourceMapper(), (Function0<Option<Router>>)new Serializable(router){
            private static final long serialVersionUID = 0L;
            private final Provider router$1;

            public final Some<Router> apply() {
                return new Some(this.router$1.get());
            }
            {
                this.router$1 = router$1;
            }
        });
    }
}

