/*
 * Decompiled with CFR 0.152.
 */
package play.core.j;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import play.api.http.HttpConfiguration;
import play.core.j.JavaContextComponents;
import play.core.j.JavaHandlerComponents;
import play.http.ActionCreator;
import play.mvc.Action;
import play.mvc.BodyParser;
import scala.concurrent.ExecutionContext;

public class MappedJavaHandlerComponents
implements JavaHandlerComponents {
    private final ActionCreator actionCreator;
    private final HttpConfiguration httpConfiguration;
    private final ExecutionContext executionContext;
    private final JavaContextComponents contextComponents;
    private final Map<Class<? extends Action<?>>, Supplier<Action<?>>> actions = new HashMap();
    private final Map<Class<? extends BodyParser<?>>, Supplier<BodyParser<?>>> bodyParsers = new HashMap();

    public MappedJavaHandlerComponents(ActionCreator actionCreator, HttpConfiguration httpConfiguration, ExecutionContext executionContext) {
        this(actionCreator, httpConfiguration, executionContext, null);
    }

    @Deprecated
    public MappedJavaHandlerComponents(ActionCreator actionCreator, HttpConfiguration httpConfiguration, ExecutionContext executionContext, JavaContextComponents javaContextComponents) {
        this.actionCreator = actionCreator;
        this.httpConfiguration = httpConfiguration;
        this.executionContext = executionContext;
        this.contextComponents = javaContextComponents;
    }

    @Override
    public <A extends BodyParser<?>> A getBodyParser(Class<A> clazz) {
        return (A)this.bodyParsers.get(clazz).get();
    }

    @Override
    public <A extends Action<?>> A getAction(Class<A> clazz) {
        return (A)this.actions.get(clazz).get();
    }

    @Override
    public ActionCreator actionCreator() {
        return this.actionCreator;
    }

    @Override
    public HttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    @Deprecated
    public JavaContextComponents contextComponents() {
        return this.contextComponents;
    }

    public <A extends Action<?>> MappedJavaHandlerComponents addAction(Class<A> clazz, Supplier<A> supplier) {
        this.actions.put(clazz, MappedJavaHandlerComponents.widenSupplier(supplier));
        return this;
    }

    public <B extends BodyParser<?>> MappedJavaHandlerComponents addBodyParser(Class<B> clazz, Supplier<B> supplier) {
        this.bodyParsers.put(clazz, MappedJavaHandlerComponents.widenSupplier(supplier));
        return this;
    }

    static <A extends B, B> Supplier<B> widenSupplier(Supplier<A> supplier) {
        return supplier;
    }
}

