/*
 * Decompiled with CFR 0.152.
 */
package play.api.inject;

import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.PlayException;
import play.libs.reflect.ConstructorUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class Modules$ {
    public static final Modules$ MODULE$ = new Modules$();
    private static final String DefaultModuleName = "Module";

    private String DefaultModuleName() {
        return DefaultModuleName;
    }

    public Seq<Object> locate(Environment environment, Configuration configuration) {
        None$ none$;
        Seq includes = (Seq)configuration.getOptional("play.modules.enabled", ConfigLoader$.MODULE$.seqStringLoader()).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq excludes = (Seq)configuration.getOptional("play.modules.disabled", ConfigLoader$.MODULE$.seqStringLoader()).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Set moduleClassNames = (Set)includes.toSet().$minus$minus((IterableOnce)excludes);
        if (excludes.contains((Object)this.DefaultModuleName())) {
            none$ = None$.MODULE$;
        } else {
            try {
                Class<?> defaultModuleClass = environment.classLoader().loadClass(this.DefaultModuleName());
                none$ = new Some(this.constructModule(environment, configuration, this.DefaultModuleName(), (Function0 & Serializable)() -> defaultModuleClass));
            }
            catch (ClassNotFoundException e) {
                none$ = None$.MODULE$;
            }
        }
        None$ defaultModule = none$;
        return (Seq)((IterableOnceOps)moduleClassNames.map((Function1 & Serializable)className -> MODULE$.constructModule(environment, configuration, (String)className, (Function0 & Serializable)() -> environment.classLoader().loadClass((String)className)))).toSeq().$plus$plus((IterableOnce)defaultModule);
    }

    private <T> T constructModule(Environment environment, Configuration configuration, String className, Function0<Class<T>> loadModuleClass) {
        Object object;
        try {
            Class moduleClass = (Class)loadModuleClass.apply();
            object = Modules$.tryConstruct$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{environment, configuration}), moduleClass).orElse((Function0 & Serializable)() -> Modules$.tryConstruct$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{new play.Environment(environment), configuration.underlying()}), moduleClass)).orElse((Function0 & Serializable)() -> Modules$.tryConstruct$1((Seq)Nil$.MODULE$, moduleClass)).getOrElse((Function0 & Serializable)() -> {
                throw new PlayException("No valid constructors", "Module [" + className + "] cannot be instantiated. Expected one of:\n()\n(play.api.Environment, play.api.Configuration)\n(play.Environment, com.typesafe.config.Config)");
            });
        }
        catch (PlayException e) {
            throw e;
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlayException("Cannot load module", "Module [" + className + "] cannot be instantiated.", e);
        }
        return (T)object;
    }

    private static final Option tryConstruct$1(Seq args, Class moduleClass$1) {
        None$ none$;
        try {
            Seq argTypes = (Seq)args.map((Function1 & Serializable)x$3 -> x$3.getClass());
            none$ = Option$.MODULE$.apply(ConstructorUtils.getMatchingAccessibleConstructor(moduleClass$1, (Class[])argTypes.toArray(ClassTag$.MODULE$.apply(Class.class))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            none$ = None$.MODULE$;
        }
        catch (SecurityException securityException) {
            none$ = None$.MODULE$;
        }
        None$ constructor = none$;
        return constructor.map((Function1 & Serializable)x$4 -> x$4.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef())));
    }

    private Modules$() {
    }
}

