/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.ContentTypes$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.http.Status$;
import play.api.mvc.ByteRange;
import play.api.mvc.NoHeaderRangeSet;
import play.api.mvc.Range;
import play.api.mvc.RangeResult$;
import play.api.mvc.RangeSet;
import play.api.mvc.RangeSet$;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.Result$;
import play.api.mvc.Results$;
import play.api.mvc.SatisfiableRangeSet;
import play.api.mvc.UnsatisfiableRangeSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class RangeResult$ {
    public static final RangeResult$ MODULE$ = new RangeResult$();

    public Result ofStream(InputStream stream, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofSource((Option<Object>)None$.MODULE$, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> stream, StreamConverters$.MODULE$.fromInputStream$default$2()), rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofStream(long entityLength, InputStream stream, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofSource(entityLength, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> stream, StreamConverters$.MODULE$.fromInputStream$default$2()), rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofPath(Path path, Option<String> rangeHeader, Option<String> contentType) {
        return this.ofPath(path, rangeHeader, ((Object)path.getFileName()).toString(), contentType);
    }

    public Result ofPath(Path path, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        Function1 & Serializable source = (Function1 & Serializable)start -> RangeResult$.$anonfun$ofPath$1(path, BoxesRunTime.unboxToLong((Object)start));
        return this.ofSource((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)Files.size(path))), source, rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofFile(File file, Option<String> rangeHeader, Option<String> contentType) {
        return this.ofFile(file, rangeHeader, file.getName(), contentType);
    }

    public Result ofFile(File file, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofPath(file.toPath(), rangeHeader, fileName, contentType);
    }

    public Result ofSource(long entityLength, Source<ByteString, ?> source, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        return this.ofSource((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)entityLength)), source, rangeHeader, fileName, contentType);
    }

    public Result ofSource(Option<Object> entityLength, Source<ByteString, ?> source, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        return this.ofSource(entityLength, (Function1 & Serializable)x$8 -> RangeResult$.$anonfun$ofSource$1(source, BoxesRunTime.unboxToLong((Object)x$8)), rangeHeader, fileName, contentType);
    }

    @ApiMayChange
    public Result ofSource(Option<Object> entityLength, Function1<Object, Tuple2<Object, Source<ByteString, ?>>> getSource, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        Builder buf = Predef$.MODULE$.Map().newBuilder();
        buf.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCEPT_RANGES()), (Object)"bytes"));
        fileName.foreach((Function1 & Serializable)f -> (Builder)buf.$plus$plus$eq(Results$.MODULE$.contentDispositionHeader(false, fileName)));
        Map commonHeaders = (Map)buf.result();
        RangeSet rangeSet = RangeSet$.MODULE$.apply(entityLength, rangeHeader);
        if (rangeSet instanceof SatisfiableRangeSet) {
            SatisfiableRangeSet satisfiableRangeSet = (SatisfiableRangeSet)rangeSet;
            Range firstRange = satisfiableRangeSet.first();
            ByteRange byteRange = firstRange.byteRange();
            Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)byteRange.start()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long offset = tuple2._1$mcJ$sp();
            Source source = (Source)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)offset), (Object)source);
            long offset2 = tuple22._1$mcJ$sp();
            Source source2 = (Source)tuple22._2();
            Predef$.MODULE$.require(offset2 <= byteRange.start(), (Function0 & Serializable)() -> "Requested range starts at " + byteRange.start() + " but the getSource function returned an offset of " + offset2 + ". It should not seek past the start range.");
            long start = byteRange.start() - offset2;
            Source entitySource = source2.via(this.sliceBytesTransformer(start, firstRange.length()));
            return new Result(ResponseHeader$.MODULE$.apply(Status$.MODULE$.PARTIAL_CONTENT(), (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_RANGE()), (Object)satisfiableRangeSet.toString())}))).$plus$plus((IterableOnce)commonHeaders)), ResponseHeader$.MODULE$.apply$default$3()), new HttpEntity.Streamed(entitySource, firstRange.length(), (Option<String>)contentType.orElse((Function0 & Serializable)() -> new Some((Object)ContentTypes$.MODULE$.BINARY()))), Result$.MODULE$.apply$default$3(), Result$.MODULE$.apply$default$4(), Result$.MODULE$.apply$default$5(), Result$.MODULE$.apply$default$6());
        }
        if (rangeSet instanceof UnsatisfiableRangeSet) {
            UnsatisfiableRangeSet unsatisfiableRangeSet = (UnsatisfiableRangeSet)rangeSet;
            return new Result(ResponseHeader$.MODULE$.apply(Status$.MODULE$.REQUESTED_RANGE_NOT_SATISFIABLE(), (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_RANGE()), (Object)unsatisfiableRangeSet.toString())}))).$plus$plus((IterableOnce)commonHeaders)), ResponseHeader$.MODULE$.apply$default$3()), new HttpEntity.Strict(ByteString$.MODULE$.empty(), contentType), Result$.MODULE$.apply$default$3(), Result$.MODULE$.apply$default$4(), Result$.MODULE$.apply$default$5(), Result$.MODULE$.apply$default$6());
        }
        if (rangeSet instanceof NoHeaderRangeSet) {
            Option<Object> option = entityLength;
            if (option instanceof Some) {
                Some some = (Some)option;
                long entityLen = BoxesRunTime.unboxToLong((Object)some.value());
                if (entityLen > 0L) {
                    Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)0L));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Source source = (Source)tuple2._2();
                    Source source3 = source;
                    return new Result(ResponseHeader$.MODULE$.apply(Status$.MODULE$.OK(), (Map<String, String>)commonHeaders, ResponseHeader$.MODULE$.apply$default$3()), new HttpEntity.Streamed(source3, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)entityLen)), (Option<String>)contentType.orElse((Function0 & Serializable)() -> new Some((Object)ContentTypes$.MODULE$.BINARY()))), Result$.MODULE$.apply$default$3(), Result$.MODULE$.apply$default$4(), Result$.MODULE$.apply$default$5(), Result$.MODULE$.apply$default$6());
                }
                return Results$.MODULE$.Ok().sendEntity(new HttpEntity.Strict(ByteString$.MODULE$.empty(), contentType));
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)0L));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Source source = (Source)tuple2._2();
                Source source4 = source;
                return new Result(ResponseHeader$.MODULE$.apply(Status$.MODULE$.OK(), (Map<String, String>)commonHeaders, ResponseHeader$.MODULE$.apply$default$3()), new HttpEntity.Streamed(source4, (Option<Object>)None$.MODULE$, (Option<String>)contentType.orElse((Function0 & Serializable)() -> new Some((Object)ContentTypes$.MODULE$.BINARY()))), Result$.MODULE$.apply$default$3(), Result$.MODULE$.apply$default$4(), Result$.MODULE$.apply$default$5(), Result$.MODULE$.apply$default$6());
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)rangeSet);
    }

    private Flow<ByteString, ByteString, NotUsed> sliceBytesTransformer(long start, Option<Object> length) {
        GraphStage<FlowShape<ByteString, ByteString>> transformer = new GraphStage<FlowShape<ByteString, ByteString>>(start, length){
            private final Inlet<ByteString> play$api$mvc$RangeResult$$anon$$in;
            private final Outlet<ByteString> play$api$mvc$RangeResult$$anon$$out;
            private final FlowShape<ByteString, ByteString> shape;
            public final long start$1;
            public final Option length$1;

            public Inlet<ByteString> play$api$mvc$RangeResult$$anon$$in() {
                return this.play$api$mvc$RangeResult$$anon$$in;
            }

            public Outlet<ByteString> play$api$mvc$RangeResult$$anon$$out() {
                return this.play$api$mvc$RangeResult$$anon$$out;
            }

            public FlowShape<ByteString, ByteString> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private long toSkip;
                    private long remaining;
                    private final /* synthetic */ anon.1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    private long toSkip() {
                        return this.toSkip;
                    }

                    private void toSkip_$eq(long x$1) {
                        this.toSkip = x$1;
                    }

                    private long remaining() {
                        return this.remaining;
                    }

                    private void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        ByteString element = (ByteString)this.grab(this.$outer.play$api$mvc$RangeResult$$anon$$in());
                        if (this.toSkip() >= (long)element.length()) {
                            this.pull(this.$outer.play$api$mvc$RangeResult$$anon$$in());
                        } else {
                            ByteString data = element.drop((int)this.toSkip()).take((int)package$.MODULE$.min(this.remaining(), Integer.MAX_VALUE));
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.push(this.$outer.play$api$mvc$RangeResult$$anon$$out(), data);
                            if (this.remaining() <= 0L) {
                                this.completeStage();
                            }
                        }
                        this.toSkip_$eq(this.toSkip() - (long)element.length());
                    }

                    public void onPull() {
                        this.pull(this.$outer.play$api$mvc$RangeResult$$anon$$in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.toSkip = $outer.start$1;
                        this.remaining = BoxesRunTime.unboxToLong((Object)$outer.length$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Integer.MAX_VALUE));
                        this.setHandlers($outer.play$api$mvc$RangeResult$$anon$$in(), $outer.play$api$mvc$RangeResult$$anon$$out(), this);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$remaining$1()}, serializedLambda);
                    }
                };
            }
            {
                this.start$1 = start$1;
                this.length$1 = length$1;
                this.play$api$mvc$RangeResult$$anon$$in = Inlet$.MODULE$.apply("Slicer.in");
                this.play$api$mvc$RangeResult$$anon$$out = Outlet$.MODULE$.apply("Slicer.out");
                this.shape = FlowShape$.MODULE$.of(this.play$api$mvc$RangeResult$$anon$$in(), this.play$api$mvc$RangeResult$$anon$$out());
            }
        };
        return Flow$.MODULE$.apply().via((Graph)transformer).named("sliceBytes");
    }

    public static final /* synthetic */ Tuple2 $anonfun$ofPath$1(Path path$1, long start) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)start), (Object)FileIO$.MODULE$.fromPath(path$1, 8192, start));
    }

    public static final /* synthetic */ Tuple2 $anonfun$ofSource$1(Source source$1, long x$8) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)source$1);
    }

    private RangeResult$() {
    }
}

