/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import play.libs.ws.BodyReadable;
import play.libs.ws.StandaloneWSResponse;

public interface DefaultBodyReadables {
    default public BodyReadable<ByteString> byteString() {
        return StandaloneWSResponse::getBodyAsBytes;
    }

    default public BodyReadable<String> string() {
        return StandaloneWSResponse::getBody;
    }

    default public BodyReadable<ByteBuffer> byteBuffer() {
        return standaloneWSResponse -> standaloneWSResponse.getBodyAsBytes().toByteBuffer();
    }

    default public BodyReadable<byte[]> bytes() {
        return standaloneWSResponse -> standaloneWSResponse.getBodyAsBytes().toArray();
    }

    default public BodyReadable<InputStream> inputStream() {
        return standaloneWSResponse -> new ByteArrayInputStream(standaloneWSResponse.getBodyAsBytes().toArray());
    }

    default public BodyReadable<Source<ByteString, ?>> source() {
        return StandaloneWSResponse::getBodyAsSource;
    }
}

