/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pekko.util.ByteString;
import play.libs.ws.BodyWritable;
import play.libs.ws.DefaultObjectMapper;
import play.libs.ws.InMemoryBodyWritable;

public interface JsonBodyWritables {
    public static final JsonBodyWritables instance = new JsonBodyWritables(){};

    default public BodyWritable<ByteString> body(JsonNode jsonNode) {
        return this.body(jsonNode, DefaultObjectMapper.instance());
    }

    default public BodyWritable<ByteString> body(JsonNode jsonNode, ObjectMapper objectMapper) {
        try {
            Object object = objectMapper.readValue(jsonNode.toString(), Object.class);
            byte[] byArray = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(object);
            return new InMemoryBodyWritable(ByteString.fromArrayUnsafe((byte[])byArray), "application/json");
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

