/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.util.ByteString;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import play.Application;
import play.api.Play;
import play.api.i18n.DefaultLangs;
import play.api.i18n.DefaultMessagesApi;
import play.api.i18n.MessagesApi;
import play.api.inject.Injector;
import play.api.mvc.Action;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.test.Helpers$;
import play.api.test.WebDriverFactory;
import play.core.j.JavaContextComponents;
import play.core.j.JavaHandler;
import play.core.j.JavaHandlerComponents;
import play.core.j.JavaHelpers$;
import play.http.HttpEntity;
import play.i18n.Langs;
import play.inject.guice.GuiceApplicationBuilder;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Http;
import play.routing.Router;
import play.test.TestBrowser;
import play.test.TestServer;
import play.twirl.api.Content;
import scala.Option;
import scala.concurrent.Future;
import scala.jdk.javaapi.FutureConverters;

public class Helpers
implements Http.Status,
Http.HeaderNames {
    public static final long DEFAULT_TIMEOUT = Long.getLong("test.timeout", 30000L);
    public static String GET = "GET";
    public static String POST = "POST";
    public static String PUT = "PUT";
    public static String DELETE = "DELETE";
    public static String HEAD = "HEAD";
    public static Class<? extends WebDriver> HTMLUNIT = HtmlUnitDriver.class;
    public static Class<? extends WebDriver> FIREFOX = FirefoxDriver.class;

    private static play.mvc.Result invokeHandler(play.api.Application application, Handler handler, Http.Request request, long l) {
        if (handler instanceof Action) {
            Action action = (Action)handler;
            return Helpers.wrapScalaResult((Future<Result>)action.apply(request.asScala()), l);
        }
        if (handler instanceof JavaHandler) {
            Injector injector = application.injector();
            JavaHandlerComponents javaHandlerComponents = (JavaHandlerComponents)injector.instanceOf(JavaHandlerComponents.class);
            return Helpers.invokeHandler(application, ((JavaHandler)handler).withComponents(javaHandlerComponents), request, l);
        }
        throw new RuntimeException("This is not a JavaAction and can't be invoked this way.");
    }

    private static play.mvc.Result wrapScalaResult(Future<Result> future, long l) {
        if (future == null) {
            return null;
        }
        try {
            Result result = (Result)FutureConverters.asJava(future).toCompletableFuture().get(l, TimeUnit.MILLISECONDS);
            return result.asJava();
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new RuntimeException(executionException.getCause());
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Http.RequestBuilder fakeRequest() {
        return Helpers.fakeRequest("GET", "/");
    }

    public static Http.RequestBuilder fakeRequest(String string, String string2) {
        return new Http.RequestBuilder().method(string).uri(string2);
    }

    public static Http.RequestBuilder fakeRequest(Call call) {
        return Helpers.fakeRequest(call.method(), call.url());
    }

    @Deprecated
    public static JavaContextComponents contextComponents() {
        return JavaHelpers$.MODULE$.createContextComponents();
    }

    public static Application fakeApplication() {
        return new GuiceApplicationBuilder().build();
    }

    public static Map<String, String> inMemoryDatabase() {
        return Helpers.inMemoryDatabase("default");
    }

    public static Map<String, String> inMemoryDatabase(String string) {
        return Helpers.inMemoryDatabase(string, Collections.emptyMap());
    }

    public static Map<String, String> inMemoryDatabase(String string, Map<String, String> map) {
        return Scala.asJava(play.api.test.Helpers.inMemoryDatabase(string, (scala.collection.immutable.Map<String, String>)Scala.asScala(map)));
    }

    public static play.i18n.MessagesApi stubMessagesApi() {
        return new play.i18n.MessagesApi((MessagesApi)new DefaultMessagesApi(Collections.emptyMap(), new DefaultLangs().asJava()));
    }

    public static play.i18n.MessagesApi stubMessagesApi(Map<String, Map<String, String>> map, Langs langs) {
        return new play.i18n.MessagesApi((MessagesApi)new DefaultMessagesApi(map, langs));
    }

    public static Application fakeApplication(Map<String, ?> map) {
        Map<String, ?> map2 = map;
        return ((GuiceApplicationBuilder)new GuiceApplicationBuilder().configure(map2)).build();
    }

    public static ByteString contentAsBytes(play.mvc.Result result) {
        if (result.body() instanceof HttpEntity.Strict) {
            return ((HttpEntity.Strict)result.body()).data();
        }
        throw new UnsupportedOperationException("Tried to extract body from a non strict HTTP entity without a materializer, use the version of this method that accepts a materializer instead");
    }

    public static ByteString contentAsBytes(play.mvc.Result result, Materializer materializer) {
        return Helpers.contentAsBytes(result, materializer, DEFAULT_TIMEOUT);
    }

    public static ByteString contentAsBytes(play.mvc.Result result, Materializer materializer, long l) {
        try {
            return (ByteString)result.body().consumeData(materializer).thenApply(Function.identity()).toCompletableFuture().get(l, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ByteString contentAsBytes(Content content) {
        return ByteString.fromString((String)content.body());
    }

    public static String contentAsString(Content content) {
        return content.body();
    }

    public static String contentAsString(play.mvc.Result result) {
        return Helpers.contentAsBytes(result).decodeString(result.charset().orElse("utf-8"));
    }

    public static String contentAsString(play.mvc.Result result, Materializer materializer) {
        return Helpers.contentAsBytes(result, materializer, DEFAULT_TIMEOUT).decodeString(result.charset().orElse("utf-8"));
    }

    public static String contentAsString(play.mvc.Result result, Materializer materializer, long l) {
        return Helpers.contentAsBytes(result, materializer, l).decodeString(result.charset().orElse("utf-8"));
    }

    public static play.mvc.Result routeAndCall(Application application, Router router, Http.RequestBuilder requestBuilder) {
        return Helpers.routeAndCall(application, router, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result routeAndCall(Application application, Router router, Http.RequestBuilder requestBuilder, long l) {
        try {
            Http.RequestImpl requestImpl = requestBuilder.build();
            return router.route((Http.RequestHeader)requestImpl).map(arg_0 -> Helpers.lambda$routeAndCall$0(application, (Http.Request)requestImpl, l, arg_0)).orElse(null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result route(Application application, Call call) {
        return Helpers.route(application, Helpers.fakeRequest(call));
    }

    public static play.mvc.Result route(Application application, Call call, long l) {
        return Helpers.route(application, Helpers.fakeRequest(call), l);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder) {
        return Helpers.route(application, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder, long l) {
        Option<Future<Result>> option = play.api.test.Helpers.jRoute(application.asScala(), (RequestHeader)requestBuilder.build().asScala(), requestBuilder.body());
        return Helpers.wrapScalaResult((Future<Result>)((Future)Scala.orNull(option)), l);
    }

    public static void start(Application application) {
        Play.start((play.api.Application)application.asScala());
    }

    public static void stop(Application application) {
        Play.stop((play.api.Application)application.asScala());
    }

    public static void running(Application application, Runnable runnable) {
        Helpers$.MODULE$.running(application.asScala(), Scala.asScala(() -> {
            runnable.run();
            return null;
        }));
    }

    public static TestServer testServer() {
        return Helpers.testServer(play.api.test.Helpers.testServerPort());
    }

    public static TestServer testServer(Application application) {
        return Helpers.testServer(play.api.test.Helpers.testServerPort(), application);
    }

    public static TestServer testServer(int n) {
        return new TestServer(n, Helpers.fakeApplication());
    }

    public static TestServer testServer(int n, int n2) {
        return new TestServer(n, Helpers.fakeApplication(), n2);
    }

    public static TestServer testServer(int n, Application application) {
        return new TestServer(n, application);
    }

    public static void start(TestServer testServer) {
        testServer.start();
    }

    public static void stop(TestServer testServer) {
        testServer.stop();
    }

    public static void running(TestServer testServer, Runnable runnable) {
        Helpers$.MODULE$.running((play.api.test.TestServer)testServer, Scala.asScala(() -> {
            runnable.run();
            return null;
        }));
    }

    public static void running(TestServer testServer, Class<? extends WebDriver> clazz, Consumer<TestBrowser> consumer) {
        Helpers.running(testServer, WebDriverFactory.apply(clazz), consumer);
    }

    public static void running(TestServer testServer, WebDriver webDriver, Consumer<TestBrowser> consumer) {
        Helpers$.MODULE$.maybeRunSynchronized(testServer.application(), Scala.asScala(() -> {
            TestBrowser testBrowser = null;
            TestServer testServer2 = null;
            try {
                Helpers.start(testServer);
                testServer2 = testServer;
                testBrowser = Helpers.testBrowser(webDriver, testServer.getRunningHttpPort().getAsInt());
                consumer.accept(testBrowser);
            }
            finally {
                if (testBrowser != null) {
                    testBrowser.quit();
                }
                if (testServer2 != null) {
                    Helpers.stop(testServer2);
                }
            }
            return null;
        }));
    }

    public static TestBrowser testBrowser() {
        return Helpers.testBrowser(HTMLUNIT);
    }

    public static TestBrowser testBrowser(int n) {
        return Helpers.testBrowser(HTMLUNIT, n);
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz) {
        return Helpers.testBrowser(clazz, Helpers$.MODULE$.testServerPort());
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz, int n) {
        try {
            return new TestBrowser(clazz, "http://localhost:" + n);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static TestBrowser testBrowser(WebDriver webDriver, int n) {
        return new TestBrowser(webDriver, "http://localhost:" + n);
    }

    public static TestBrowser testBrowser(WebDriver webDriver) {
        return Helpers.testBrowser(webDriver, Helpers$.MODULE$.testServerPort());
    }

    private static /* synthetic */ play.mvc.Result lambda$routeAndCall$0(Application application, Http.Request request, long l, Handler handler) {
        return Helpers.invokeHandler(application.asScala(), handler, request, l);
    }
}

