/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import org.junit.After;
import org.junit.Before;
import play.Application;
import play.test.Helpers;
import play.test.TestServer;

public class WithServer {
    protected Application app;
    protected int port = -1;
    protected TestServer testServer;

    protected Application provideApplication() {
        return Helpers.fakeApplication();
    }

    protected int providePort() {
        return play.api.test.Helpers.testServerPort();
    }

    @Before
    public void startServer() {
        if (this.testServer != null) {
            this.testServer.stop();
        }
        this.app = this.provideApplication();
        this.testServer = Helpers.testServer(this.providePort(), this.app);
        this.testServer.start();
        this.port = this.testServer.getRunningHttpPort().getAsInt();
    }

    @After
    public void stopServer() {
        if (this.testServer != null) {
            this.testServer.stop();
            this.testServer = null;
            this.port = -1;
            this.app = null;
        }
    }
}

