/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import play.api.Application;
import play.api.Play$;
import play.api.http.HttpVerbs;
import play.api.inject.guice.GuiceApplicationBuilder;
import play.api.test.PlayRunners$;
import play.api.test.TestBrowser;
import play.api.test.TestBrowser$;
import play.api.test.TestServer;
import play.api.test.WebDriverFactory$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Random$;

public interface PlayRunners
extends HttpVerbs {
    public static Lock mutex() {
        return PlayRunners$.MODULE$.mutex();
    }

    public static void $init$(PlayRunners $this) {
        $this.play$api$test$PlayRunners$_setter_$HTMLUNIT_$eq(HtmlUnitDriver.class);
        $this.play$api$test$PlayRunners$_setter_$FIREFOX_$eq(FirefoxDriver.class);
    }

    public Class<HtmlUnitDriver> HTMLUNIT();

    public void play$api$test$PlayRunners$_setter_$HTMLUNIT_$eq(Class var1);

    public Class<FirefoxDriver> FIREFOX();

    public void play$api$test$PlayRunners$_setter_$FIREFOX_$eq(Class var1);

    public static boolean shouldRunSequentially$(PlayRunners $this, Application app) {
        return $this.shouldRunSequentially(app);
    }

    default public boolean shouldRunSequentially(Application app) {
        return false;
    }

    public static Object maybeRunSynchronized$(PlayRunners $this, Application app, Function0 block) {
        return $this.maybeRunSynchronized(app, block);
    }

    default public <T> T maybeRunSynchronized(Application app, Function0<T> block) {
        Object object;
        boolean needsLock = this.shouldRunSequentially(app);
        if (needsLock) {
            PlayRunners$.MODULE$.mutex().lock();
        }
        try {
            object = block.apply();
        }
        finally {
            if (needsLock) {
                PlayRunners$.MODULE$.mutex().unlock();
            }
        }
        return (T)object;
    }

    public static GuiceApplicationBuilder baseApplicationBuilder$(PlayRunners $this) {
        return $this.baseApplicationBuilder();
    }

    default public GuiceApplicationBuilder baseApplicationBuilder() {
        return new GuiceApplicationBuilder();
    }

    public static Object running$(PlayRunners $this, Function1 block) {
        return $this.running(block);
    }

    default public <T> T running(Function1<Application, T> block) {
        Application app = this.baseApplicationBuilder().build();
        return this.running(app, () -> PlayRunners.running$$anonfun$1(block, app));
    }

    public static Object running$(PlayRunners $this, Application app, Function0 block) {
        return $this.running(app, block);
    }

    default public <T> T running(Application app, Function0<T> block) {
        return this.maybeRunSynchronized(app, () -> PlayRunners.running$$anonfun$2(app, block));
    }

    public static Object running$(PlayRunners $this, Function1 builder, Function1 block) {
        return $this.running((Function1<GuiceApplicationBuilder, GuiceApplicationBuilder>)builder, block);
    }

    default public <T> T running(Function1<GuiceApplicationBuilder, GuiceApplicationBuilder> builder, Function1<Application, T> block) {
        Application app = ((GuiceApplicationBuilder)builder.apply((Object)this.baseApplicationBuilder())).build();
        return this.running(app, () -> PlayRunners.running$$anonfun$3(block, app));
    }

    public static Object running$(PlayRunners $this, TestServer testServer, Function0 block) {
        return $this.running(testServer, block);
    }

    default public <T> T running(TestServer testServer, Function0<T> block) {
        return this.runningWithPort(testServer, (Function1 & Serializable)_$1 -> block.apply());
    }

    public static Object runningWithPort$(PlayRunners $this, TestServer testServer, Function1 block) {
        return $this.runningWithPort(testServer, block);
    }

    default public <T> T runningWithPort(TestServer testServer, Function1<Object, T> block) {
        return this.maybeRunSynchronized(testServer.application(), () -> PlayRunners.runningWithPort$$anonfun$1(testServer, block));
    }

    public static Object running$(PlayRunners $this, TestServer testServer, Class webDriver, Function1 block) {
        return $this.running(testServer, webDriver, block);
    }

    default public <T, WEBDRIVER extends WebDriver> T running(TestServer testServer, Class<WEBDRIVER> webDriver, Function1<TestBrowser, T> block) {
        return this.running(testServer, WebDriverFactory$.MODULE$.apply(webDriver), block);
    }

    public static Object runningWithPort$(PlayRunners $this, TestServer testServer, Class webDriver, Function2 block) {
        return $this.runningWithPort(testServer, webDriver, block);
    }

    default public <T, WEBDRIVER extends WebDriver> T runningWithPort(TestServer testServer, Class<WEBDRIVER> webDriver, Function2<TestBrowser, Object, T> block) {
        return this.runningWithPort(testServer, WebDriverFactory$.MODULE$.apply(webDriver), block);
    }

    public static Object running$(PlayRunners $this, TestServer testServer, WebDriver webDriver, Function1 block) {
        return $this.running(testServer, webDriver, block);
    }

    default public <T> T running(TestServer testServer, WebDriver webDriver, Function1<TestBrowser, T> block) {
        return this.runningWithPort(testServer, webDriver, (Function2 & Serializable)(testBrowser, _$2) -> block.apply((Object)((TestBrowser)testBrowser)));
    }

    public static Object runningWithPort$(PlayRunners $this, TestServer testServer, WebDriver webDriver, Function2 block) {
        return $this.runningWithPort(testServer, webDriver, block);
    }

    default public <T> T runningWithPort(TestServer testServer, WebDriver webDriver, Function2<TestBrowser, Object, T> block) {
        ObjectRef browser = ObjectRef.create(null);
        return this.maybeRunSynchronized(testServer.application(), () -> PlayRunners.runningWithPort$$anonfun$2(testServer, browser, webDriver, block));
    }

    public static int testServerPort$(PlayRunners $this) {
        return $this.testServerPort();
    }

    default public int testServerPort() {
        return BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("testserver.port").map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$3))).getOrElse(PlayRunners::testServerPort$$anonfun$2));
    }

    public static Option testServerHttpsPort$(PlayRunners $this) {
        return $this.testServerHttpsPort();
    }

    default public Option<Object> testServerHttpsPort() {
        return package$.MODULE$.props().get("testserver.httpsport").map((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$4)));
    }

    public static String testServerAddress$(PlayRunners $this) {
        return $this.testServerAddress();
    }

    default public String testServerAddress() {
        return (String)package$.MODULE$.props().get("testserver.address").orElse(PlayRunners::testServerAddress$$anonfun$1).getOrElse(PlayRunners::testServerAddress$$anonfun$2);
    }

    public static Map inMemoryDatabase$(PlayRunners $this, String name, Map options) {
        return $this.inMemoryDatabase(name, (Map<String, String>)options);
    }

    default public Map<String, String> inMemoryDatabase(String name, Map<String, String> options) {
        int randomInt = Random$.MODULE$.nextInt();
        String optionsForDbUrl = ((IterableOnceOps)options.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k + "=" + v;
            }
            throw new MatchError((Object)tuple2);
        })).mkString(";", ";", "");
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)("db." + name + ".driver"));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"org.h2.Driver");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)("db." + name + ".url"));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)("jdbc:h2:mem:play-test-" + randomInt + optionsForDbUrl));
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static String inMemoryDatabase$default$1$(PlayRunners $this) {
        return $this.inMemoryDatabase$default$1();
    }

    default public String inMemoryDatabase$default$1() {
        return "default";
    }

    public static Map inMemoryDatabase$default$2$(PlayRunners $this) {
        return $this.inMemoryDatabase$default$2();
    }

    default public Map<String, String> inMemoryDatabase$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static Object running$$anonfun$1(Function1 block$1, Application app$1) {
        return block$1.apply((Object)app$1);
    }

    private static Object running$$anonfun$2(Application app$2, Function0 block$2) {
        Object object;
        try {
            Play$.MODULE$.start(app$2);
            object = block$2.apply();
        }
        finally {
            Play$.MODULE$.stop(app$2);
        }
        return object;
    }

    private static Object running$$anonfun$3(Function1 block$3, Application app$3) {
        return block$3.apply((Object)app$3);
    }

    private static Option runningWithPort$$anonfun$1$$anonfun$1(TestServer testServer$2) {
        return testServer$2.runningHttpsPort();
    }

    private static int runningWithPort$$anonfun$1$$anonfun$2() {
        throw new IllegalStateException("Test server is running, but neither http nor https port can not be determined!");
    }

    private static Object runningWithPort$$anonfun$1(TestServer testServer$1, Function1 block$5) {
        Object object;
        try {
            testServer$1.start();
            object = block$5.apply(testServer$1.runningHttpPort().orElse(() -> PlayRunners.runningWithPort$$anonfun$1$$anonfun$1(testServer$1)).getOrElse(PlayRunners::runningWithPort$$anonfun$1$$anonfun$2));
        }
        finally {
            testServer$1.stop();
        }
        return object;
    }

    private static Option runningWithPort$$anonfun$2$$anonfun$1(TestServer testServer$4) {
        return testServer$4.runningHttpsPort();
    }

    private static int runningWithPort$$anonfun$2$$anonfun$2() {
        throw new IllegalStateException("Test server is running, but neither http nor https port can not be determined!");
    }

    private static Object runningWithPort$$anonfun$2(TestServer testServer$3, ObjectRef browser$1, WebDriver webDriver$1, Function2 block$7) {
        Object object;
        try {
            testServer$3.start();
            browser$1.elem = TestBrowser$.MODULE$.apply(webDriver$1, (Option<String>)None$.MODULE$);
            object = block$7.apply((Object)((TestBrowser)browser$1.elem), testServer$3.runningHttpPort().orElse(() -> PlayRunners.runningWithPort$$anonfun$2$$anonfun$1(testServer$3)).getOrElse(PlayRunners::runningWithPort$$anonfun$2$$anonfun$2));
        }
        finally {
            if ((TestBrowser)browser$1.elem != null) {
                ((TestBrowser)browser$1.elem).quit();
            }
            testServer$3.stop();
        }
        return object;
    }

    private static int testServerPort$$anonfun$2() {
        return 0;
    }

    private static Option testServerAddress$$anonfun$1() {
        return package$.MODULE$.env().get((Object)"PLAY_TEST_SERVER_HTTP_ADDRESS");
    }

    private static String testServerAddress$$anonfun$2() {
        return "0.0.0.0";
    }
}

