/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import com.typesafe.config.ConfigFactory;
import org.apache.pekko.annotation.ApiMayChange;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.test.HttpsServerEndpointRecipe$;
import play.api.test.ServerEndpointRecipe;
import play.api.test.TestServer;
import play.core.server.SelfSigned$;
import play.core.server.SelfSignedSSLEngineProvider;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoint$;
import play.core.server.ServerProvider;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public final class HttpsServerEndpointRecipe
implements ServerEndpointRecipe {
    private final String description;
    private final ServerProvider serverProvider;
    private final Configuration extraServerConfiguration;
    private final Set<String> expectedHttpVersions;
    private final Option<String> expectedServerAttr;
    private final Option configuredHttpPort;
    private final Option configuredHttpsPort;

    public static Configuration $lessinit$greater$default$3() {
        return HttpsServerEndpointRecipe$.MODULE$.$lessinit$greater$default$3();
    }

    public HttpsServerEndpointRecipe(String description, ServerProvider serverProvider, Configuration extraServerConfiguration, Set<String> expectedHttpVersions, Option<String> expectedServerAttr) {
        this.description = description;
        this.serverProvider = serverProvider;
        this.extraServerConfiguration = extraServerConfiguration;
        this.expectedHttpVersions = expectedHttpVersions;
        this.expectedServerAttr = expectedServerAttr;
        this.configuredHttpPort = None$.MODULE$;
        this.configuredHttpsPort = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ServerProvider serverProvider() {
        return this.serverProvider;
    }

    @Override
    public Option<Object> configuredHttpPort() {
        return this.configuredHttpPort;
    }

    @Override
    public Option<Object> configuredHttpsPort() {
        return this.configuredHttpsPort;
    }

    @Override
    public Configuration serverConfiguration() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"play.server.https.engineProvider");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)SelfSignedSSLEngineProvider.class.getName());
        return this.extraServerConfiguration.withFallback(Configuration$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @Override
    public ServerEndpoint createEndpointFromServer(TestServer runningServer) {
        return ServerEndpoint$.MODULE$.apply(this.description(), "https", "localhost", BoxesRunTime.unboxToInt((Object)runningServer.runningHttpsPort().get()), this.expectedHttpVersions, this.expectedServerAttr, (Option)Some$.MODULE$.apply((Object)SelfSigned$.MODULE$.sslContext()));
    }

    @Override
    public ServerEndpointRecipe withDescription(String newDescription) {
        return new HttpsServerEndpointRecipe(newDescription, this.serverProvider(), this.extraServerConfiguration, this.expectedHttpVersions, this.expectedServerAttr);
    }

    @Override
    public ServerEndpointRecipe withServerProvider(ServerProvider newProvider) {
        return new HttpsServerEndpointRecipe(this.description(), newProvider, this.extraServerConfiguration, this.expectedHttpVersions, this.expectedServerAttr);
    }

    @Override
    public HttpsServerEndpointRecipe withExtraServerConfiguration(Map<String, Object> extraConfig) {
        return new HttpsServerEndpointRecipe(this.description(), this.serverProvider(), Configuration$.MODULE$.apply(ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(extraConfig).asJava())).withFallback(this.serverConfiguration()), this.expectedHttpVersions, this.expectedServerAttr);
    }

    public String toString() {
        return "HttpsServerEndpointRecipe(" + this.description() + ")";
    }
}

