/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import java.io.Serializable;
import org.apache.pekko.annotation.ApiMayChange;
import play.api.Application;
import play.api.Play$;
import play.api.test.TestServer$;
import play.api.test.TestServerProcess;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import scala.Function0;
import scala.Option;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public class TestServer
implements Product,
Serializable {
    private final ServerConfig config;
    private final Application application;
    private final Option serverProvider;
    private TestServerProcess testServerProcess;
    private Server server;

    public static TestServer apply(int n, Application application, Option<Object> option, Option<ServerProvider> option2) {
        return TestServer$.MODULE$.apply(n, application, option, option2);
    }

    public static TestServer apply(ServerConfig serverConfig, Application application, Option<ServerProvider> option) {
        return TestServer$.MODULE$.apply(serverConfig, application, option);
    }

    public static TestServer fromProduct(Product product) {
        return TestServer$.MODULE$.fromProduct(product);
    }

    public static TestServer unapply(TestServer testServer) {
        return TestServer$.MODULE$.unapply(testServer);
    }

    public static Application apply$default$2() {
        return TestServer$.MODULE$.apply$default$2();
    }

    public static Option<Object> apply$default$3() {
        return TestServer$.MODULE$.apply$default$3();
    }

    public static Option<ServerProvider> apply$default$4() {
        return TestServer$.MODULE$.apply$default$4();
    }

    public TestServer(ServerConfig config, Application application, Option<ServerProvider> serverProvider) {
        this.config = config;
        this.application = application;
        this.serverProvider = serverProvider;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TestServer)) return false;
        TestServer testServer = (TestServer)object;
        ServerConfig serverConfig = this.config();
        ServerConfig serverConfig2 = testServer.config();
        if (serverConfig == null) {
            if (serverConfig2 != null) {
                return false;
            }
        } else if (!serverConfig.equals(serverConfig2)) return false;
        Application application = this.application();
        Application application2 = testServer.application();
        if (application == null) {
            if (application2 != null) {
                return false;
            }
        } else if (!application.equals(application2)) return false;
        Option<ServerProvider> option = this.serverProvider();
        Option<ServerProvider> option2 = testServer.serverProvider();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!testServer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TestServer;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TestServer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "config";
            }
            case 1: {
                return "application";
            }
            case 2: {
                return "serverProvider";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ServerConfig config() {
        return this.config;
    }

    public Application application() {
        return this.application;
    }

    public Option<ServerProvider> serverProvider() {
        return this.serverProvider;
    }

    public Server server() {
        return this.server;
    }

    public void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private Server getTestServerIfRunning() {
        Server s = this.server();
        if (s == null) {
            throw new IllegalStateException("Test server not running");
        }
        return s;
    }

    public void start() {
        if (this.testServerProcess != null) {
            throw package$.MODULE$.error("Server already started!");
        }
        try {
            this.testServerProcess = new TestServerProcess();
            ServerProvider resolvedServerProvider = (ServerProvider)this.serverProvider().getOrElse(this::$anonfun$1);
            Play$.MODULE$.start(this.application());
            this.server_$eq(resolvedServerProvider.createServer(this.config(), this.application()));
            this.testServerProcess.addShutdownHook((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.start$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                t.printStackTrace();
                throw new RuntimeException(t);
            }
            throw throwable;
        }
    }

    public void stop() {
        if (this.testServerProcess != null) {
            TestServerProcess p = this.testServerProcess;
            this.testServerProcess = null;
            p.shutdown();
            return;
        }
    }

    public String runningAddress() {
        return this.getTestServerIfRunning().mainAddress().getAddress().getHostAddress();
    }

    public Option<Object> runningHttpPort() {
        return this.getTestServerIfRunning().httpPort();
    }

    public Option<Object> runningHttpsPort() {
        return this.getTestServerIfRunning().httpsPort();
    }

    @ApiMayChange
    public boolean isRunning() {
        return this.runningHttpPort().nonEmpty() || this.runningHttpsPort().nonEmpty();
    }

    public TestServer copy(ServerConfig config, Application application, Option<ServerProvider> serverProvider) {
        return new TestServer(config, application, serverProvider);
    }

    public ServerConfig copy$default$1() {
        return this.config();
    }

    public Application copy$default$2() {
        return this.application();
    }

    public Option<ServerProvider> copy$default$3() {
        return this.serverProvider();
    }

    public ServerConfig _1() {
        return this.config();
    }

    public Application _2() {
        return this.application();
    }

    public Option<ServerProvider> _3() {
        return this.serverProvider();
    }

    private final ServerProvider $anonfun$1() {
        return ServerProvider$.MODULE$.fromConfiguration(this.testServerProcess.classLoader(), this.config().configuration());
    }

    private final void start$$anonfun$1() {
        Server ts = this.server();
        this.server_$eq(null);
        ts.stop();
    }
}

