/*
 * Decompiled with CFR 0.152.
 */
package play.libs.streams;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.AsPublisher;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.stream.javadsl.Keep;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import play.api.libs.streams.Accumulator$;
import scala.Option;
import scala.concurrent.Future;
import scala.jdk.javaapi.FutureConverters;
import scala.jdk.javaapi.OptionConverters;
import scala.runtime.AbstractFunction1;

public abstract class Accumulator<E, A> {
    private Accumulator() {
    }

    public abstract <B> Accumulator<E, B> map(java.util.function.Function<? super A, ? extends B> var1, Executor var2);

    public abstract <B> Accumulator<E, B> mapFuture(java.util.function.Function<? super A, ? extends CompletionStage<B>> var1, Executor var2);

    public abstract Accumulator<E, A> recover(java.util.function.Function<? super Throwable, ? extends A> var1, Executor var2);

    public abstract Accumulator<E, A> recoverWith(java.util.function.Function<? super Throwable, ? extends CompletionStage<A>> var1, Executor var2);

    public abstract <D> Accumulator<D, A> through(Flow<D, E, ?> var1);

    public abstract CompletionStage<A> run(Materializer var1);

    public abstract CompletionStage<A> run(Source<E, ?> var1, Materializer var2);

    public abstract CompletionStage<A> run(E var1, Materializer var2);

    public abstract Sink<E, CompletionStage<A>> toSink();

    public abstract play.api.libs.streams.Accumulator<E, A> asScala();

    public static <E, A> Accumulator<E, A> fromSink(Sink<E, CompletionStage<A>> sink) {
        return new SinkAccumulator<E, A>(sink);
    }

    public static <E> Accumulator<E, Source<E, ?>> source() {
        return new SinkAccumulator(Sink.asPublisher((AsPublisher)AsPublisher.WITHOUT_FANOUT).mapMaterializedValue((Function & Serializable)publisher -> CompletableFuture.completedFuture(Source.fromPublisher((Publisher)publisher))));
    }

    public static <E, A> Accumulator<E, A> done(A a) {
        return Accumulator.done(CompletableFuture.completedFuture(a));
    }

    public static <E, A> Accumulator<E, A> done(CompletionStage<A> completionStage) {
        return new StrictAccumulator(optional -> completionStage, Sink.cancelled().mapMaterializedValue((Function & Serializable)notUsed -> completionStage));
    }

    public static <E, A> Accumulator<E, A> strict(java.util.function.Function<Optional<E>, CompletionStage<A>> function, Sink<E, CompletionStage<A>> sink) {
        return new StrictAccumulator<E, A>(function, sink);
    }

    public static <E, A> Accumulator<E, A> flatten(CompletionStage<Accumulator<E, A>> completionStage, Materializer materializer) {
        CompletableFuture completableFuture = new CompletableFuture();
        FlattenSubscriber<A, E> flattenSubscriber = new FlattenSubscriber<A, E>(completionStage, completableFuture, materializer);
        Sink sink = Sink.fromSubscriber(flattenSubscriber).mapMaterializedValue((Function & Serializable)notUsed -> completableFuture);
        return new SinkAccumulator(sink);
    }

    private static <A> CompletionStage<A> completionStageRecoverWith(CompletionStage<A> completionStage, java.util.function.Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
        return completionStage.handleAsync((object, throwable) -> {
            if (object != null) {
                return CompletableFuture.completedFuture(object);
            }
            if (throwable instanceof CompletionException) {
                return (CompletionStage)function.apply(throwable.getCause());
            }
            return (CompletionStage)function.apply((Throwable)throwable);
        }, executor).thenCompose(java.util.function.Function.identity());
    }

    private static <A> CompletionStage<A> completionStageRecover(CompletionStage<A> completionStage, java.util.function.Function<? super Throwable, ? extends A> function, Executor executor) {
        return completionStage.handleAsync((object, throwable) -> {
            if (object != null) {
                return object;
            }
            return function.apply((Throwable)throwable);
        }, executor);
    }

    private static final class StrictAccumulator<E, A>
    extends Accumulator<E, A> {
        private final java.util.function.Function<Optional<E>, CompletionStage<A>> strictHandler;
        private final Sink<E, CompletionStage<A>> toSink;

        public StrictAccumulator(java.util.function.Function<Optional<E>, CompletionStage<A>> function, Sink<E, CompletionStage<A>> sink) {
            this.strictHandler = function;
            this.toSink = sink;
        }

        private <B> Accumulator<E, B> mapMat(java.util.function.Function<CompletionStage<A>, CompletionStage<B>> function) {
            return new StrictAccumulator<E, A>(this.strictHandler.andThen(function), this.toSink.mapMaterializedValue(function::apply));
        }

        @Override
        public <B> Accumulator<E, B> map(java.util.function.Function<? super A, ? extends B> function, Executor executor) {
            return this.mapMat(completionStage -> completionStage.thenApplyAsync(function, executor));
        }

        @Override
        public <B> Accumulator<E, B> mapFuture(java.util.function.Function<? super A, ? extends CompletionStage<B>> function, Executor executor) {
            return this.mapMat(completionStage -> completionStage.thenComposeAsync(function, executor));
        }

        @Override
        public Accumulator<E, A> recover(java.util.function.Function<? super Throwable, ? extends A> function, Executor executor) {
            return this.mapMat(completionStage -> Accumulator.completionStageRecover(completionStage, function, executor));
        }

        @Override
        public Accumulator<E, A> recoverWith(java.util.function.Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
            return this.mapMat(completionStage -> Accumulator.completionStageRecoverWith(completionStage, function, executor));
        }

        @Override
        public <D> Accumulator<D, A> through(Flow<D, E, ?> flow) {
            return new SinkAccumulator(flow.toMat(this.toSink, Keep.right()));
        }

        @Override
        public CompletionStage<A> run(Materializer materializer) {
            return this.strictHandler.apply(Optional.empty());
        }

        @Override
        public CompletionStage<A> run(Source<E, ?> source, Materializer materializer) {
            return (CompletionStage)source.runWith(this.toSink, materializer);
        }

        @Override
        public CompletionStage<A> run(E e, Materializer materializer) {
            return this.strictHandler.apply(Optional.of(e));
        }

        @Override
        public Sink<E, CompletionStage<A>> toSink() {
            return this.toSink;
        }

        @Override
        public play.api.libs.streams.Accumulator<E, A> asScala() {
            return Accumulator$.MODULE$.strict(new AbstractFunction1<Option<E>, Future<A>>(){

                public Future<A> apply(Option<E> option) {
                    return FutureConverters.asScala(strictHandler.apply(OptionConverters.toJava(option)));
                }
            }, this.toSink.mapMaterializedValue(FutureConverters::asScala).asScala());
        }
    }

    private static final class SinkAccumulator<E, A>
    extends Accumulator<E, A> {
        private final Sink<E, CompletionStage<A>> sink;

        private SinkAccumulator(Sink<E, CompletionStage<A>> sink) {
            this.sink = sink;
        }

        @Override
        public <B> Accumulator<E, B> map(java.util.function.Function<? super A, ? extends B> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((Function & Serializable)completionStage -> completionStage.thenApplyAsync(function, executor)));
        }

        @Override
        public <B> Accumulator<E, B> mapFuture(java.util.function.Function<? super A, ? extends CompletionStage<B>> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((Function & Serializable)completionStage -> completionStage.thenComposeAsync(function, executor)));
        }

        @Override
        public Accumulator<E, A> recover(java.util.function.Function<? super Throwable, ? extends A> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((Function & Serializable)completionStage -> Accumulator.completionStageRecover(completionStage, function, executor)));
        }

        @Override
        public Accumulator<E, A> recoverWith(java.util.function.Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((Function & Serializable)completionStage -> Accumulator.completionStageRecoverWith(completionStage, function, executor)));
        }

        @Override
        public <D> Accumulator<D, A> through(Flow<D, E, ?> flow) {
            return new SinkAccumulator<E, A>(flow.toMat(this.sink, Keep.right()));
        }

        @Override
        public CompletionStage<A> run(Materializer materializer) {
            return (CompletionStage)Source.empty().runWith(this.sink, materializer);
        }

        @Override
        public CompletionStage<A> run(Source<E, ?> source, Materializer materializer) {
            return (CompletionStage)source.runWith(this.sink, materializer);
        }

        @Override
        public CompletionStage<A> run(E e, Materializer materializer) {
            return this.run((E)Source.single(e), materializer);
        }

        @Override
        public Sink<E, CompletionStage<A>> toSink() {
            return this.sink;
        }

        @Override
        public play.api.libs.streams.Accumulator<E, A> asScala() {
            return Accumulator$.MODULE$.apply(this.sink.mapMaterializedValue(FutureConverters::asScala).asScala());
        }
    }

    private static final class FlattenSubscriber<A, E>
    implements Subscriber<E> {
        private final CompletionStage<Accumulator<E, A>> stage;
        private final CompletableFuture<A> result;
        private final Materializer materializer;
        private volatile Subscriber<? super E> underlying = new NoOpSubscriber<E>();
        private BiFunction<A, Throwable, Void> completionHandler = new BiFunction<A, Throwable, Void>(){

            @Override
            public Void apply(A a, Throwable throwable) {
                if (a != null) {
                    result.complete(a);
                } else {
                    result.completeExceptionally(throwable);
                }
                return null;
            }
        };

        public FlattenSubscriber(CompletionStage<Accumulator<E, A>> completionStage, CompletableFuture<A> completableFuture, Materializer materializer) {
            this.stage = completionStage;
            this.result = completableFuture;
            this.materializer = materializer;
        }

        private Publisher<E> publisher(Subscription subscription) {
            return subscriber -> {
                this.underlying = subscriber;
                subscriber.onSubscribe(subscription);
            };
        }

        private CompletableFuture<A> completeResultWith(CompletionStage<A> completionStage) {
            completionStage.handleAsync(this.completionHandler);
            return this.result;
        }

        private BiFunction<Accumulator<E, A>, Throwable, Void> handler(Subscription subscription) {
            return (accumulator, throwable) -> {
                if (accumulator != null) {
                    Source.fromPublisher(this.publisher(subscription)).runWith((Graph)accumulator.toSink().mapMaterializedValue(this::completeResultWith), this.materializer);
                } else {
                    subscription.cancel();
                    this.result.completeExceptionally((Throwable)throwable);
                }
                return null;
            };
        }

        public void onSubscribe(Subscription subscription) {
            this.stage.handleAsync(this.handler(subscription));
        }

        public void onError(Throwable throwable) {
            this.underlying.onError(throwable);
        }

        public void onComplete() {
            this.underlying.onComplete();
        }

        public void onNext(E e) {
            this.underlying.onNext(e);
        }
    }

    private static final class NoOpSubscriber<E>
    implements Subscriber<E> {
        private NoOpSubscriber() {
        }

        public void onSubscribe(Subscription subscription) {
        }

        public void onError(Throwable throwable) {
        }

        public void onComplete() {
        }

        public void onNext(E e) {
        }
    }
}

