/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.KeyManagerFactory;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.core.server.ssl.FakeKeyStore$;
import play.core.server.ssl.FakeKeyStore$KeystoreSettings$;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;

public final class FakeKeyStore {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());

    public static X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        return FakeKeyStore$.MODULE$.createSelfSignedCertificate(keyPair);
    }

    public static KeyStore generateKeyStore() {
        return FakeKeyStore$.MODULE$.generateKeyStore();
    }

    public File getKeyStoreFilePath(File appPath) {
        return new File(appPath, FakeKeyStore$KeystoreSettings$.MODULE$.GeneratedKeyStore());
    }

    public boolean shouldGenerate(File keyStoreFile) {
        if (!keyStoreFile.exists()) {
            return true;
        }
        KeyStore store = this.loadKeyStore(keyStoreFile);
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(store.aliases()).asScala().exists((Function1 & Serializable)alias -> Option$.MODULE$.apply((Object)store.getCertificate((String)alias)).exists((Function1 & Serializable)c -> this.certificateTooWeak((Certificate)c)));
    }

    private KeyStore loadKeyStore(File file) {
        KeyStore keyStore = KeyStore.getInstance(FakeKeyStore$KeystoreSettings$.MODULE$.KeystoreType());
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        try {
            keyStore.load(in, "".toCharArray());
        }
        finally {
            this.closeQuietly(in);
        }
        return keyStore;
    }

    public boolean certificateTooWeak(Certificate c) {
        X509Certificate x509;
        PublicKey publicKey = c.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            return true;
        }
        RSAPublicKey k = (RSAPublicKey)publicKey;
        RSAPublicKey key = k;
        boolean weakKey = key.getModulus().bitLength() < FakeKeyStore$KeystoreSettings$.MODULE$.KeyPairKeyLength();
        Certificate certificate = c;
        boolean wrongSigAlg = certificate instanceof X509Certificate ? !(x509 = (X509Certificate)certificate).getSigAlgName().equalsIgnoreCase(FakeKeyStore$KeystoreSettings$.MODULE$.SignatureAlgorithmName()) : true;
        return weakKey || wrongSigAlg;
    }

    public KeyStore createKeyStore(File appPath) {
        KeyStore keyStore;
        File keyStoreFile = this.getKeyStoreFilePath(appPath);
        File keyStoreDir = keyStoreFile.getParentFile();
        this.createKeystoreParentDirectory(keyStoreDir);
        FakeKeyStore fakeKeyStore = this;
        synchronized (fakeKeyStore) {
            KeyStore keyStore2;
            if (this.shouldGenerate(keyStoreFile)) {
                this.logger.info(() -> FakeKeyStore.$anonfun$1(keyStoreFile), MarkerContext$.MODULE$.NoMarker());
                KeyStore freshKeyStore = FakeKeyStore$.MODULE$.generateKeyStore();
                OutputStream out = Files.newOutputStream(keyStoreFile.toPath(), new OpenOption[0]);
                try {
                    freshKeyStore.store(out, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
                }
                finally {
                    this.closeQuietly(out);
                }
                keyStore2 = freshKeyStore;
            } else {
                KeyStore loadedKeyStore = this.loadKeyStore(keyStoreFile);
                this.logger.info(() -> FakeKeyStore.$anonfun$2(keyStoreFile), MarkerContext$.MODULE$.NoMarker());
                keyStore2 = loadedKeyStore;
            }
            keyStore = keyStore2;
        }
        KeyStore keyStore3 = keyStore;
        return keyStore3;
    }

    private void createKeystoreParentDirectory(File keyStoreDir) {
        if (keyStoreDir.mkdirs()) {
            this.logger.debug(() -> FakeKeyStore.createKeystoreParentDirectory$$anonfun$1(keyStoreDir), MarkerContext$.MODULE$.NoMarker());
            return;
        }
        if (keyStoreDir.exists() && keyStoreDir.isDirectory()) {
            this.logger.debug(() -> FakeKeyStore.createKeystoreParentDirectory$$anonfun$2(keyStoreDir), MarkerContext$.MODULE$.NoMarker());
            return;
        }
        if (keyStoreDir.exists() && keyStoreDir.isFile()) {
            throw new IllegalStateException(keyStoreDir + " exists, but it is NOT a directory, making it not possible to generate a key store file.");
        }
        throw new IllegalStateException("Failed to create " + keyStoreDir + ". Check if there is permission to create such folder.");
    }

    public KeyManagerFactory keyManagerFactory(File appPath) {
        KeyStore keyStore = this.createKeyStore(appPath);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
        return kmf;
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.logger.warn(() -> FakeKeyStore.closeQuietly$$anonfun$1(e), MarkerContext$.MODULE$.NoMarker());
        }
    }

    private static final String $anonfun$1(File keyStoreFile$1) {
        return "Generating HTTPS key pair in " + keyStoreFile$1.getAbsolutePath() + " - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.";
    }

    private static final String $anonfun$2(File keyStoreFile$2) {
        return "HTTPS key pair generated in " + keyStoreFile$2.getAbsolutePath() + ".";
    }

    private static final String createKeystoreParentDirectory$$anonfun$1(File keyStoreDir$1) {
        return "Parent directory for keystore successfully created at " + keyStoreDir$1.getAbsolutePath();
    }

    private static final String createKeystoreParentDirectory$$anonfun$2(File keyStoreDir$2) {
        return "No need to create " + keyStoreDir$2 + " since it already exists.";
    }

    private static final String closeQuietly$$anonfun$1(IOException e$1) {
        return "Error closing stream. Cause: " + e$1;
    }
}

