/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Properties;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration$;
import play.api.Environment$;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.NoHttpFiltersComponents;
import play.api.Play$;
import play.api.http.HttpErrorHandler;
import play.api.http.Port;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.DefaultApplicationLifecycle;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.EssentialAction$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.request.RequestTarget;
import play.api.routing.Router;
import play.api.routing.Router$;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.Server$ServerStoppedReason$;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Server$
implements Serializable {
    private static final Logger logger;
    public static final Server$ServerStoppedReason$ ServerStoppedReason;
    public static final Server$ MODULE$;

    private Server$() {
    }

    static {
        MODULE$ = new Server$();
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Server$.class);
    }

    public Tuple2<RequestHeader, Handler> getHandlerFor(RequestHeader request, Try<Application> tryApp, HttpErrorHandler fallbackErrorHandler) {
        Tuple2 tuple2;
        block7: {
            try {
                Application application = (Application)tryApp.get();
                RequestHeader enrichedRequest = application.requestFactory().copyRequestHeader(request);
                try {
                    Tuple2 tuple22 = application.requestHandler().handlerForRequest(enrichedRequest);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    RequestHeader handlerHeader = (RequestHeader)tuple22._1();
                    Handler handler = (Handler)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)handlerHeader, (Object)handler);
                    RequestHeader handlerHeader2 = (RequestHeader)tuple23._1();
                    Handler handler2 = (Handler)tuple23._2();
                    tuple2 = Tuple2$.MODULE$.apply((Object)handlerHeader2, (Object)handler2);
                }
                catch (Throwable ex$) {
                    PartialFunction $2$ = this.handleErrors$1(application.errorHandler(), enrichedRequest);
                    if ($2$.isDefinedAt((Object)ex$)) {
                        tuple2 = (Tuple2)$2$.apply((Object)ex$);
                        break block7;
                    }
                    throw ex$;
                }
            }
            catch (Throwable ex$) {
                PartialFunction $1$ = this.handleErrors$1(fallbackErrorHandler, request);
                if ($1$.isDefinedAt((Object)ex$)) {
                    tuple2 = (Tuple2)$1$.apply((Object)ex$);
                }
                throw ex$;
            }
        }
        return tuple2;
    }

    public Handler actionForResult(Future<Result> errorResult) {
        return EssentialAction$.MODULE$.apply((Function1 & Serializable)_$4 -> Accumulator$.MODULE$.done(errorResult));
    }

    public RequestTarget createUnparsedRequestTarget(String requestUri) {
        return new RequestTarget(requestUri){
            private final String requestUri$1;
            public static final long OFFSET$2;
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private volatile Object uri$lzy1;
            private volatile Object path$lzy1;
            private volatile Object queryMap$lzy1;
            {
                this.requestUri$1 = requestUri$2;
            }

            static {
                OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(anon.2.class.getDeclaredField("queryMap$lzy1"));
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(anon.2.class.getDeclaredField("path$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.2.class.getDeclaredField("uri$lzy1"));
            }

            public URI uri() {
                Object object = this.uri$lzy1;
                if (object instanceof URI) {
                    return (URI)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (URI)this.uri$lzyINIT1();
            }

            private Object uri$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.uri$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            URI uRI = null;
                            try {
                                uRI = new URI(this.uriString());
                                object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.uri$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return uRI;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public String uriString() {
                return this.requestUri$1;
            }

            public String path() {
                Object object = this.path$lzy1;
                if (object instanceof String) {
                    return (String)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (String)this.path$lzyINIT1();
            }

            private Object path$lzyINIT1() {
                Object object;
                block7: {
                    while (true) {
                        if ((object = this.path$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            String string = null;
                            try {
                                String withoutHost = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(this.uriString()), Server$::play$core$server$Server$$anon$2$$_$_$$anonfun$adapted$1);
                                Object object3 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(withoutHost), '?'));
                                String withoutQueryString = (String)ArrayOps$.MODULE$.head$extension(object3);
                                String string2 = string = withoutQueryString.isEmpty() ? "/" : withoutQueryString;
                                object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                            }
                            catch (Throwable throwable) {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.path$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                                throw throwable;
                            }
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.path$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            return string;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public Map queryMap() {
                Object object = this.queryMap$lzy1;
                if (object instanceof Map) {
                    return (Map)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (Map)this.queryMap$lzyINIT1();
            }

            private Object queryMap$lzyINIT1() {
                Object object;
                block10: {
                    while (true) {
                        if ((object = this.queryMap$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            Map map = null;
                            try {
                                if (this.requestUri$1.contains("?")) {
                                    Object object3 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.requestUri$1.split("\\?", 2)[1]), '&'));
                                    Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, Server$::play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$1, ClassTag$.MODULE$.apply(Tuple2.class)));
                                    v0 = (Map)ArrayOps$.MODULE$.groupBy$extension(object4, Server$::play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$2).map(Server$::play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$3);
                                } else {
                                    v0 = map = Predef$.MODULE$.Map().empty();
                                }
                                object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.queryMap$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return map;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$Server$$anon$2$$_$_$$anonfun$adapted$1(java.lang.Object ), play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$1(java.lang.String ), play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$2(scala.Tuple2 ), play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$3(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public RequestHeader tryToEnrichHeader(Try<Application> tryApp, RequestHeader header) {
        RequestHeader requestHeader;
        block5: {
            try {
                Try<Application> try_ = tryApp;
                if (try_ instanceof Success) {
                    Application application = (Application)((Success)try_).value();
                    requestHeader = application.requestFactory().copyRequestHeader(header);
                    break block5;
                }
                if (try_ instanceof Failure) {
                    requestHeader = header;
                    break block5;
                }
                throw new MatchError(try_);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    requestHeader = header;
                }
                throw throwable;
            }
        }
        return requestHeader;
    }

    public long getPossiblyInfiniteBytes(Config config, String path, String deprecatedPath) {
        String string = (String)Configuration$.MODULE$.apply(config).getDeprecated(path, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{deprecatedPath}), ConfigLoader$.MODULE$.stringLoader());
        if ("infinite".equals(string)) {
            return Long.MAX_VALUE;
        }
        return Predef$.MODULE$.Long2long(config.getBytes(config.hasPath(deprecatedPath) ? deprecatedPath : path));
    }

    public String getPossiblyInfiniteBytes$default$3() {
        return "\"\"";
    }

    public FiniteDuration determineServerTerminateTimeout(Option<FiniteDuration> terminationTimeout, FiniteDuration terminationDelay, ActorSystem actorSystem) {
        CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(actorSystem);
        FiniteDuration serviceRequestsDoneTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone());
        FiniteDuration serverTerminateTimeout = (FiniteDuration)terminationTimeout.getOrElse(() -> Server$.$anonfun$2(serviceRequestsDoneTimeout));
        if (serverTerminateTimeout.$greater((Object)serviceRequestsDoneTimeout)) {
            logger.warn(() -> Server$.determineServerTerminateTimeout$$anonfun$1(serverTerminateTimeout, serviceRequestsDoneTimeout), MarkerContext$.MODULE$.NoMarker());
        } else if (terminationDelay.length() > 0L && terminationDelay.$plus(serverTerminateTimeout).$greater((Object)serviceRequestsDoneTimeout)) {
            logger.warn(() -> Server$.determineServerTerminateTimeout$$anonfun$2(terminationDelay, serverTerminateTimeout, serviceRequestsDoneTimeout), MarkerContext$.MODULE$.NoMarker());
        }
        return serverTerminateTimeout;
    }

    public <T> T withApplication(Application application, ServerConfig config, Function1<Port, T> block, ServerProvider provider) {
        Object object;
        Play$.MODULE$.start(application);
        Server server = provider.createServer(config, application);
        try {
            object = block.apply((Object)new Port(BoxesRunTime.unboxToInt((Object)server.httpPort().orElse(() -> Server$.withApplication$$anonfun$1(server)).get())));
        }
        finally {
            server.stop();
        }
        return (T)object;
    }

    public <T> ServerConfig withApplication$default$2() {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ClassLoader classLoader = ServerConfig$.MODULE$.apply$default$1();
        File file = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> option = ServerConfig$.MODULE$.apply$default$4();
        String string = ServerConfig$.MODULE$.apply$default$5();
        Properties properties = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(classLoader, file, (Option<Object>)some, option, string, (Mode)Mode.Test$.MODULE$, properties);
    }

    public <T> T withRouter(ServerConfig config, PartialFunction<RequestHeader, Handler> routes, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.apply(Environment$.MODULE$.simple(config.rootDir(), config.mode()), Configuration$.MODULE$.apply(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        Application application = new NoHttpFiltersComponents(context, routes){
            private final PartialFunction routes$2;
            private Seq httpFilters;
            {
                this.routes$2 = routes$1;
                super(context$1);
                NoHttpFiltersComponents.$init$((NoHttpFiltersComponents)this);
                Statics.releaseFence();
            }

            public Seq httpFilters() {
                return this.httpFilters;
            }

            public void play$api$NoHttpFiltersComponents$_setter_$httpFilters_$eq(Seq x$0) {
                this.httpFilters = x$0;
            }

            public Router router() {
                return Router$.MODULE$.from(this.routes$2);
            }
        }.application();
        return this.withApplication(application, config, block, provider);
    }

    public <T> ServerConfig withRouter$default$1() {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ClassLoader classLoader = ServerConfig$.MODULE$.apply$default$1();
        File file = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> option = ServerConfig$.MODULE$.apply$default$4();
        String string = ServerConfig$.MODULE$.apply$default$5();
        Properties properties = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(classLoader, file, (Option<Object>)some, option, string, (Mode)Mode.Test$.MODULE$, properties);
    }

    public <T> T withRouterFromComponents(ServerConfig config, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> routes, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.apply(Environment$.MODULE$.simple(config.rootDir(), config.mode()), Configuration$.MODULE$.apply(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        Application application = new NoHttpFiltersComponents(context, routes){
            private final Function1 routes$4;
            private Seq httpFilters;
            {
                this.routes$4 = routes$3;
                super(context$2);
                NoHttpFiltersComponents.$init$((NoHttpFiltersComponents)this);
                Statics.releaseFence();
            }

            public Seq httpFilters() {
                return this.httpFilters;
            }

            public void play$api$NoHttpFiltersComponents$_setter_$httpFilters_$eq(Seq x$0) {
                this.httpFilters = x$0;
            }

            public Router router() {
                return Router$.MODULE$.from((PartialFunction)this.routes$4.apply((Object)((Object)this)));
            }
        }.application();
        return this.withApplication(application, config, block, provider);
    }

    public <T> ServerConfig withRouterFromComponents$default$1() {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ClassLoader classLoader = ServerConfig$.MODULE$.apply$default$1();
        File file = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> option = ServerConfig$.MODULE$.apply$default$4();
        String string = ServerConfig$.MODULE$.apply$default$5();
        Properties properties = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(classLoader, file, (Option<Object>)some, option, string, (Mode)Mode.Test$.MODULE$, properties);
    }

    public <T> T withApplicationFromContext(ServerConfig config, Function1<ApplicationLoader.Context, Application> appProducer, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.apply(Environment$.MODULE$.simple(config.rootDir(), config.mode()), Configuration$.MODULE$.apply(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        return this.withApplication((Application)appProducer.apply((Object)context), config, block, provider);
    }

    public <T> ServerConfig withApplicationFromContext$default$1() {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ClassLoader classLoader = ServerConfig$.MODULE$.apply$default$1();
        File file = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> option = ServerConfig$.MODULE$.apply$default$4();
        String string = ServerConfig$.MODULE$.apply$default$5();
        Properties properties = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(classLoader, file, (Option<Object>)some, option, string, (Mode)Mode.Test$.MODULE$, properties);
    }

    public boolean routeModifierDefersBodyParsing(boolean global, RequestHeader rh) {
        return (global || Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(Router.RequestImplicits$.MODULE$.WithHandlerDef(rh), "deferBodyParsing")) && !Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(Router.RequestImplicits$.MODULE$.WithHandlerDef(rh), "dontDeferBodyParsing");
    }

    private final PartialFunction handleErrors$1(HttpErrorHandler errorHandler, RequestHeader req) {
        return new Serializable(errorHandler, req){
            private final HttpErrorHandler errorHandler$1;
            private final RequestHeader req$1;
            {
                this.errorHandler$1 = errorHandler$2;
                this.req$1 = req$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof ThreadDeath) {
                    ThreadDeath e = (ThreadDeath)throwable;
                    return true;
                }
                if (throwable instanceof VirtualMachineError) {
                    VirtualMachineError e = (VirtualMachineError)throwable;
                    return true;
                }
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ThreadDeath) {
                    ThreadDeath e = (ThreadDeath)throwable;
                    throw e;
                }
                if (throwable instanceof VirtualMachineError) {
                    VirtualMachineError e = (VirtualMachineError)throwable;
                    throw e;
                }
                if (throwable != null) {
                    Throwable e = throwable;
                    Future errorResult = this.errorHandler$1.onServerError(this.req$1, e);
                    Handler errorAction = Server$.MODULE$.actionForResult((Future<Result>)errorResult);
                    return Tuple2$.MODULE$.apply((Object)this.req$1, (Object)errorAction);
                }
                return function1.apply((Object)x);
            }
        };
    }

    private static final /* synthetic */ boolean $anonfun$1(char _$5) {
        return _$5 != '/';
    }

    public static /* bridge */ /* synthetic */ boolean play$core$server$Server$$anon$2$$_$_$$anonfun$adapted$1(Object _$5) {
        return Server$.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5));
    }

    public static final /* synthetic */ Tuple2 play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$1(String keyPair) {
        String[] stringArray = keyPair.split("=", 2);
        if (stringArray != null) {
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                String string;
                String key = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"");
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String key = string;
                String value = string3;
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)value);
            }
        }
        throw new MatchError((Object)stringArray);
    }

    public static final /* synthetic */ String play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$2(Tuple2 _$6) {
        return (String)_$6._1();
    }

    public static final /* synthetic */ Tuple2 play$core$server$Server$$anon$2$$_$queryMap$lzyINIT1$$anonfun$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Object[] values = (Tuple2[])tuple2._2();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
            Object object = Predef$.MODULE$.refArrayOps(values);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$7 -> (String)_$7._2(), ClassTag$.MODULE$.apply(String.class)));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ArrayOps$.MODULE$.toSeq$extension(object2));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final FiniteDuration $anonfun$2(FiniteDuration serviceRequestsDoneTimeout$1) {
        return serviceRequestsDoneTimeout$1;
    }

    private static final String determineServerTerminateTimeout$$anonfun$1(FiniteDuration serverTerminateTimeout$1, FiniteDuration serviceRequestsDoneTimeout$2) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The value for `play.server.terminationTimeout` [" + serverTerminateTimeout$1 + "] is higher than the total `service-requests-done.timeout` duration [" + serviceRequestsDoneTimeout$2 + "].\n           |Set `pekko.coordinated-shutdown.phases.service-requests-done.timeout` to an equal (or greater) value to prevent unexpected server termination."));
    }

    private static final String determineServerTerminateTimeout$$anonfun$2(FiniteDuration terminationDelay$1, FiniteDuration serverTerminateTimeout$2, FiniteDuration serviceRequestsDoneTimeout$3) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The total of `play.server.waitBeforeTermination` [" + terminationDelay$1 + "]` and `play.server.terminationTimeout` [" + serverTerminateTimeout$2 + "], which is " + terminationDelay$1.$plus(serverTerminateTimeout$2) + ", is higher than the total `service-requests-done.timeout` duration [" + serviceRequestsDoneTimeout$3 + "].\n           |Set `pekko.coordinated-shutdown.phases.service-requests-done.timeout` to an equal (or greater) value to prevent unexpected server termination."));
    }

    private static final Option withApplication$$anonfun$1(Server server$1) {
        return server$1.httpsPort();
    }
}

