/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.Serializable;
import org.apache.pekko.annotation.ApiMayChange;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoints$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public final class ServerEndpoints
implements Product,
Serializable {
    private final Seq endpoints;
    private final Option httpEndpoint;
    private final Option httpsEndpoint;

    public static ServerEndpoints apply(Seq<ServerEndpoint> seq) {
        return ServerEndpoints$.MODULE$.apply(seq);
    }

    public static ServerEndpoints empty() {
        return ServerEndpoints$.MODULE$.empty();
    }

    public static ServerEndpoints fromProduct(Product product) {
        return ServerEndpoints$.MODULE$.fromProduct(product);
    }

    public static ServerEndpoints unapply(ServerEndpoints serverEndpoints) {
        return ServerEndpoints$.MODULE$.unapply(serverEndpoints);
    }

    public ServerEndpoints(Seq<ServerEndpoint> endpoints) {
        this.endpoints = endpoints;
        this.httpEndpoint = this.endpointForScheme("http");
        this.httpsEndpoint = this.endpointForScheme("https");
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerEndpoints)) return false;
        ServerEndpoints serverEndpoints = (ServerEndpoints)object;
        Seq<ServerEndpoint> seq = this.endpoints();
        Seq<ServerEndpoint> seq2 = serverEndpoints.endpoints();
        if (seq != null) {
            if (!seq.equals(seq2)) return false;
            return true;
        }
        if (seq2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerEndpoints;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ServerEndpoints";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "endpoints";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Seq<ServerEndpoint> endpoints() {
        return this.endpoints;
    }

    private Option<ServerEndpoint> endpointForScheme(String scheme) {
        return this.endpoints().find((Function1 & Serializable)_$1 -> {
            String string = _$1.scheme();
            String string2 = scheme;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<ServerEndpoint> httpEndpoint() {
        return this.httpEndpoint;
    }

    public Option<ServerEndpoint> httpsEndpoint() {
        return this.httpsEndpoint;
    }

    public ServerEndpoints copy(Seq<ServerEndpoint> endpoints) {
        return new ServerEndpoints(endpoints);
    }

    public Seq<ServerEndpoint> copy$default$1() {
        return this.endpoints();
    }

    public Seq<ServerEndpoint> _1() {
        return this.endpoints();
    }
}

