/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import play.core.server.ssl.FakeKeyStore$KeystoreSettings$;
import play.core.server.ssl.FakeKeyStore$SelfSigned$;
import play.core.server.ssl.FakeKeyStore$SelfSigned$Alias$;
import scala.Array$;

public final class FakeKeyStore$ {
    public static final FakeKeyStore$ MODULE$ = new FakeKeyStore$();
    private static final char[] play$core$server$ssl$FakeKeyStore$$EMPTY_PASSWORD = Array$.MODULE$.emptyCharArray();

    public char[] play$core$server$ssl$FakeKeyStore$$EMPTY_PASSWORD() {
        return play$core$server$ssl$FakeKeyStore$$EMPTY_PASSWORD;
    }

    public String play$core$server$ssl$FakeKeyStore$$fileInDevModeDir(String filename) {
        return "target" + File.separatorChar + "dev-mode" + File.separatorChar + filename;
    }

    public KeyStore generateKeyStore() {
        KeyStore keyStore = KeyStore.getInstance(FakeKeyStore$KeystoreSettings$.MODULE$.KeystoreType());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(FakeKeyStore$KeystoreSettings$.MODULE$.KeyPairAlgorithmName());
        keyPairGenerator.initialize(FakeKeyStore$KeystoreSettings$.MODULE$.KeyPairKeyLength());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate cert = this.createSelfSignedCertificate(keyPair);
        keyStore.load(null, FakeKeyStore$KeystoreSettings$.MODULE$.keystorePassword());
        keyStore.setKeyEntry(FakeKeyStore$SelfSigned$Alias$.MODULE$.PrivateKeyEntry(), keyPair.getPrivate(), FakeKeyStore$SelfSigned$.MODULE$.keyPassword(), (Certificate[])((Object[])new Certificate[]{cert}));
        keyStore.setCertificateEntry(FakeKeyStore$SelfSigned$Alias$.MODULE$.trustedCertEntry(), cert);
        return keyStore;
    }

    public X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + 1576800000000L);
        BigInteger serial = new BigInteger(160, new SecureRandom());
        X500Name owner = new X500Name(FakeKeyStore$SelfSigned$.MODULE$.DistinguishedName());
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, serial, validFrom, validTo, owner, keyPair.getPublic());
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(keyPair.getPublic()));
        GeneralNames sans = new GeneralNames((GeneralName[])((Object[])new GeneralName[]{new GeneralName(2, "localhost"), new GeneralName(7, "127.0.0.1"), new GeneralName(7, "::1")}));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)sans);
        ContentSigner signer = new JcaContentSignerBuilder(FakeKeyStore$KeystoreSettings$.MODULE$.SignatureAlgorithmName()).build(keyPair.getPrivate());
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        cert.verify(keyPair.getPublic());
        return cert;
    }

    private FakeKeyStore$() {
    }
}

