/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Properties;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment$;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.NoHttpFiltersComponents;
import play.api.Play$;
import play.api.http.HttpErrorHandler;
import play.api.http.Port;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.DefaultApplicationLifecycle;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.EssentialAction$;
import play.api.mvc.EssentialFilter;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.request.RequestTarget;
import play.api.routing.Router;
import play.api.routing.Router$;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Server$ {
    public static final Server$ MODULE$ = new Server$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public Tuple2<RequestHeader, Handler> getHandlerFor(RequestHeader request, Try<Application> tryApp, HttpErrorHandler fallbackErrorHandler) {
        Tuple2 tuple2;
        block7: {
            try {
                Application application = (Application)tryApp.get();
                RequestHeader enrichedRequest = application.requestFactory().copyRequestHeader(request);
                try {
                    Tuple2 tuple22 = application.requestHandler().handlerForRequest(enrichedRequest);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    RequestHeader handlerHeader = (RequestHeader)tuple22._1();
                    Handler handler = (Handler)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)handlerHeader, (Object)handler);
                    RequestHeader handlerHeader2 = (RequestHeader)tuple23._1();
                    Handler handler2 = (Handler)tuple23._2();
                    tuple2 = new Tuple2((Object)handlerHeader2, (Object)handler2);
                }
                catch (Throwable x$13) {
                    PartialFunction catchExpr$1 = Server$.handleErrors$1(application.errorHandler(), enrichedRequest);
                    if (catchExpr$1.isDefinedAt((Object)x$13)) {
                        tuple2 = (Tuple2)catchExpr$1.apply((Object)x$13);
                        break block7;
                    }
                    throw x$13;
                }
            }
            catch (Throwable x$14) {
                PartialFunction catchExpr$2 = Server$.handleErrors$1(fallbackErrorHandler, request);
                if (catchExpr$2.isDefinedAt((Object)x$14)) {
                    tuple2 = (Tuple2)catchExpr$2.apply((Object)x$14);
                }
                throw x$14;
            }
        }
        return tuple2;
    }

    public Handler actionForResult(Future<Result> errorResult) {
        return EssentialAction$.MODULE$.apply((Function1 & Serializable)x$5 -> Accumulator$.MODULE$.done(errorResult));
    }

    public RequestTarget createUnparsedRequestTarget(String requestUri) {
        return new RequestTarget(requestUri){
            private URI uri;
            private String path;
            private Map<String, Seq<String>> queryMap;
            private volatile byte bitmap$0;
            private final String requestUri$1;

            public String queryString() {
                return RequestTarget.queryString$((RequestTarget)this);
            }

            public Option<String> getQueryParameter(String key) {
                return RequestTarget.getQueryParameter$((RequestTarget)this, (String)key);
            }

            public RequestTarget withUri(URI newUri) {
                return RequestTarget.withUri$((RequestTarget)this, (URI)newUri);
            }

            public RequestTarget withUriString(String newUriString) {
                return RequestTarget.withUriString$((RequestTarget)this, (String)newUriString);
            }

            public RequestTarget withPath(String newPath) {
                return RequestTarget.withPath$((RequestTarget)this, (String)newPath);
            }

            public RequestTarget withQueryString(Map<String, Seq<String>> newQueryString) {
                return RequestTarget.withQueryString$((RequestTarget)this, newQueryString);
            }

            private URI uri$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.uri = new URI(this.uriString());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.uri;
            }

            public URI uri() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.uri$lzycompute();
                }
                return this.uri;
            }

            public String uriString() {
                return this.requestUri$1;
            }

            /*
             * WARNING - void declaration
             */
            private String path$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        void var3_3;
                        String withoutHost = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(this.uriString()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$path$1(BoxesRunTime.unboxToChar((Object)x$6))));
                        String withoutQueryString = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(withoutHost), '?')));
                        this.path = withoutQueryString.isEmpty() ? "/" : var3_3;
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.path;
            }

            public String path() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.path$lzycompute();
                }
                return this.path;
            }

            private Map<String, Seq<String>> queryMap$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 4) == 0) {
                        this.queryMap = this.requestUri$1.contains("?") ? (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.requestUri$1.split("\\?", 2)[1]), '&')), (Function1 & Serializable)keyPair -> {
                            Object object;
                            Object object2;
                            String[] stringArray = keyPair.split("=", 2);
                            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0) {
                                String key = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)"");
                            }
                            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                                String key = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                            }
                            throw new MatchError((Object)stringArray);
                        }, ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$7 -> (String)x$7._1()).map((Function1 & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Tuple2[] values = (Tuple2[])tuple2._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x$8 -> (String)x$8._2(), ClassTag$.MODULE$.apply(String.class)))));
                            }
                            throw new MatchError((Object)tuple2);
                        }) : Predef$.MODULE$.Map().empty();
                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                    }
                }
                return this.queryMap;
            }

            public Map<String, Seq<String>> queryMap() {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    return this.queryMap$lzycompute();
                }
                return this.queryMap;
            }

            public static final /* synthetic */ boolean $anonfun$path$1(char x$6) {
                return x$6 != '/';
            }
            {
                this.requestUri$1 = requestUri$1;
                RequestTarget.$init$((RequestTarget)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$path$1$adapted(java.lang.Object ), $anonfun$queryMap$1(java.lang.String ), $anonfun$queryMap$2(scala.Tuple2 ), $anonfun$queryMap$3(scala.Tuple2 ), $anonfun$queryMap$4(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public RequestHeader tryToEnrichHeader(Try<Application> tryApp, RequestHeader header) {
        RequestHeader requestHeader;
        block5: {
            try {
                Try<Application> try_ = tryApp;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Application application = (Application)success.value();
                    requestHeader = application.requestFactory().copyRequestHeader(header);
                    break block5;
                }
                if (try_ instanceof Failure) {
                    requestHeader = header;
                    break block5;
                }
                throw new MatchError(try_);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    requestHeader = header;
                }
                throw throwable;
            }
        }
        return requestHeader;
    }

    public long getPossiblyInfiniteBytes(Config config, String path, String deprecatedPath) {
        String string = (String)new Configuration(config).getDeprecated(path, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{deprecatedPath}), ConfigLoader$.MODULE$.stringLoader());
        switch (string == null ? 0 : string.hashCode()) {
            case 173173268: {
                if (!"infinite".equals(string)) break;
                return Long.MAX_VALUE;
            }
        }
        return Predef$.MODULE$.Long2long(config.getBytes(config.hasPath(deprecatedPath) ? deprecatedPath : path));
    }

    public String getPossiblyInfiniteBytes$default$3() {
        return "\"\"";
    }

    public FiniteDuration determineServerTerminateTimeout(Option<FiniteDuration> terminationTimeout, FiniteDuration terminationDelay, ActorSystem actorSystem) {
        FiniteDuration serverTerminateTimeout;
        block1: {
            FiniteDuration serviceRequestsDoneTimeout;
            block0: {
                CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(actorSystem);
                serviceRequestsDoneTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone());
                serverTerminateTimeout = (FiniteDuration)terminationTimeout.getOrElse((Function0 & Serializable)() -> serviceRequestsDoneTimeout);
                if (!serverTerminateTimeout.$greater((Object)serviceRequestsDoneTimeout)) break block0;
                this.logger().warn((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The value for `play.server.terminationTimeout` [" + serverTerminateTimeout + "] is higher than the total `service-requests-done.timeout` duration [" + serviceRequestsDoneTimeout + "].\n           |Set `pekko.coordinated-shutdown.phases.service-requests-done.timeout` to an equal (or greater) value to prevent unexpected server termination.")), MarkerContext$.MODULE$.NoMarker());
                break block1;
            }
            if (terminationDelay.length() <= 0L || !terminationDelay.$plus(serverTerminateTimeout).$greater((Object)serviceRequestsDoneTimeout)) break block1;
            this.logger().warn((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The total of `play.server.waitBeforeTermination` [" + terminationDelay + "]` and `play.server.terminationTimeout` [" + serverTerminateTimeout + "], which is " + terminationDelay.$plus(serverTerminateTimeout) + ", is higher than the total `service-requests-done.timeout` duration [" + serviceRequestsDoneTimeout + "].\n           |Set `pekko.coordinated-shutdown.phases.service-requests-done.timeout` to an equal (or greater) value to prevent unexpected server termination.")), MarkerContext$.MODULE$.NoMarker());
        }
        return serverTerminateTimeout;
    }

    public <T> T withApplication(Application application, ServerConfig config, Function1<Port, T> block, ServerProvider provider) {
        Object object;
        Play$.MODULE$.start(application);
        Server server = provider.createServer(config, application);
        try {
            object = block.apply((Object)new Port(BoxesRunTime.unboxToInt((Object)server.httpPort().orElse((Function0 & Serializable)() -> server.httpsPort()).get())));
        }
        finally {
            server.stop();
        }
        return (T)object;
    }

    public <T> ServerConfig withApplication$default$2() {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Mode.Test$ x$2 = Mode.Test$.MODULE$;
        ClassLoader x$3 = ServerConfig$.MODULE$.apply$default$1();
        File x$4 = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> x$5 = ServerConfig$.MODULE$.apply$default$4();
        String x$6 = ServerConfig$.MODULE$.apply$default$5();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(x$3, x$4, (Option<Object>)x$1, x$5, x$6, (Mode)x$2, x$7);
    }

    public <T> T withRouter(ServerConfig config, PartialFunction<RequestHeader, Handler> routes, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = new ApplicationLoader.Context(Environment$.MODULE$.simple(config.rootDir(), config.mode()), new Configuration(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        Application application = new NoHttpFiltersComponents(context, routes){
            private Seq<EssentialFilter> httpFilters;
            private final PartialFunction routes$1;

            public Seq<EssentialFilter> httpFilters() {
                return this.httpFilters;
            }

            public void play$api$NoHttpFiltersComponents$_setter_$httpFilters_$eq(Seq<EssentialFilter> x$1) {
                this.httpFilters = x$1;
            }

            public Router router() {
                return Router$.MODULE$.from(this.routes$1);
            }
            {
                this.routes$1 = routes$1;
                super(context$1);
                NoHttpFiltersComponents.$init$((NoHttpFiltersComponents)this);
                Statics.releaseFence();
            }
        }.application();
        return this.withApplication(application, config, block, provider);
    }

    public <T> ServerConfig withRouter$default$1() {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Mode.Test$ x$2 = Mode.Test$.MODULE$;
        ClassLoader x$3 = ServerConfig$.MODULE$.apply$default$1();
        File x$4 = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> x$5 = ServerConfig$.MODULE$.apply$default$4();
        String x$6 = ServerConfig$.MODULE$.apply$default$5();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(x$3, x$4, (Option<Object>)x$1, x$5, x$6, (Mode)x$2, x$7);
    }

    public <T> T withRouterFromComponents(ServerConfig config, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> routes, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = new ApplicationLoader.Context(Environment$.MODULE$.simple(config.rootDir(), config.mode()), new Configuration(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        Application application = new NoHttpFiltersComponents(context, routes){
            private Seq<EssentialFilter> httpFilters;
            private final Function1 routes$2;

            public Seq<EssentialFilter> httpFilters() {
                return this.httpFilters;
            }

            public void play$api$NoHttpFiltersComponents$_setter_$httpFilters_$eq(Seq<EssentialFilter> x$1) {
                this.httpFilters = x$1;
            }

            public Router router() {
                return Router$.MODULE$.from((PartialFunction)this.routes$2.apply((Object)((Object)this)));
            }
            {
                this.routes$2 = routes$2;
                super(context$2);
                NoHttpFiltersComponents.$init$((NoHttpFiltersComponents)this);
                Statics.releaseFence();
            }
        }.application();
        return this.withApplication(application, config, block, provider);
    }

    public <T> ServerConfig withRouterFromComponents$default$1() {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Mode.Test$ x$2 = Mode.Test$.MODULE$;
        ClassLoader x$3 = ServerConfig$.MODULE$.apply$default$1();
        File x$4 = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> x$5 = ServerConfig$.MODULE$.apply$default$4();
        String x$6 = ServerConfig$.MODULE$.apply$default$5();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(x$3, x$4, (Option<Object>)x$1, x$5, x$6, (Mode)x$2, x$7);
    }

    public <T> T withApplicationFromContext(ServerConfig config, Function1<ApplicationLoader.Context, Application> appProducer, Function1<Port, T> block, ServerProvider provider) {
        ApplicationLoader.Context context = new ApplicationLoader.Context(Environment$.MODULE$.simple(config.rootDir(), config.mode()), new Configuration(ConfigFactory.load()), (ApplicationLifecycle)new DefaultApplicationLifecycle(), (Option)None$.MODULE$);
        return this.withApplication((Application)appProducer.apply((Object)context), config, block, provider);
    }

    public <T> ServerConfig withApplicationFromContext$default$1() {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Mode.Test$ x$2 = Mode.Test$.MODULE$;
        ClassLoader x$3 = ServerConfig$.MODULE$.apply$default$1();
        File x$4 = ServerConfig$.MODULE$.apply$default$2();
        Option<Object> x$5 = ServerConfig$.MODULE$.apply$default$4();
        String x$6 = ServerConfig$.MODULE$.apply$default$5();
        Properties x$7 = ServerConfig$.MODULE$.apply$default$7();
        return ServerConfig$.MODULE$.apply(x$3, x$4, (Option<Object>)x$1, x$5, x$6, (Mode)x$2, x$7);
    }

    public boolean routeModifierDefersBodyParsing(boolean global, RequestHeader rh) {
        return (global || Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(Router.RequestImplicits$.MODULE$.WithHandlerDef(rh), "deferBodyParsing")) && !Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(Router.RequestImplicits$.MODULE$.WithHandlerDef(rh), "dontDeferBodyParsing");
    }

    private static final PartialFunction handleErrors$1(HttpErrorHandler errorHandler, RequestHeader req) {
        return new Serializable(errorHandler, req){
            private static final long serialVersionUID = 0L;
            private final HttpErrorHandler errorHandler$1;
            private final RequestHeader req$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ThreadDeath) {
                    ThreadDeath threadDeath = (ThreadDeath)A1;
                    throw threadDeath;
                }
                if (A1 instanceof VirtualMachineError) {
                    VirtualMachineError virtualMachineError = (VirtualMachineError)A1;
                    throw virtualMachineError;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    Future errorResult = this.errorHandler$1.onServerError(this.req$1, A12);
                    Handler errorAction = Server$.MODULE$.actionForResult((Future<Result>)errorResult);
                    return (B1)new Tuple2((Object)this.req$1, (Object)errorAction);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof ThreadDeath) {
                    return true;
                }
                if (throwable instanceof VirtualMachineError) {
                    return true;
                }
                return throwable != null;
            }
            {
                this.errorHandler$1 = errorHandler$1;
                this.req$1 = req$1;
            }
        };
    }

    private Server$() {
    }
}

