/*
 * Decompiled with CFR 0.152.
 */
package play.routes.compiler;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.regex.Pattern;
import play.routes.compiler.DynamicPart;
import play.routes.compiler.DynamicPart$;
import play.routes.compiler.Parameter;
import play.routes.compiler.PathPart;
import play.routes.compiler.Route;
import play.routes.compiler.RoutesCompilationError;
import play.routes.compiler.RoutesCompilationError$;
import play.routes.compiler.RoutesFileParser;
import play.routes.compiler.Rule;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.input.Reader;

public final class RoutesFileParser$
implements Serializable {
    public static final RoutesFileParser$ MODULE$ = new RoutesFileParser$();

    private RoutesFileParser$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RoutesFileParser$.class);
    }

    public Either<Seq<RoutesCompilationError>, List<Rule>> parse(File routesFile) {
        String routesContent = new String(Files.readAllBytes(routesFile.toPath()), Charset.defaultCharset());
        return this.parseContent(routesContent, routesFile);
    }

    public Either<Seq<RoutesCompilationError>, List<Rule>> parseContent(String routesContent, File routesFile) {
        Option option;
        RoutesFileParser parser = new RoutesFileParser();
        Parsers.ParseResult<List<Rule>> parseResult = parser.parse(routesContent);
        if (parseResult instanceof Parsers.Success && ((Parsers.Success)parseResult).scala$util$parsing$combinator$Parsers$Success$$$outer() == parser) {
            Parsers.Success success = parser.Success().unapply((Parsers.Success)parseResult);
            List list = (List)success._1();
            Reader reader = success._2();
            if (list instanceof List) {
                List parsed = list;
                Seq<RoutesCompilationError> seq = this.validate(routesFile, (List<Route>)parsed.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Rule x) {
                        Rule rule = x;
                        if (rule instanceof Route) {
                            Route r = (Route)rule;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Rule x, Function1 function1) {
                        Rule rule = x;
                        if (rule instanceof Route) {
                            Route r = (Route)rule;
                            return r;
                        }
                        return function1.apply((Object)x);
                    }
                }));
                Nil$ nil$ = package$.MODULE$.Nil();
                Seq<RoutesCompilationError> seq2 = seq;
                if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                    return package$.MODULE$.Right().apply((Object)parsed);
                }
                Seq<RoutesCompilationError> errors = seq;
                return package$.MODULE$.Left().apply(errors);
            }
        }
        if (parseResult != null && !(option = parser.NoSuccess().unapply(parseResult)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            String message = (String)tuple2._1();
            Reader in = (Reader)tuple2._2();
            return package$.MODULE$.Left().apply((Object)((SeqOps)new .colon.colon((Object)RoutesCompilationError$.MODULE$.apply(routesFile, message, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)in.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)in.pos().column()))), (List)Nil$.MODULE$)));
        }
        throw new MatchError(parseResult);
    }

    private Seq<RoutesCompilationError> validate(File file, List<Route> routes) {
        ListBuffer errors = ListBuffer$.MODULE$.empty();
        routes.foreach((Function1 & Serializable)route -> {
            if (route.call().controller().isEmpty()) {
                errors.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(file, "Missing Controller", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)route.call().pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)route.call().pos().column()))));
            }
            route.call().parameters().flatMap((Function1 & Serializable)_$1 -> _$1.find((Function1 & Serializable)_$2 -> _$2.isJavaRequest())).map((Function1)(JProcedure1 & Serializable)p -> {
                if (p.fixed().isDefined() || p.default().isDefined()) {
                    errors.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(file, "It is not allowed to specify a fixed or default value for parameter: '" + p.name() + "'", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().column()))));
                    return;
                }
            });
            return (Seq)route.path().parts().collect((PartialFunction)new Serializable((Route)route, errors, file){
                private final Route route$1;
                private final ListBuffer errors$3;
                private final File file$3;
                {
                    this.route$1 = route$2;
                    this.errors$3 = errors$5;
                    this.file$3 = file$5;
                }

                public final boolean isDefinedAt(PathPart x) {
                    PathPart pathPart = x;
                    if (pathPart instanceof DynamicPart) {
                        DynamicPart dynamicPart = (DynamicPart)pathPart;
                        DynamicPart dynamicPart2 = DynamicPart$.MODULE$.unapply(dynamicPart);
                        String string = dynamicPart2._1();
                        String string2 = dynamicPart2._2();
                        boolean bl = dynamicPart2._3();
                        String name = string;
                        String regex = string2;
                        DynamicPart part = dynamicPart;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(PathPart x, Function1 function1) {
                    PathPart pathPart = x;
                    if (pathPart instanceof DynamicPart) {
                        DynamicPart dynamicPart = (DynamicPart)pathPart;
                        DynamicPart dynamicPart2 = DynamicPart$.MODULE$.unapply(dynamicPart);
                        String string = dynamicPart2._1();
                        String string2 = dynamicPart2._2();
                        boolean bl = dynamicPart2._3();
                        String name = string;
                        String regex = string2;
                        DynamicPart part = dynamicPart;
                        return ((IterableOnceOps)this.route$1.call().parameters().getOrElse(RoutesFileParser$::play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$1)).find(arg_0 -> RoutesFileParser$.play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$2(name, arg_0)).map((Function1 & Serializable)p -> {
                            Serializable serializable;
                            if (p.isJavaRequest()) {
                                this.errors$3.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(this.file$3, "It is not allowed to specify a value extracted from the path for parameter: '" + name + "'", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().column()))));
                            } else if (p.fixed().isDefined() || p.default().isDefined()) {
                                this.errors$3.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(this.file$3, "It is not allowed to specify a fixed or default value for parameter: '" + name + "' extracted from the path", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p.pos().column()))));
                            }
                            try {
                                serializable = Pattern.compile(regex);
                            }
                            catch (Exception e) {
                                serializable = (Serializable)this.errors$3.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(this.file$3, e.getMessage(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)part.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)part.pos().column()))));
                            }
                            return serializable;
                        }).getOrElse(() -> this.applyOrElse$$anonfun$4(name, part));
                    }
                    return function1.apply((Object)x);
                }

                private final Serializable applyOrElse$$anonfun$4(String name$3, DynamicPart part$2) {
                    return (Serializable)this.errors$3.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(this.file$3, "Missing parameter in call definition: " + name$3, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)part$2.pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)part$2.pos().column()))));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$1(), play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$2(java.lang.String play.routes.compiler.Parameter ), applyOrElse$$anonfun$3(java.lang.String java.lang.String play.routes.compiler.DynamicPart play.routes.compiler.Parameter ), applyOrElse$$anonfun$4(java.lang.String play.routes.compiler.DynamicPart )}, serializedLambda);
                }
            });
        });
        Map sameHandlerMethodGroup = routes.groupBy((Function1 & Serializable)r -> Tuple3$.MODULE$.apply(r.call().packageName(), (Object)r.call().controller(), (Object)r.call().method()));
        Map sameHandlerMethodParameterCountGroup = sameHandlerMethodGroup.groupBy((Function1 & Serializable)g -> Tuple2$.MODULE$.apply(g._1(), (Object)((IterableOps)g._2()).groupBy((Function1 & Serializable)route -> BoxesRunTime.unboxToInt((Object)route.call().parameters().map((Function1 & Serializable)p -> p.length()).getOrElse(RoutesFileParser$::$anonfun$3$$anonfun$1$$anonfun$2)))));
        sameHandlerMethodParameterCountGroup.find((Function1 & Serializable)g -> ((IterableOnceOps)((Tuple2)g._1())._2()).size() > 1).foreach((Function1 & Serializable)overloadedRouteGroup -> {
            Route firstOverloadedRoute = (Route)((IterableOps)((MapOps)overloadedRouteGroup._2()).values().head()).head();
            return (ListBuffer)errors.$plus$eq((Object)RoutesCompilationError$.MODULE$.apply(file, "Using different overloaded methods is not allowed. If you are using a single method in combination with default parameters, make sure you declare them all explicitly.", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)firstOverloadedRoute.call().pos().line())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)firstOverloadedRoute.call().pos().column()))));
        });
        return errors.toList();
    }

    public static final Seq play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    public static final /* synthetic */ boolean play$routes$compiler$RoutesFileParser$$anon$3$$_$applyOrElse$$anonfun$2(String name$1, Parameter _$3) {
        String string = _$3.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final int $anonfun$3$$anonfun$1$$anonfun$2() {
        return 0;
    }
}

