/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.play;

import java.io.Serializable;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameData$;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEvent$;
import org.apache.pekko.http.impl.engine.ws.FrameEventParser$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.FrameStart$;
import org.apache.pekko.http.impl.engine.ws.Protocol;
import org.apache.pekko.http.impl.engine.ws.UpgradeToWebSocketLowLevel;
import org.apache.pekko.http.play.WebSocketHandler$;
import org.apache.pekko.http.play.WebSocketHandler$Frame$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ws.UpgradeToWebSocket;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Merge$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.websocket.BinaryMessage;
import play.api.http.websocket.BinaryMessage$;
import play.api.http.websocket.CloseMessage;
import play.api.http.websocket.CloseMessage$;
import play.api.http.websocket.Message;
import play.api.http.websocket.PingMessage;
import play.api.http.websocket.PingMessage$;
import play.api.http.websocket.PongMessage;
import play.api.http.websocket.PongMessage$;
import play.api.http.websocket.TextMessage;
import play.api.http.websocket.TextMessage$;
import play.api.libs.streams.PekkoStreams$;
import play.core.server.common.WebSocketFlowHandler;
import play.core.server.common.WebSocketFlowHandler$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WebSocketHandler$
implements Serializable {
    private static final WebSocketHandler$Frame$ Frame;
    public static final WebSocketHandler$ MODULE$;

    private WebSocketHandler$() {
    }

    static {
        MODULE$ = new WebSocketHandler$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WebSocketHandler$.class);
    }

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit) {
        return this.handleWebSocket(upgrade, flow, bufferLimit, (Option<String>)None$.MODULE$);
    }

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit, Option<String> subprotocol) {
        return this.handleWebSocket(upgrade, flow, bufferLimit, subprotocol, "ping", (Duration)Duration$.MODULE$.Inf());
    }

    public HttpResponse handleWebSocket(UpgradeToWebSocket upgrade, Flow<Message, Message, ?> flow, int bufferLimit, Option<String> subprotocol, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle) {
        UpgradeToWebSocket upgradeToWebSocket = upgrade;
        if (upgradeToWebSocket instanceof UpgradeToWebSocketLowLevel) {
            UpgradeToWebSocketLowLevel lowLevel = (UpgradeToWebSocketLowLevel)upgradeToWebSocket;
            return lowLevel.handleFrames(this.messageFlowToFrameFlow(flow, bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle), subprotocol);
        }
        UpgradeToWebSocket other = upgradeToWebSocket;
        throw new IllegalArgumentException("UpgradeToWebsocket is not an Pekko HTTP UpgradeToWebsocketLowLevel");
    }

    public Flow<FrameEvent, FrameEvent, ?> messageFlowToFrameFlow(Flow<Message, Message, ?> flow, int bufferLimit) {
        return this.messageFlowToFrameFlow(flow, bufferLimit, "ping", (Duration)Duration$.MODULE$.Inf());
    }

    public Flow<FrameEvent, FrameEvent, ?> messageFlowToFrameFlow(Flow<Message, Message, ?> flow, int bufferLimit, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle) {
        return (Flow)Flow$.MODULE$.apply().via(this.aggregateFrames(bufferLimit)).via((Graph)this.handleProtocolFailures().apply((Object)WebSocketFlowHandler$.MODULE$.webSocketProtocol(bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle).join(flow))).map((Function1 & Serializable)message -> this.messageToFrameEvent((Message)message));
    }

    private GraphStage<FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>>> aggregateFrames(int bufferLimit) {
        return new GraphStage<FlowShape<FrameEvent, Either<Message, WebSocketFlowHandler.RawMessage>>>(bufferLimit, this){
            public final int org$apache$pekko$http$play$WebSocketHandler$$anon$1$$bufferLimit$1;
            private final Inlet in;
            private final Outlet out;
            private final FlowShape shape;
            {
                this.org$apache$pekko$http$play$WebSocketHandler$$anon$1$$bufferLimit$1 = bufferLimit$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.in = Inlet$.MODULE$.apply("WebSocketHandler.aggregateFrames.in");
                this.out = Outlet$.MODULE$.apply("WebSocketHandler.aggregateFrames.out");
                this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
            }

            public Inlet in() {
                return this.in;
            }

            public Outlet out() {
                return this.out;
            }

            public FlowShape shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private ByteString currentFrameData;
                    private FrameHeader currentFrameHeader;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        this.currentFrameData = null;
                        this.currentFrameHeader = null;
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public ByteString currentFrameData() {
                        return this.currentFrameData;
                    }

                    public void currentFrameData_$eq(ByteString x$1) {
                        this.currentFrameData = x$1;
                    }

                    public FrameHeader currentFrameHeader() {
                        return this.currentFrameHeader;
                    }

                    public void currentFrameHeader_$eq(FrameHeader x$1) {
                        this.currentFrameHeader = x$1;
                    }

                    public void onPush() {
                        FrameEvent elem = (FrameEvent)this.grab(this.$outer.in());
                        FrameEvent frameEvent = elem;
                        if (frameEvent instanceof FrameData) {
                            FrameData frameData;
                            FrameData unexpectedData = frameData = (FrameData)frameEvent;
                            if (this.currentFrameHeader() == null) {
                                this.push(this.$outer.out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$close(Protocol.CloseCodes$.MODULE$.UnexpectedCondition(), "Server error"));
                                return;
                            }
                            FrameData frameData2 = FrameData$.MODULE$.unapply(frameData);
                            ByteString byteString = frameData2._1();
                            boolean bl = frameData2._2();
                            ByteString data = byteString;
                            if (this.currentFrameData().size() + data.size() > this.$outer.org$apache$pekko$http$play$WebSocketHandler$$anon$1$$bufferLimit$1) {
                                this.push(this.$outer.out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$close(Protocol.CloseCodes$.MODULE$.TooBig(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$close$default$2()));
                                return;
                            }
                            ByteString data2 = byteString;
                            if (!bl) {
                                this.currentFrameData_$eq(this.currentFrameData().$plus$plus(data2));
                                this.pull(this.$outer.in());
                                return;
                            }
                            ByteString data3 = byteString;
                            if (bl) {
                                WebSocketFlowHandler.RawMessage message = WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$frameToRawMessage(this.currentFrameHeader(), this.currentFrameData().$plus$plus(data3));
                                this.currentFrameHeader_$eq(null);
                                this.currentFrameData_$eq(null);
                                this.push(this.$outer.out(), package$.MODULE$.Right().apply((Object)message));
                                return;
                            }
                        }
                        if (frameEvent instanceof FrameStart) {
                            FrameStart frameStart = (FrameStart)frameEvent;
                            FrameStart frameStart2 = FrameStart$.MODULE$.unapply(frameStart);
                            FrameHeader frameHeader = frameStart2._1();
                            ByteString byteString = frameStart2._2();
                            FrameHeader header = frameHeader;
                            ByteString data = byteString;
                            if (this.currentFrameHeader() != null) {
                                this.push(this.$outer.out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$close(Protocol.CloseCodes$.MODULE$.UnexpectedCondition(), "Server error"));
                                return;
                            }
                            FrameHeader header2 = frameHeader;
                            if (header2.mask().isEmpty()) {
                                this.push(this.$outer.out(), WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$close(Protocol.CloseCodes$.MODULE$.ProtocolError(), "Unmasked client frame"));
                                return;
                            }
                            FrameHeader header3 = frameHeader;
                            ByteString data4 = byteString;
                            FrameStart fs = frameStart;
                            if (fs.lastPart()) {
                                this.push(this.$outer.out(), package$.MODULE$.Right().apply((Object)WebSocketHandler$.MODULE$.org$apache$pekko$http$play$WebSocketHandler$$$frameToRawMessage(header3, data4)));
                                return;
                            }
                            FrameHeader header4 = frameHeader;
                            ByteString data5 = byteString;
                            this.currentFrameHeader_$eq(header4);
                            this.currentFrameData_$eq(data5);
                            this.pull(this.$outer.in());
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }
                };
            }
        };
    }

    public WebSocketFlowHandler.RawMessage org$apache$pekko$http$play$WebSocketHandler$$$frameToRawMessage(FrameHeader header, ByteString data) {
        ByteString unmasked = FrameEventParser$.MODULE$.mask(data, header.mask());
        return WebSocketFlowHandler.RawMessage$.MODULE$.apply(this.frameOpCodeToMessageType(header.opcode()), unmasked, header.fin(), WebSocketFlowHandler.RawMessage$.MODULE$.$lessinit$greater$default$4());
    }

    private Enumeration.Value frameOpCodeToMessageType(Protocol.Opcode opcode) {
        Protocol.Opcode opcode2 = opcode;
        if (Protocol.Opcode$.Binary$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Binary();
        }
        if (Protocol.Opcode$.Text$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Text();
        }
        if (Protocol.Opcode$.Close$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Close();
        }
        if (Protocol.Opcode$.Ping$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Ping();
        }
        if (Protocol.Opcode$.Pong$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Pong();
        }
        if (Protocol.Opcode$.Continuation$.MODULE$.equals(opcode2)) {
            return WebSocketFlowHandler.MessageType$.MODULE$.Continuation();
        }
        throw new MatchError((Object)opcode2);
    }

    private FrameEvent messageToFrameEvent(Message message) {
        Message message2 = message;
        if (message2 instanceof TextMessage) {
            String string;
            TextMessage textMessage = TextMessage$.MODULE$.unapply((TextMessage)message2);
            String data = string = textMessage._1();
            return this.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Text$.MODULE$, ByteString$.MODULE$.apply(data));
        }
        if (message2 instanceof BinaryMessage) {
            ByteString byteString;
            BinaryMessage binaryMessage = BinaryMessage$.MODULE$.unapply((BinaryMessage)message2);
            ByteString data = byteString = binaryMessage._1();
            return this.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Binary$.MODULE$, data);
        }
        if (message2 instanceof PingMessage) {
            ByteString byteString;
            PingMessage pingMessage = PingMessage$.MODULE$.unapply((PingMessage)message2);
            ByteString data = byteString = pingMessage._1();
            return this.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Ping$.MODULE$, data);
        }
        if (message2 instanceof PongMessage) {
            ByteString byteString;
            PongMessage pongMessage = PongMessage$.MODULE$.unapply((PongMessage)message2);
            ByteString data = byteString = pongMessage._1();
            return this.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Pong$.MODULE$, data);
        }
        if (message2 instanceof CloseMessage) {
            CloseMessage closeMessage = CloseMessage$.MODULE$.unapply((CloseMessage)message2);
            Option option = closeMessage._1();
            String string = closeMessage._2();
            if (option instanceof Some) {
                int statusCode = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                String reason = string;
                return FrameEvent$.MODULE$.closeFrame(statusCode, reason, FrameEvent$.MODULE$.closeFrame$default$3());
            }
            if (None$.MODULE$.equals(option)) {
                return this.frameEvent$1((Protocol.Opcode)Protocol.Opcode$.Close$.MODULE$, ByteString$.MODULE$.empty());
            }
        }
        throw new MatchError((Object)message2);
    }

    private Function1<Flow<WebSocketFlowHandler.RawMessage, Message, ?>, Flow<Either<Message, WebSocketFlowHandler.RawMessage>, Message, ?>> handleProtocolFailures() {
        return PekkoStreams$.MODULE$.bypassWith(Flow$.MODULE$.apply().via((Graph)new GraphStage<FlowShape<Either<Message, WebSocketFlowHandler.RawMessage>, Either<WebSocketFlowHandler.RawMessage, Message>>>(this){
            private final Inlet in;
            private final Outlet out;
            private final FlowShape shape;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.in = Inlet$.MODULE$.apply("WebSocketHandler.handleProtocolFailures.in");
                this.out = Outlet$.MODULE$.apply("WebSocketHandler.handleProtocolFailures.out");
                this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
            }

            public Inlet in() {
                return this.in;
            }

            public Outlet out() {
                return this.out;
            }

            public FlowShape shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private boolean closing;
                    private final /* synthetic */ anon.3 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        this.closing = false;
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public boolean closing() {
                        return this.closing;
                    }

                    public void closing_$eq(boolean x$1) {
                        this.closing = x$1;
                    }

                    public void onPush() {
                        Either elem;
                        Either either = elem = (Either)this.grab(this.$outer.in());
                        if (this.closing()) {
                            this.completeStage();
                            return;
                        }
                        if (either instanceof Right) {
                            WebSocketFlowHandler.RawMessage message = (WebSocketFlowHandler.RawMessage)((Right)either).value();
                            this.push(this.$outer.out(), package$.MODULE$.Left().apply((Object)message));
                            return;
                        }
                        if (either instanceof Left) {
                            Message close = (Message)((Left)either).value();
                            this.closing_$eq(true);
                            this.push(this.$outer.out(), package$.MODULE$.Right().apply((Object)close));
                            return;
                        }
                        throw new MatchError((Object)either);
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }
                };
            }
        }), (Graph)Merge$.MODULE$.apply(2, true));
    }

    public Left<CloseMessage, Nothing$> org$apache$pekko$http$play$WebSocketHandler$$$close(int status, String message) {
        return package$.MODULE$.Left().apply((Object)new CloseMessage((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)status)), message));
    }

    public String org$apache$pekko$http$play$WebSocketHandler$$$close$default$2() {
        return "";
    }

    private final FrameStart frameEvent$1(Protocol.Opcode opcode, ByteString data) {
        return FrameEvent$.MODULE$.fullFrame(opcode, (Option)None$.MODULE$, data, true, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7());
    }
}

