/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.openid.Discovery;
import play.api.libs.openid.Errors$NETWORK_ERROR$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.WsDiscovery$UrlIdentifier$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

@Singleton
public class WsDiscovery
implements Discovery {
    private final WSClient ws;
    private final ExecutionContext ec;
    public final WsDiscovery$UrlIdentifier$ UrlIdentifier$lzy1;

    @Inject
    public WsDiscovery(WSClient ws, ExecutionContext ec) {
        this.ws = ws;
        this.ec = ec;
        this.UrlIdentifier$lzy1 = new WsDiscovery$UrlIdentifier$(this);
    }

    public final WsDiscovery$UrlIdentifier$ UrlIdentifier() {
        return this.UrlIdentifier$lzy1;
    }

    @Override
    public String normalizeIdentifier(String openID) {
        String trimmed = openID.trim();
        return (String)this.UrlIdentifier().apply(trimmed).normalize().getOrElse(() -> WsDiscovery.normalizeIdentifier$$anonfun$1(trimmed));
    }

    @Override
    public Future<OpenIDServer> discoverServer(String openID) {
        String discoveryUrl = this.normalizeIdentifier(openID);
        return this.ws.url(discoveryUrl).get().map((Function1 & Serializable)response -> {
            Option maybeOpenIdServer = new Discovery.XrdsResolver().resolve((WSResponse)response).orElse(() -> WsDiscovery.$anonfun$7(response));
            return (OpenIDServer)maybeOpenIdServer.getOrElse(WsDiscovery::discoverServer$$anonfun$1$$anonfun$1);
        }, this.ec);
    }

    public static final int play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$port$1(int p) {
        int n = p;
        if (80 == n || 443 == n) {
            return -1;
        }
        int port = n;
        return port;
    }

    private static final String schemeForPort$1(int p) {
        int n = p;
        if (443 == n) {
            return "https";
        }
        return "http";
    }

    private static final String scheme$1$$anonfun$1(URI uri$1) {
        return WsDiscovery.schemeForPort$1(uri$1.getPort());
    }

    public static final String play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$scheme$1(URI uri) {
        return (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse(() -> WsDiscovery.scheme$1$$anonfun$1(uri));
    }

    public static final String play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$path$1(String path) {
        if (path == null || path.isEmpty()) {
            return "/";
        }
        return path;
    }

    private static final String normalizeIdentifier$$anonfun$1(String trimmed$1) {
        return trimmed$1;
    }

    private static final Option $anonfun$7(WSResponse response$1) {
        return new Discovery.HtmlResolver().resolve(response$1);
    }

    private static final OpenIDServer discoverServer$$anonfun$1$$anonfun$1() {
        throw Errors$NETWORK_ERROR$.MODULE$;
    }

    public class UrlIdentifier
    implements Product,
    Serializable {
        private final String url;
        private final /* synthetic */ WsDiscovery $outer;

        public UrlIdentifier(WsDiscovery $outer, String url) {
            this.url = url;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UrlIdentifier)) return false;
            if (((UrlIdentifier)object).play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer() != this.$outer) return false;
            UrlIdentifier urlIdentifier = (UrlIdentifier)object;
            String string = this.url();
            String string2 = urlIdentifier.url();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!urlIdentifier.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UrlIdentifier;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UrlIdentifier";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "url";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String url() {
            return this.url;
        }

        public Option<String> normalize() {
            return Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{MalformedURLException.class, URISyntaxException.class})).opt(this::normalize$$anonfun$1);
        }

        public UrlIdentifier copy(String url) {
            return new UrlIdentifier(this.$outer, url);
        }

        public String copy$default$1() {
            return this.url();
        }

        public String _1() {
            return this.url();
        }

        public final /* synthetic */ WsDiscovery play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer() {
            return this.$outer;
        }

        private final String normalize$$anonfun$1() {
            URI uri = (this.url().matches("^(http|HTTP)(s|S)?:.*") ? new URI(this.url()) : new URI("http://" + this.url())).normalize();
            return new URI(WsDiscovery.play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$scheme$1(uri), uri.getUserInfo(), uri.getHost().toLowerCase(Locale.ENGLISH), WsDiscovery.play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$port$1(uri.getPort()), WsDiscovery.play$api$libs$openid$WsDiscovery$UrlIdentifier$$_$path$1(uri.getPath()), uri.getQuery(), null).toURL().toExternalForm();
        }
    }
}

