/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import play.api.libs.openid.Discovery;
import play.api.libs.openid.Errors$NETWORK_ERROR$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.WsDiscovery$UrlIdentifier$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.Exception$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\to\u0001\u0011\t\u0011)A\u0006q!)a\b\u0001C\u0001\u007f\u0019!Q\n\u0001!O\u0011!qFA!f\u0001\n\u0003y\u0006\u0002\u00035\u0005\u0005#\u0005\u000b\u0011\u00021\t\u000by\"A\u0011A5\t\u000b5$A\u0011\u00018\t\u000fe$\u0011\u0011!C\u0001u\"9A\u0010BI\u0001\n\u0003i\b\"CA\t\t\u0005\u0005I\u0011IA\n\u0011%\t)\u0002BA\u0001\n\u0003\t9\u0002C\u0005\u0002 \u0011\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0006\u0003\u0002\u0002\u0013\u0005\u0013q\u0006\u0005\n\u0003{!\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0013\u0005\u0003\u0003%\t%a\u0013\t\u0013\u0005=C!!A\u0005B\u0005E\u0003\"CA*\t\u0005\u0005I\u0011IA+\u0011%\t9\u0006BA\u0001\n\u0003\nIfB\u0005\u0002^\u0001\t\t\u0011#\u0001\u0002`\u0019AQ\nAA\u0001\u0012\u0003\t\t\u0007\u0003\u0004?+\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003'*\u0012\u0011!C#\u0003+B\u0011\"a\u001f\u0016\u0003\u0003%\t)! \t\u0013\u0005\u0005U#!A\u0005\u0002\u0006\r\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003'\u0003A\u0011AAK\u0005-96\u000fR5tG>4XM]=\u000b\u0005yy\u0012AB8qK:LGM\u0003\u0002!C\u0005!A.\u001b2t\u0015\t\u00113%A\u0002ba&T\u0011\u0001J\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011!H\u0005\u0003au\u0011\u0011\u0002R5tG>4XM]=\u0002\u0005]\u001c\bCA\u001a6\u001b\u0005!$BA\u0019 \u0013\t1DG\u0001\u0005X'\u000ec\u0017.\u001a8u\u0003\t)7\r\u0005\u0002:y5\t!H\u0003\u0002<S\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005uR$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011\u0001i\u0011\u000b\u0003\u0003\n\u0003\"A\f\u0001\t\u000b]\u001a\u00019\u0001\u001d\t\u000bE\u001a\u0001\u0019\u0001\u001a)\u0005\r)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0019IgN[3di*\t!*A\u0004kC.\f'\u000f^1\n\u00051;%AB%oU\u0016\u001cGOA\u0007Ve2LE-\u001a8uS\u001aLWM]\n\u0005\t\u001dz%\u000b\u0005\u0002)!&\u0011\u0011+\u000b\u0002\b!J|G-^2u!\t\u00196L\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011q+J\u0001\u0007yI|w\u000e\u001e \n\u0003)J!AW\u0015\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00035&\n1!\u001e:m+\u0005\u0001\u0007CA1f\u001d\t\u00117\r\u0005\u0002VS%\u0011A-K\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002eS\u0005!QO\u001d7!)\tQG\u000e\u0005\u0002l\t5\t\u0001\u0001C\u0003_\u000f\u0001\u0007\u0001-A\u0005o_Jl\u0017\r\\5{KV\tq\u000eE\u0002)aJL!!]\u0015\u0003\r=\u0003H/[8o!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003MR\fAaY8qsR\u0011!n\u001f\u0005\b=&\u0001\n\u00111\u0001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A \u0016\u0003A~\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017I\u0013AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003I\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0007\u0011\u0007!\nY\"C\u0002\u0002\u001e%\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\t\u0002*A\u0019\u0001&!\n\n\u0007\u0005\u001d\u0012FA\u0002B]fD\u0011\"a\u000b\u000e\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0004\u0005\u0004\u00024\u0005e\u00121E\u0007\u0003\u0003kQ1!a\u000e*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA!\u0003\u000f\u00022\u0001KA\"\u0013\r\t)%\u000b\u0002\b\u0005>|G.Z1o\u0011%\tYcDA\u0001\u0002\u0004\t\u0019#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u0001:\u0002N!I\u00111\u0006\t\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011D\u0001\ti>\u001cFO]5oOR\t!/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0003\nY\u0006C\u0005\u0002,M\t\t\u00111\u0001\u0002$\u0005iQK\u001d7JI\u0016tG/\u001b4jKJ\u0004\"a[\u000b\u0014\u000bU\t\u0019'a\u001c\u0011\r\u0005\u0015\u00141\u000e1k\u001b\t\t9GC\u0002\u0002j%\nqA];oi&lW-\u0003\u0003\u0002n\u0005\u001d$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vY\f!![8\n\u0007q\u000b\u0019\b\u0006\u0002\u0002`\u0005)\u0011\r\u001d9msR\u0019!.a \t\u000byC\u0002\u0019\u00011\u0002\u000fUt\u0017\r\u001d9msR!\u0011QQAD!\rA\u0003\u000f\u0019\u0005\t\u0003\u0013K\u0012\u0011!a\u0001U\u0006\u0019\u0001\u0010\n\u0019\u0002'9|'/\\1mSj,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u0007I\fy\t\u0003\u0004\u0002\u0012j\u0001\r\u0001Y\u0001\u0007_B,g.\u0013#\u0002\u001d\u0011L7oY8wKJ\u001cVM\u001d<feR!\u0011qSAR!\u0015I\u0014\u0011TAO\u0013\r\tYJ\u000f\u0002\u0007\rV$XO]3\u0011\u00079\ny*C\u0002\u0002\"v\u0011Ab\u00149f]&#5+\u001a:wKJDa!!%\u001c\u0001\u0004\u0001\u0007f\u0001\u0001\u0002(B\u0019a)!+\n\u0007\u0005-vIA\u0005TS:<G.\u001a;p]\u0002")
public class WsDiscovery
implements Discovery {
    private volatile WsDiscovery$UrlIdentifier$ UrlIdentifier$module;
    private final WSClient ws;
    private final ExecutionContext ec;

    public WsDiscovery$UrlIdentifier$ UrlIdentifier() {
        if (this.UrlIdentifier$module == null) {
            this.UrlIdentifier$lzycompute$1();
        }
        return this.UrlIdentifier$module;
    }

    @Override
    public String normalizeIdentifier(String openID) {
        String trimmed = openID.trim();
        return (String)new UrlIdentifier(this, trimmed).normalize().getOrElse((Function0 & Serializable)() -> trimmed);
    }

    @Override
    public Future<OpenIDServer> discoverServer(String openID) {
        String discoveryUrl = this.normalizeIdentifier(openID);
        return this.ws.url(discoveryUrl).get().map((Function1 & Serializable)response -> {
            Option maybeOpenIdServer = new Discovery.XrdsResolver().resolve((WSResponse)response).orElse((Function0 & Serializable)() -> new Discovery.HtmlResolver().resolve((WSResponse)response));
            return (OpenIDServer)maybeOpenIdServer.getOrElse((Function0 & Serializable)() -> {
                throw Errors$NETWORK_ERROR$.MODULE$;
            });
        }, this.ec);
    }

    private final void UrlIdentifier$lzycompute$1() {
        WsDiscovery wsDiscovery = this;
        synchronized (wsDiscovery) {
            if (this.UrlIdentifier$module == null) {
                this.UrlIdentifier$module = new WsDiscovery$UrlIdentifier$(this);
            }
        }
    }

    @Inject
    public WsDiscovery(WSClient ws, ExecutionContext ec) {
        this.ws = ws;
        this.ec = ec;
    }

    public class UrlIdentifier
    implements Product,
    Serializable {
        private final String url;
        public final /* synthetic */ WsDiscovery $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String url() {
            return this.url;
        }

        public Option<String> normalize() {
            return Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{MalformedURLException.class, URISyntaxException.class})).opt((Function0 & Serializable)() -> {
                URI uri = (this.url().matches("^(http|HTTP)(s|S)?:.*") ? new URI(this.url()) : new URI("http://" + this.url())).normalize();
                return new URI(UrlIdentifier.scheme$1(uri), uri.getUserInfo(), uri.getHost().toLowerCase(Locale.ENGLISH), UrlIdentifier.port$1(uri.getPort()), UrlIdentifier.path$1(uri.getPath()), uri.getQuery(), null).toURL().toExternalForm();
            });
        }

        public UrlIdentifier copy(String url) {
            return new UrlIdentifier(this.play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer(), url);
        }

        public String copy$default$1() {
            return this.url();
        }

        public String productPrefix() {
            return "UrlIdentifier";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.url();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UrlIdentifier;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "url";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UrlIdentifier)) return false;
            if (((UrlIdentifier)object).play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer() != this.play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UrlIdentifier urlIdentifier = (UrlIdentifier)x$1;
            String string = this.url();
            String string2 = urlIdentifier.url();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!urlIdentifier.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ WsDiscovery play$api$libs$openid$WsDiscovery$UrlIdentifier$$$outer() {
            return this.$outer;
        }

        private static final int port$1(int p) {
            int n = p;
            switch (n) {
                case 80: 
                case 443: {
                    return -1;
                }
            }
            return n;
        }

        private static final String schemeForPort$1(int p) {
            int n = p;
            switch (n) {
                case 443: {
                    return "https";
                }
            }
            return "http";
        }

        private static final String scheme$1(URI uri) {
            return (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> UrlIdentifier.schemeForPort$1(uri.getPort()));
        }

        private static final String path$1(String path) {
            if (path == null || path.isEmpty()) {
                return "/";
            }
            return path;
        }

        public UrlIdentifier(WsDiscovery $outer, String url) {
            this.url = url;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

