/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.reactivestreams.Processor;
import play.api.http.websocket.BinaryMessage;
import play.api.http.websocket.BinaryMessage$;
import play.api.http.websocket.CloseMessage;
import play.api.http.websocket.CloseMessage$;
import play.api.http.websocket.Message;
import play.api.http.websocket.PingMessage;
import play.api.http.websocket.PingMessage$;
import play.api.http.websocket.PongMessage;
import play.api.http.websocket.PongMessage$;
import play.api.http.websocket.TextMessage;
import play.api.http.websocket.TextMessage$;
import play.core.server.common.WebSocketFlowHandler;
import play.core.server.common.WebSocketFlowHandler$;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class WebSocketHandler$
implements Serializable {
    public static final WebSocketHandler$ MODULE$ = new WebSocketHandler$();

    private WebSocketHandler$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WebSocketHandler$.class);
    }

    public Processor<WebSocketFrame, WebSocketFrame> messageFlowToFrameProcessor(Flow<Message, Message, ?> flow, int bufferLimit, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle, Materializer mat) {
        return SynchronousMappedStreams$.MODULE$.transform((Processor)WebSocketFlowHandler$.MODULE$.webSocketProtocol(bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle).join(flow).toProcessor().run(mat), (Function1 & Serializable)frame -> this.frameToMessage((WebSocketFrame)frame), (Function1 & Serializable)message -> this.messageToFrame((Message)message));
    }

    private WebSocketFlowHandler.RawMessage frameToMessage(WebSocketFrame frame) {
        Enumeration.Value value;
        ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
        frame.content().readBytes(builder.asOutputStream(), frame.content().readableBytes());
        ByteString bytes = builder.result();
        ReferenceCountUtil.release((Object)frame);
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof TextWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Text();
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Binary();
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame close = (CloseWebSocketFrame)webSocketFrame;
            value = WebSocketFlowHandler.MessageType$.MODULE$.Close();
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Ping();
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Pong();
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Continuation();
        } else {
            throw new MatchError((Object)webSocketFrame);
        }
        Enumeration.Value messageType = value;
        return WebSocketFlowHandler.RawMessage$.MODULE$.apply(messageType, bytes, frame.isFinalFragment(), WebSocketFlowHandler.RawMessage$.MODULE$.$lessinit$greater$default$4());
    }

    private WebSocketFrame messageToFrame(Message message) {
        Message message2 = message;
        if (message2 instanceof TextMessage) {
            String string;
            TextMessage textMessage = TextMessage$.MODULE$.unapply((TextMessage)message2);
            String data = string = textMessage._1();
            return new TextWebSocketFrame(data);
        }
        if (message2 instanceof BinaryMessage) {
            ByteString byteString;
            BinaryMessage binaryMessage = BinaryMessage$.MODULE$.unapply((BinaryMessage)message2);
            ByteString data = byteString = binaryMessage._1();
            return new BinaryWebSocketFrame(this.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof PingMessage) {
            ByteString byteString;
            PingMessage pingMessage = PingMessage$.MODULE$.unapply((PingMessage)message2);
            ByteString data = byteString = pingMessage._1();
            return new PingWebSocketFrame(this.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof PongMessage) {
            ByteString byteString;
            PongMessage pongMessage = PongMessage$.MODULE$.unapply((PongMessage)message2);
            ByteString data = byteString = pongMessage._1();
            return new PongWebSocketFrame(this.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof CloseMessage) {
            CloseMessage closeMessage = CloseMessage$.MODULE$.unapply((CloseMessage)message2);
            Option option = closeMessage._1();
            String string = closeMessage._2();
            if (option instanceof Some) {
                int statusCode = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                String reason = string;
                return new CloseWebSocketFrame(statusCode, reason);
            }
            if (None$.MODULE$.equals(option)) {
                return new CloseWebSocketFrame();
            }
        }
        throw new MatchError((Object)message2);
    }

    private final ByteBuf byteStringToByteBuf$1(ByteString bytes) {
        if (bytes.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asByteBuffer());
    }
}

