/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.mailer;

import com.typesafe.config.ConfigValue;
import jakarta.activation.DataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Authenticator;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.FilterOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import java.util.Properties;
import org.apache.commons.mail2.jakarta.DefaultAuthenticator;
import org.apache.commons.mail2.jakarta.EmailAttachment;
import org.apache.commons.mail2.jakarta.HtmlEmail;
import org.apache.commons.mail2.jakarta.MultiPartEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.mailer.Attachment;
import play.api.libs.mailer.AttachmentData;
import play.api.libs.mailer.AttachmentDataSource;
import play.api.libs.mailer.AttachmentFile;
import play.api.libs.mailer.AttachmentURL;
import play.api.libs.mailer.Email;
import play.api.libs.mailer.MailerClient;
import play.api.libs.mailer.SMTPConfiguration;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public abstract class CommonsMailer
implements MailerClient {
    private final SMTPConfiguration conf;
    private final Logger logger;

    public CommonsMailer(SMTPConfiguration conf) {
        this.conf = conf;
        this.logger = LoggerFactory.getLogger((String)"play.mailer");
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract String send(MultiPartEmail var1);

    public abstract MultiPartEmail createMultiPartEmail();

    public abstract HtmlEmail createHtmlEmail();

    @Override
    public String send(Email data) {
        return this.send(this.createEmail(data));
    }

    public MultiPartEmail createEmail(Email data) {
        MultiPartEmail email = this.createEmail(data.bodyText(), data.bodyHtml(), (String)data.charset().getOrElse(CommonsMailer::$anonfun$1));
        email.setSubject(data.subject());
        this.setAddress(data.from(), (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(address, name) -> email.setFrom(address, name));
        data.replyTo().foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.setAddress((String)_$1, (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(address, name) -> email.addReplyTo(address, name)));
        data.bounceAddress().foreach((Function1 & Serializable)x$0 -> email.setBounceAddress(x$0));
        data.to().foreach((Function1)(JProcedure1 & Serializable)_$2 -> this.setAddress((String)_$2, (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(address, name) -> email.addTo(address, name)));
        data.cc().foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.setAddress((String)_$3, (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(address, name) -> email.addCc(address, name)));
        data.bcc().foreach((Function1)(JProcedure1 & Serializable)_$4 -> this.setAddress((String)_$4, (Function2<String, String, BoxedUnit>)(JProcedure2 & Serializable)(address, name) -> email.addBcc(address, name)));
        data.headers().foreach((Function1)(JProcedure1 & Serializable)header -> email.addHeader((String)header._1(), (String)header._2()));
        this.conf.timeout().foreach((Function1)(JFunction1.mcVI.sp & Serializable)timeout -> email.setSocketTimeout(Duration.ofMillis(Int$.MODULE$.int2long(timeout))));
        this.conf.connectionTimeout().foreach((Function1)(JFunction1.mcVI.sp & Serializable)timeout -> email.setSocketConnectionTimeout(Duration.ofMillis(Int$.MODULE$.int2long(timeout))));
        data.attachments().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Attachment attachment = x$1;
            if (attachment instanceof AttachmentData) {
                AttachmentData attachmentData = (AttachmentData)attachment;
                this.handleAttachmentData(email, attachmentData);
                return;
            }
            if (attachment instanceof AttachmentFile) {
                AttachmentFile attachmentFile = (AttachmentFile)attachment;
                this.handleAttachmentFile(email, attachmentFile);
                return;
            }
            if (attachment instanceof AttachmentDataSource) {
                AttachmentDataSource attachmentDataSource = (AttachmentDataSource)attachment;
                this.handleAttachmentDataSource(email, attachmentDataSource);
                return;
            }
            if (attachment instanceof AttachmentURL) {
                AttachmentURL attachmentURL = (AttachmentURL)attachment;
                this.handleAttachmentURL(email, attachmentURL);
                return;
            }
            throw new MatchError((Object)attachment);
        });
        email.setHostName(this.conf.host());
        email.setSmtpPort(this.conf.port());
        email.setSSLOnConnect(this.conf.ssl());
        if (this.conf.ssl()) {
            email.setSslSmtpPort(BoxesRunTime.boxToInteger((int)this.conf.port()).toString());
        }
        email.setStartTLSEnabled(this.conf.tls() || this.conf.tlsRequired());
        email.setStartTLSRequired(this.conf.tlsRequired());
        Option authenticator = this.conf.user().flatMap((Function1 & Serializable)u -> this.conf.password().map((Function1 & Serializable)p -> new DefaultAuthenticator(u, p)));
        authenticator.foreach((Function1)(JProcedure1 & Serializable)_$5 -> email.setAuthenticator((Authenticator)_$5));
        Properties mailProperties = email.getMailSession().getProperties();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.conf.props().entrySet()).asScala()).foreach((Function1 & Serializable)prop -> {
            mailProperties.setProperty("mail.smtp." + prop.getKey(), ((ConfigValue)prop.getValue()).unwrapped().toString());
            return mailProperties.setProperty("mail.smtps." + prop.getKey(), ((ConfigValue)prop.getValue()).unwrapped().toString());
        });
        email.setMailSession(Session.getInstance((Properties)mailProperties, (Authenticator)((Authenticator)authenticator.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
            email.setDebug(this.conf.debugMode());
            email.getMailSession().setDebugOut(new PrintStream(new FilterOutputStream(this){
                private final /* synthetic */ CommonsMailer $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(null);
                }

                public void write(byte[] b) {
                    this.$outer.logger().debug(new String(b));
                }

                public void write(byte[] b, int off, int len) {
                    this.$outer.logger().debug(new String(b, off, len));
                }

                public void write(int b) {
                    this.write(new byte[b]);
                }
            }));
        }
        return email;
    }

    private MultiPartEmail createEmail(Option<String> bodyText2, Option<String> bodyHtml, String charset) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)bodyHtml.filter((Function1 & Serializable)_$6 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$6.trim()))), (Object)bodyText2.filter((Function1 & Serializable)_$7 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$7.trim()))));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                String htmlMsg = (String)((Some)option).value();
                Option bodyTextOpt = option2;
                HtmlEmail htmlEmail = this.createHtmlEmail();
                htmlEmail.setCharset(charset);
                htmlEmail.setHtmlMsg(htmlMsg);
                bodyTextOpt.foreach((Function1 & Serializable)bodyText -> htmlEmail.setTextMsg(bodyText));
                return htmlEmail;
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                String msg = (String)((Some)option2).value();
                MultiPartEmail multiPartEmail = this.createMultiPartEmail();
                multiPartEmail.setCharset(charset);
                multiPartEmail.setMsg(msg);
                return multiPartEmail;
            }
        }
        return this.createMultiPartEmail();
    }

    private void setAddress(String emailAddress, Function2<String, String, BoxedUnit> setter) {
        if (emailAddress != null) {
            try {
                InternetAddress iAddress = new InternetAddress(emailAddress);
                String address = iAddress.getAddress();
                String name = iAddress.getPersonal();
                setter.apply((Object)address, (Object)name);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    setter.apply((Object)emailAddress, null);
                }
                throw throwable;
            }
            return;
        }
    }

    private void handleAttachmentData(MultiPartEmail email, AttachmentData attachmentData) {
        String description = (String)attachmentData.description().getOrElse(() -> CommonsMailer.$anonfun$3(attachmentData));
        String disposition = (String)attachmentData.disposition().getOrElse(CommonsMailer::$anonfun$4);
        ByteArrayDataSource dataSource = new ByteArrayDataSource(attachmentData.data(), attachmentData.mimetype());
        Option<String> option = attachmentData.contentId();
        if (option instanceof Some) {
            String cid = (String)((Some)option).value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed((DataSource)dataSource, attachmentData.name(), cid);
                return;
            }
            if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach((DataSource)dataSource, attachmentData.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentFile(MultiPartEmail email, AttachmentFile attachmentFile) {
        String description = (String)attachmentFile.description().getOrElse(() -> CommonsMailer.$anonfun$5(attachmentFile));
        String disposition = (String)attachmentFile.disposition().getOrElse(CommonsMailer::$anonfun$6);
        EmailAttachment emailAttachment = new EmailAttachment();
        emailAttachment.setName(attachmentFile.name());
        emailAttachment.setPath(attachmentFile.file().getPath());
        emailAttachment.setDescription(description);
        emailAttachment.setDisposition(disposition);
        Option<String> option = attachmentFile.contentId();
        if (option instanceof Some) {
            String cid = (String)((Some)option).value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed(attachmentFile.file(), cid);
                return;
            }
            if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(emailAttachment);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentDataSource(MultiPartEmail email, AttachmentDataSource attachmentDataSource) {
        String description = (String)attachmentDataSource.description().getOrElse(() -> CommonsMailer.$anonfun$7(attachmentDataSource));
        String disposition = (String)attachmentDataSource.disposition().getOrElse(CommonsMailer::$anonfun$8);
        DataSource dataSource = attachmentDataSource.dataSource();
        Option<String> option = attachmentDataSource.contentId();
        if (option instanceof Some) {
            String cid = (String)((Some)option).value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed(dataSource, attachmentDataSource.name(), cid);
                return;
            }
            if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(dataSource, attachmentDataSource.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentURL(MultiPartEmail email, AttachmentURL attachmentURL) {
        String description = (String)attachmentURL.description().getOrElse(() -> CommonsMailer.$anonfun$9(attachmentURL));
        String disposition = (String)attachmentURL.disposition().getOrElse(CommonsMailer::$anonfun$10);
        URL url = attachmentURL.url();
        Option<String> option = attachmentURL.contentId();
        if (option instanceof Some) {
            String cid = (String)((Some)option).value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed((DataSource)new URLDataSource(url), attachmentURL.name(), cid);
                return;
            }
            if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(url, attachmentURL.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    private static final String $anonfun$1() {
        return "utf-8";
    }

    private static final String $anonfun$3(AttachmentData attachmentData$1) {
        return attachmentData$1.name();
    }

    private static final String $anonfun$4() {
        return "attachment";
    }

    private static final String $anonfun$5(AttachmentFile attachmentFile$1) {
        return attachmentFile$1.name();
    }

    private static final String $anonfun$6() {
        return "attachment";
    }

    private static final String $anonfun$7(AttachmentDataSource attachmentDataSource$1) {
        return attachmentDataSource$1.name();
    }

    private static final String $anonfun$8() {
        return "attachment";
    }

    private static final String $anonfun$9(AttachmentURL attachmentURL$1) {
        return attachmentURL$1.name();
    }

    private static final String $anonfun$10() {
        return "attachment";
    }
}

