/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsNumber$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsString$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonConfig;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class JsValueSerializer
extends JsonSerializer<JsValue> {
    private final JsonConfig jsonConfig;

    public JsValueSerializer(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    private BigDecimal stripTrailingZeros(BigDecimal bigDec) {
        BigDecimal stripped = bigDec.stripTrailingZeros();
        if (this.jsonConfig.bigDecimalSerializerConfig().preserveZeroDecimal() && bigDec.scale() > 0 && stripped.scale() <= 0) {
            return stripped.setScale(1);
        }
        return stripped;
    }

    public void serialize(JsValue value, JsonGenerator json, SerializerProvider provider) {
        Some<Object> some;
        JsValue jsValue = value;
        if (jsValue instanceof JsNumber) {
            String raw;
            JsNumber jsNumber = JsNumber$.MODULE$.unapply((JsNumber)jsValue);
            scala.math.BigDecimal bigDecimal = jsNumber._1();
            scala.math.BigDecimal v = bigDecimal;
            scala.math.BigDecimal va = v.abs();
            boolean shouldWritePlain = va.$less$eq((Object)this.jsonConfig.bigDecimalSerializerConfig().maxPlain()) && va.$greater$eq((Object)this.jsonConfig.bigDecimalSerializerConfig().minPlain());
            BigDecimal stripped = this.stripTrailingZeros(v.bigDecimal());
            String string = raw = shouldWritePlain ? stripped.toPlainString() : stripped.toString();
            if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(raw), (Function1 & Serializable)c -> JsValueSerializer.serialize$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)))) {
                json.writeNumber(raw);
                return;
            }
            JsonGenerator jsonGenerator = json;
            if (jsonGenerator instanceof TokenBuffer) {
                TokenBuffer tb = (TokenBuffer)jsonGenerator;
                tb.writeNumber(raw, true);
                return;
            }
            json.writeNumber(raw);
            return;
        }
        if (jsValue instanceof JsString) {
            String string;
            JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
            String v = string = jsString._1();
            json.writeString(v);
            return;
        }
        if (jsValue instanceof JsBoolean && !(some = JsBoolean$.MODULE$.unapply((JsBoolean)jsValue)).isEmpty()) {
            boolean bl;
            boolean v = bl = BoxesRunTime.unboxToBoolean((Object)some.get());
            json.writeBoolean(v);
            return;
        }
        if (jsValue instanceof JsArray) {
            IndexedSeq<JsValue> indexedSeq;
            JsArray jsArray = JsArray$.MODULE$.unapply((JsArray)jsValue);
            IndexedSeq<JsValue> elements = indexedSeq = jsArray._1();
            json.writeStartArray();
            elements.foreach((Function1)(JProcedure1 & Serializable)t -> this.serialize((JsValue)t, json, provider));
            json.writeEndArray();
            return;
        }
        if (jsValue instanceof JsObject) {
            Map<String, JsValue> map;
            JsObject jsObject = JsObject$.MODULE$.unapply((JsObject)jsValue);
            Map<String, JsValue> values = map = jsObject._1();
            json.writeStartObject();
            values.foreach((Function1)(JProcedure1 & Serializable)t -> {
                json.writeFieldName((String)t._1());
                this.serialize((JsValue)t._2(), json, provider);
            });
            json.writeEndObject();
            return;
        }
        if (JsNull$.MODULE$.equals(jsValue)) {
            json.writeNull();
            return;
        }
        throw new MatchError((Object)jsValue);
    }

    private static final /* synthetic */ boolean serialize$$anonfun$1(char c) {
        return c == 'E' || c == '.';
    }
}

