/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.jackson.JacksonJson$;
import play.api.libs.json.jackson.PlayJsonMapperModule;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class JacksonJson
implements Product,
Serializable {
    private final JsonConfig jsonConfig;
    private final JsonFactory jsonFactory;
    private ObjectMapper mapper;

    public static JacksonJson apply(JsonConfig jsonConfig) {
        return JacksonJson$.MODULE$.apply(jsonConfig);
    }

    public static JacksonJson fromProduct(Product product) {
        return JacksonJson$.MODULE$.fromProduct(product);
    }

    public static JacksonJson get() {
        return JacksonJson$.MODULE$.get();
    }

    public static void setConfig(JsonConfig jsonConfig) {
        JacksonJson$.MODULE$.setConfig(jsonConfig);
    }

    public static JacksonJson unapply(JacksonJson jacksonJson) {
        return JacksonJson$.MODULE$.unapply(jacksonJson);
    }

    public JacksonJson(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
        this.jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(jsonConfig.streamReadConstraints()).streamWriteConstraints(jsonConfig.streamWriteConstraints())).build();
        this.mapper = JsonMapper.builder((JsonFactory)this.jsonFactory).addModules(new Module[]{new ParameterNamesModule(), new Jdk8Module(), new JavaTimeModule(), new DefaultScalaModule(), new PlayJsonMapperModule(jsonConfig)}).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS}).build();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JacksonJson)) return false;
        JacksonJson jacksonJson = (JacksonJson)object;
        JsonConfig jsonConfig = this.jsonConfig();
        JsonConfig jsonConfig2 = jacksonJson.jsonConfig();
        if (jsonConfig == null) {
            if (jsonConfig2 != null) {
                return false;
            }
        } else if (!jsonConfig.equals(jsonConfig2)) return false;
        if (!jacksonJson.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof JacksonJson;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "JacksonJson";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "jsonConfig";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public JsonConfig jsonConfig() {
        return this.jsonConfig;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void mapper_$eq(ObjectMapper x$1) {
        this.mapper = x$1;
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.mapper_$eq(mapper);
    }

    private JsonGenerator stringJsonGenerator(StringWriter out) {
        return this.jsonFactory.createGenerator((Writer)out);
    }

    public JsValue parseJsValue(byte[] data) {
        return (JsValue)this.mapper().readValue(this.jsonFactory.createParser(data), JsValue.class);
    }

    public JsValue parseJsValue(String input) {
        return (JsValue)this.mapper().readValue(this.jsonFactory.createParser(input), JsValue.class);
    }

    public JsValue parseJsValue(InputStream stream) {
        return (JsValue)this.mapper().readValue(this.jsonFactory.createParser(stream), JsValue.class);
    }

    private <T> T withStringWriter(Function1<StringWriter, T> f) {
        Object object;
        block10: {
            Object object2;
            StringWriter sw = new StringWriter();
            try {
                object2 = f.apply((Object)sw);
            }
            catch (Throwable throwable) {
                if (sw != null) {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            object = object2;
            if (sw == null) break block10;
            try {
                sw.close();
            }
            catch (Throwable throwable) {}
        }
        return (T)object;
    }

    public String generateFromJsValue(JsValue jsValue, boolean escapeNonASCII) {
        return (String)this.withStringWriter((Function1 & Serializable)sw -> {
            JsonGenerator gen = this.stringJsonGenerator((StringWriter)sw);
            if (escapeNonASCII) {
                gen.enable(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature());
            }
            this.mapper().writeValue(gen, (Object)jsValue);
            sw.flush();
            return sw.getBuffer().toString();
        });
    }

    public String prettyPrint(JsValue jsValue) {
        return (String)this.withStringWriter((Function1 & Serializable)sw -> {
            JsonGenerator gen = this.stringJsonGenerator((StringWriter)sw).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            ObjectWriter writer = this.mapper().writerWithDefaultPrettyPrinter();
            writer.writeValue(gen, (Object)jsValue);
            sw.flush();
            return sw.getBuffer().toString();
        });
    }

    public byte[] jsValueToBytes(JsValue jsValue) {
        return this.mapper().writeValueAsBytes((Object)jsValue);
    }

    public JsonNode jsValueToJsonNode(JsValue jsValue) {
        return this.mapper().valueToTree((Object)jsValue);
    }

    public JsValue jsonNodeToJsValue(JsonNode jsonNode) {
        return (JsValue)this.mapper().treeToValue((TreeNode)jsonNode, JsValue.class);
    }

    public JacksonJson copy(JsonConfig jsonConfig) {
        return new JacksonJson(jsonConfig);
    }

    public JsonConfig copy$default$1() {
        return this.jsonConfig();
    }

    public JsonConfig _1() {
        return this.jsonConfig();
    }
}

