/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import play.api.libs.json.BigDecimalParser$;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsNumber$;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResultException$;
import play.api.libs.json.JsString$;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.JsonValidationError$;
import play.api.libs.json.jackson.DeserializerContext;
import play.api.libs.json.jackson.KeyRead;
import play.api.libs.json.jackson.ReadingList;
import play.api.libs.json.jackson.ReadingList$;
import play.api.libs.json.jackson.ReadingMap;
import play.api.libs.json.jackson.ReadingMap$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class JsValueDeserializer
extends JsonDeserializer<Object> {
    private final Class<?> klass;
    private final JsonConfig jsonConfig;
    private final JsNull$ getNullValue;

    public JsValueDeserializer(TypeFactory factory, Class<?> klass, JsonConfig jsonConfig) {
        this.klass = klass;
        this.jsonConfig = jsonConfig;
        this.getNullValue = JsNull$.MODULE$;
    }

    public boolean isCachable() {
        return true;
    }

    public JsValue deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsValue value = this.deserialize(jp, ctxt, (List<DeserializerContext>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))));
        if (!this.klass.isAssignableFrom(value.getClass())) {
            ctxt.handleUnexpectedToken(this.klass, jp);
        }
        return value;
    }

    private Tuple2<Some<JsNumber>, List<DeserializerContext>> parseBigDecimal(JsonParser jp, List<DeserializerContext> parserContext) {
        JsResult<BigDecimal> jsResult = BigDecimalParser$.MODULE$.parse(jp.getText(), this.jsonConfig);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = JsSuccess$.MODULE$.unapply((JsSuccess)jsResult);
            Object t = jsSuccess._1();
            JsPath jsPath = jsSuccess._2();
            BigDecimal bigDecimal = (BigDecimal)t;
            return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsNumber$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal))), parserContext);
        }
        if (jsResult instanceof JsError) {
            Option option;
            JsonValidationError jsonValidationError;
            scala.collection.immutable.Seq<String> seq;
            Tuple2 tuple2;
            JsonValidationError jsonValidationError2;
            Option option2;
            Seq seq2;
            Tuple2 tuple22;
            Tuple2 tuple23;
            Option option3;
            JsError jsError = JsError$.MODULE$.unapply((JsError)jsResult);
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> seq3 = jsError._1();
            if (!(seq3 == null || (option3 = package$.MODULE$.$plus$colon().unapply(seq3)).isEmpty() || (tuple23 = (Tuple2)(tuple22 = (Tuple2)option3.get())._1()) == null || (seq2 = (Seq)tuple23._2()) == null || (option2 = package$.MODULE$.$plus$colon().unapply((SeqOps)seq2)).isEmpty() || (jsonValidationError2 = (JsonValidationError)(tuple2 = (Tuple2)option2.get())._1()) == null || (seq = (jsonValidationError = JsonValidationError$.MODULE$.unapplySeq(jsonValidationError2))._1()) == null || (option = package$.MODULE$.$plus$colon().unapply(seq)).isEmpty())) {
                scala.collection.immutable.Seq<Object> seq4;
                scala.collection.immutable.Seq<Object> seq5;
                scala.collection.immutable.Seq<Object> seq6;
                Tuple2 tuple24 = (Tuple2)option.get();
                String string = (String)tuple24._1();
                if ("error.expected.numberdigitlimit".equals(string) && (seq6 = jsonValidationError._2()).lengthCompare(0) == 0) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("Number is larger than supported for field '").append(jp.currentName()).append("'").toString());
                }
                if ("error.expected.numberscalelimit".equals(string) && (seq5 = jsonValidationError._2()).lengthCompare(0) >= 0) {
                    scala.collection.immutable.Seq seq7;
                    scala.collection.immutable.Seq args = seq7 = seq5.toSeq();
                    String scale2 = (String)args.headOption().fold(JsValueDeserializer::$anonfun$1, (Function1 & Serializable)scale -> new StringBuilder(3).append(" (").append(scale).append(")").toString());
                    throw new IllegalArgumentException(new StringBuilder(42).append("Number scale").append(scale2).append(" is out of limits for field '").append(jp.currentName()).append("'").toString());
                }
                if ("error.expected.numberformatexception".equals(string) && (seq4 = jsonValidationError._2()).lengthCompare(0) == 0) {
                    throw new NumberFormatException();
                }
            }
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors = seq3;
            throw JsResultException$.MODULE$.apply(errors);
        }
        throw new MatchError(jsResult);
    }

    public final JsValue deserialize(JsonParser jp, DeserializationContext ctxt, List<DeserializerContext> parserContext) {
        Tuple2 tuple2;
        while (true) {
            List nextContext;
            Tuple2 tuple22;
            if (jp.getCurrentToken() == null) {
                jp.nextToken();
            }
            int n = jp.getCurrentToken().id();
            switch (n) {
                case 7: 
                case 8: {
                    tuple22 = this.parseBigDecimal(jp, parserContext);
                    break;
                }
                case 6: {
                    tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsString$.MODULE$.apply(jp.getText())), parserContext);
                    break;
                }
                case 9: {
                    tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsBoolean$.MODULE$.apply(true)), parserContext);
                    break;
                }
                case 10: {
                    tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsBoolean$.MODULE$.apply(false)), parserContext);
                    break;
                }
                case 11: {
                    tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsNull$.MODULE$), parserContext);
                    break;
                }
                case 3: {
                    ReadingList readingList = ReadingList$.MODULE$.apply((ArrayBuffer<JsValue>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValue[0]))));
                    tuple22 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, parserContext.$plus$colon((Object)readingList));
                    break;
                }
                case 4: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        DeserializerContext deserializerContext = (DeserializerContext)colon2.head();
                        List list2 = colon2.next$access$1();
                        if (deserializerContext instanceof ReadingList) {
                            ArrayBuffer<JsValue> arrayBuffer;
                            ReadingList readingList = ReadingList$.MODULE$.unapply((ReadingList)deserializerContext);
                            ArrayBuffer<JsValue> content = arrayBuffer = readingList._1();
                            List stack = list2;
                            tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsArray$.MODULE$.apply((IndexedSeq<JsValue>)content)), (Object)stack);
                            break;
                        }
                    }
                    throw new RuntimeException("We should have been reading list, something got wrong");
                }
                case 1: {
                    ReadingMap readingMap = ReadingMap$.MODULE$.apply((ListBuffer<Tuple2<String, JsValue>>)((ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
                    tuple22 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, parserContext.$plus$colon((Object)readingMap));
                    break;
                }
                case 5: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list;
                        DeserializerContext deserializerContext = (DeserializerContext)colon3.head();
                        List list3 = colon3.next$access$1();
                        if (deserializerContext instanceof ReadingMap) {
                            ReadingMap c = (ReadingMap)deserializerContext;
                            List stack = list3;
                            KeyRead keyRead = c.setField(jp.currentName());
                            tuple22 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, stack.$plus$colon((Object)keyRead));
                            break;
                        }
                    }
                    throw new RuntimeException("We should be reading map, something got wrong");
                }
                case 2: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list;
                        DeserializerContext deserializerContext = (DeserializerContext)colon4.head();
                        List list4 = colon4.next$access$1();
                        if (deserializerContext instanceof ReadingMap) {
                            ListBuffer<Tuple2<String, JsValue>> listBuffer;
                            ReadingMap readingMap = ReadingMap$.MODULE$.unapply((ReadingMap)deserializerContext);
                            ListBuffer<Tuple2<String, JsValue>> content = listBuffer = readingMap._1();
                            List stack = list4;
                            tuple22 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)content)), (Object)stack);
                            break;
                        }
                    }
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                case -1: {
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                case 12: {
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            Tuple2 valueAndCtx = tuple22;
            jp.nextToken();
            tuple2 = valueAndCtx;
            if (tuple2 == null) break;
            Option option = (Option)tuple2._1();
            List list = (List)tuple2._2();
            if (option instanceof Some) {
                Serializable serializable;
                Serializable v = serializable = (Serializable)((Some)option).value();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    return (JsValue)((Object)v);
                }
                Serializable v2 = serializable;
                if (list instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list;
                    List list6 = colon5.next$access$1();
                    DeserializerContext previous = (DeserializerContext)colon5.head();
                    List stack = list6;
                    DeserializerContext deserializerContext = previous.addValue((JsValue)((Object)v2));
                    parserContext = stack.$colon$colon((Object)deserializerContext);
                    continue;
                }
            }
            if (!None$.MODULE$.equals(option)) break;
            parserContext = nextContext = list;
        }
        throw new MatchError((Object)tuple2);
    }

    public JsNull$ getNullValue() {
        return this.getNullValue;
    }

    private static final String $anonfun$1() {
        return "";
    }
}

