/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import play.api.libs.json.BigDecimalParser$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResultException;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.jackson.DeserializerContext;
import play.api.libs.json.jackson.KeyRead;
import play.api.libs.json.jackson.ReadingList;
import play.api.libs.json.jackson.ReadingMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b!B\u0006\r\u000111\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006%\u0002!\ta\u0015\u0005\u0006;\u0002!\tE\u0018\u0005\u0006E\u0002!\te\u0019\u0005\u0006i\u0002!I!\u001e\u0005\u0007E\u0002!)!!\b\t\u0013\u0005M\u0002A1A\u0005B\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\u0003')\u001bh+\u00197vK\u0012+7/\u001a:jC2L'0\u001a:\u000b\u00055q\u0011a\u00026bG.\u001cxN\u001c\u0006\u0003\u001fA\tAA[:p]*\u0011\u0011CE\u0001\u0005Y&\u00147O\u0003\u0002\u0014)\u0005\u0019\u0011\r]5\u000b\u0003U\tA\u0001\u001d7bsN\u0011\u0001a\u0006\t\u00041\u0001\u0012S\"A\r\u000b\u0005iY\u0012\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u00055a\"BA\u000f\u001f\u0003%1\u0017m\u001d;feblGNC\u0001 \u0003\r\u0019w.\\\u0005\u0003Ce\u0011\u0001CS:p]\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t1qJ\u00196fGR\fqAZ1di>\u0014\u0018p\u0001\u0001\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=J\u0012\u0001\u0002;za\u0016L!!\r\u0018\u0003\u0017QK\b/\u001a$bGR|'/_\u0001\u0006W2\f7o\u001d\u0019\u0003i\r\u00032!\u000e B\u001d\t1D\b\u0005\u00028u5\t\u0001H\u0003\u0002:W\u00051AH]8pizR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\na\u0001\u0015:fI\u00164\u0017BA A\u0005\u0015\u0019E.Y:t\u0015\ti$\b\u0005\u0002C\u00072\u0001A!\u0003#\u0003\u0003\u0003\u0005\tQ!\u0001F\u0005!!\u0013/\\1sW\u0012\n\u0014C\u0001$K!\t9\u0005*D\u0001;\u0013\tI%HA\u0004O_RD\u0017N\\4\u0011\u0005\u001d[\u0015B\u0001';\u0005\r\te._\u0001\u000bUN|gnQ8oM&<\u0007CA(Q\u001b\u0005q\u0011BA)\u000f\u0005)Q5o\u001c8D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQ3v\u000b\u0018\t\u0003+\u0002i\u0011\u0001\u0004\u0005\u0006U\u0011\u0001\r\u0001\f\u0005\u0006e\u0011\u0001\r\u0001\u0017\u0019\u00033n\u00032!\u000e [!\t\u00115\fB\u0005E/\u0006\u0005\t\u0011!B\u0001\u000b\")Q\n\u0002a\u0001\u001d\u0006Q\u0011n]\"bG\"\f'\r\\3\u0015\u0003}\u0003\"a\u00121\n\u0005\u0005T$a\u0002\"p_2,\u0017M\\\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002eO>\u0004\"aT3\n\u0005\u0019t!a\u0002&t-\u0006dW/\u001a\u0005\u0006Q\u001a\u0001\r![\u0001\u0003UB\u0004\"A[7\u000e\u0003-T!\u0001\\\u000e\u0002\t\r|'/Z\u0005\u0003].\u0014!BS:p]B\u000b'o]3s\u0011\u0015\u0001h\u00011\u0001r\u0003\u0011\u0019G\u000f\u001f;\u0011\u0005a\u0011\u0018BA:\u001a\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7i\u001c8uKb$\u0018a\u00049beN,')[4EK\u000eLW.\u00197\u0015\u000bY\f9\"!\u0007\u0011\t\u001d;\u0018p`\u0005\u0003qj\u0012a\u0001V;qY\u0016\u0014\u0004cA${y&\u00111P\u000f\u0002\u0005'>lW\r\u0005\u0002P{&\u0011aP\u0004\u0002\t\u0015NtU/\u001c2feB1\u0011\u0011AA\u0006\u0003#qA!a\u0001\u0002\b9\u0019q'!\u0002\n\u0003mJ1!!\u0003;\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t!A*[:u\u0015\r\tIA\u000f\t\u0004+\u0006M\u0011bAA\u000b\u0019\t\u0019B)Z:fe&\fG.\u001b>fe\u000e{g\u000e^3yi\")\u0001n\u0002a\u0001S\"1\u00111D\u0004A\u0002}\fQ\u0002]1sg\u0016\u00148i\u001c8uKb$Hc\u00023\u0002 \u0005\u0005\u00121\u0005\u0005\u0006Q\"\u0001\r!\u001b\u0005\u0006a\"\u0001\r!\u001d\u0005\u0007\u00037A\u0001\u0019A@)\u0007!\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003W\u0011q\u0001^1jYJ,7-\u0001\u0007hKRtU\u000f\u001c7WC2,X-\u0006\u0002\u000289\u0019q*!\u000f\n\u0007\u0005mb\"\u0001\u0004Kg:+H\u000e\\\u0001\u000eO\u0016$h*\u001e7m-\u0006dW/\u001a\u0011")
public class JsValueDeserializer
extends JsonDeserializer<Object> {
    private final Class<?> klass;
    private final JsonConfig jsonConfig;
    private final JsNull$ getNullValue;

    public boolean isCachable() {
        return true;
    }

    public JsValue deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsValue value = this.deserialize(jp, ctxt, (List<DeserializerContext>)Nil$.MODULE$);
        Object object = !this.klass.isAssignableFrom(value.getClass()) ? ctxt.handleUnexpectedToken(this.klass, jp) : BoxedUnit.UNIT;
        return value;
    }

    private Tuple2<Some<JsNumber>, List<DeserializerContext>> parseBigDecimal(JsonParser jp, List<DeserializerContext> parserContext) {
        boolean bl = false;
        JsError jsError = null;
        JsResult<BigDecimal> jsResult = BigDecimalParser$.MODULE$.parse(jp.getText(), this.jsonConfig);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            BigDecimal bigDecimal = (BigDecimal)jsSuccess.value();
            return new Tuple2((Object)new Some((Object)new JsNumber(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal))), parserContext);
        }
        if (jsResult instanceof JsError) {
            Tuple2 tuple2;
            bl = true;
            jsError = (JsError)jsResult;
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> seq = jsError.errors();
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (!option.isEmpty() && (tuple2 = (Tuple2)((Tuple2)option.get())._1()) != null) {
                JsonValidationError jsonValidationError;
                Seq seq2 = (Seq)tuple2._2();
                Option option2 = package$.MODULE$.$plus$colon().unapply((SeqLike)seq2);
                if (!option2.isEmpty() && (jsonValidationError = (JsonValidationError)((Tuple2)option2.get())._1()) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0) {
                    String string;
                    Seq<String> seq3 = jsonValidationError.messages();
                    Option option3 = package$.MODULE$.$plus$colon().unapply(seq3);
                    if (!option3.isEmpty() && "error.expected.numberdigitlimit".equals(string = (String)((Tuple2)option3.get())._1())) {
                        throw new IllegalArgumentException(new StringBuilder(44).append("Number is larger than supported for field '").append(jp.currentName()).append("'").toString());
                    }
                }
            }
        }
        if (bl) {
            Tuple2 tuple2;
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> seq = jsError.errors();
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (!option.isEmpty() && (tuple2 = (Tuple2)((Tuple2)option.get())._1()) != null) {
                JsonValidationError jsonValidationError;
                Seq seq4 = (Seq)tuple2._2();
                Option option4 = package$.MODULE$.$plus$colon().unapply((SeqLike)seq4);
                if (!option4.isEmpty() && (jsonValidationError = (JsonValidationError)((Tuple2)option4.get())._1()) != null) {
                    String string;
                    Seq<String> seq5 = jsonValidationError.messages();
                    Seq<Object> args = jsonValidationError.args();
                    Option option5 = package$.MODULE$.$plus$colon().unapply(seq5);
                    if (!option5.isEmpty() && "error.expected.numberscalelimit".equals(string = (String)((Tuple2)option5.get())._1())) {
                        String scale2 = (String)args.headOption().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)scale -> new StringBuilder(3).append(" (").append(scale).append(")").toString());
                        throw new IllegalArgumentException(new StringBuilder(42).append("Number scale").append(scale2).append(" is out of limits for field '").append(jp.currentName()).append("'").toString());
                    }
                }
            }
        }
        if (bl) {
            Tuple2 tuple2;
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> seq = jsError.errors();
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (!option.isEmpty() && (tuple2 = (Tuple2)((Tuple2)option.get())._1()) != null) {
                JsonValidationError jsonValidationError;
                Seq seq6 = (Seq)tuple2._2();
                Option option6 = package$.MODULE$.$plus$colon().unapply((SeqLike)seq6);
                if (!option6.isEmpty() && (jsonValidationError = (JsonValidationError)((Tuple2)option6.get())._1()) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0) {
                    String string;
                    Seq<String> seq7 = jsonValidationError.messages();
                    Option option7 = package$.MODULE$.$plus$colon().unapply(seq7);
                    if (!option7.isEmpty() && "error.expected.numberformatexception".equals(string = (String)((Tuple2)option7.get())._1())) {
                        throw new NumberFormatException();
                    }
                }
            }
        }
        if (bl) {
            Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors = jsError.errors();
            throw new JsResultException(errors);
        }
        throw new MatchError(jsResult);
    }

    public final JsValue deserialize(JsonParser jp, DeserializationContext ctxt, List<DeserializerContext> parserContext) {
        Tuple2 tuple2;
        while (true) {
            Tuple2 tuple22;
            Object object = jp.getCurrentToken() == null ? jp.nextToken() : BoxedUnit.UNIT;
            int n = jp.getCurrentToken().id();
            switch (n) {
                case 7: 
                case 8: {
                    tuple22 = this.parseBigDecimal(jp, parserContext);
                    break;
                }
                case 6: {
                    tuple22 = new Tuple2((Object)new Some((Object)new JsString(jp.getText())), parserContext);
                    break;
                }
                case 9: {
                    tuple22 = new Tuple2((Object)new Some((Object)JsBoolean$.MODULE$.apply(true)), parserContext);
                    break;
                }
                case 10: {
                    tuple22 = new Tuple2((Object)new Some((Object)JsBoolean$.MODULE$.apply(false)), parserContext);
                    break;
                }
                case 11: {
                    tuple22 = new Tuple2((Object)new Some((Object)JsNull$.MODULE$), parserContext);
                    break;
                }
                case 3: {
                    ReadingList readingList = new ReadingList((ArrayBuffer<JsValue>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
                    tuple22 = new Tuple2((Object)None$.MODULE$, parserContext.$plus$colon((Object)readingList, List$.MODULE$.canBuildFrom()));
                    break;
                }
                case 4: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        DeserializerContext deserializerContext = (DeserializerContext)colon2.head();
                        List stack = colon2.tl$access$1();
                        if (deserializerContext instanceof ReadingList) {
                            ReadingList readingList = (ReadingList)deserializerContext;
                            ArrayBuffer<JsValue> content = readingList.content();
                            tuple22 = new Tuple2((Object)new Some((Object)new JsArray((IndexedSeq<JsValue>)content)), (Object)stack);
                            break;
                        }
                    }
                    throw new RuntimeException("We should have been reading list, something got wrong");
                }
                case 1: {
                    ReadingMap readingMap = new ReadingMap((ListBuffer<Tuple2<String, JsValue>>)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
                    tuple22 = new Tuple2((Object)None$.MODULE$, parserContext.$plus$colon((Object)readingMap, List$.MODULE$.canBuildFrom()));
                    break;
                }
                case 5: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list;
                        DeserializerContext c = (DeserializerContext)colon3.head();
                        List stack = colon3.tl$access$1();
                        if (c instanceof ReadingMap) {
                            ReadingMap readingMap = (ReadingMap)c;
                            KeyRead keyRead = readingMap.setField(jp.currentName());
                            tuple22 = new Tuple2((Object)None$.MODULE$, stack.$plus$colon((Object)keyRead, List$.MODULE$.canBuildFrom()));
                            break;
                        }
                    }
                    throw new RuntimeException("We should be reading map, something got wrong");
                }
                case 2: {
                    List list = parserContext;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list;
                        DeserializerContext deserializerContext = (DeserializerContext)colon4.head();
                        List stack = colon4.tl$access$1();
                        if (deserializerContext instanceof ReadingMap) {
                            ReadingMap readingMap = (ReadingMap)deserializerContext;
                            ListBuffer<Tuple2<String, JsValue>> content = readingMap.content();
                            tuple22 = new Tuple2((Object)new Some((Object)JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)content)), (Object)stack);
                            break;
                        }
                    }
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                case -1: {
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                case 12: {
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            Tuple2 valueAndCtx = tuple22;
            jp.nextToken();
            tuple2 = valueAndCtx;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                List list = (List)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsValue v = (JsValue)some.value();
                    if (Nil$.MODULE$.equals(list)) {
                        return v;
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                List list = (List)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsValue v = (JsValue)some.value();
                    if (list instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list;
                        DeserializerContext previous = (DeserializerContext)colon5.head();
                        List stack = colon5.tl$access$1();
                        DeserializerContext deserializerContext = previous.addValue(v);
                        parserContext = stack.$colon$colon((Object)deserializerContext);
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            Option option = (Option)tuple2._1();
            List nextContext = (List)tuple2._2();
            if (!None$.MODULE$.equals(option)) break;
            parserContext = nextContext;
        }
        throw new MatchError((Object)tuple2);
    }

    public JsNull$ getNullValue() {
        return this.getNullValue;
    }

    public JsValueDeserializer(TypeFactory factory, Class<?> klass, JsonConfig jsonConfig) {
        this.klass = klass;
        this.jsonConfig = jsonConfig;
        this.getNullValue = JsNull$.MODULE$;
    }
}

