/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Mode;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DBApi;
import play.api.db.DBApiProvider$;
import play.api.db.DefaultDBApi;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Injector;
import play.api.inject.NewInstanceInjector$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

@Singleton
public class DBApiProvider
implements Provider<DBApi> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DBApiProvider.class.getDeclaredField("get$lzy1"));
    private final Environment environment;
    private final Configuration configuration;
    private final ConnectionPool defaultConnectionPool;
    private ApplicationLifecycle lifecycle;
    private final Option<Injector> maybeInjector;
    private volatile Object get$lzy1;

    public static Injector $lessinit$greater$default$5() {
        return DBApiProvider$.MODULE$.$lessinit$greater$default$5();
    }

    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Option<Injector> maybeInjector) {
        this.environment = environment;
        this.configuration = configuration;
        this.defaultConnectionPool = defaultConnectionPool;
        this.lifecycle = lifecycle;
        this.maybeInjector = maybeInjector;
    }

    @Inject
    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Injector injector) {
        this(environment, configuration, defaultConnectionPool, lifecycle, (Option<Injector>)Option$.MODULE$.apply((Object)injector));
    }

    public DBApi get() {
        Object object = this.get$lzy1;
        if (object instanceof DBApi) {
            return (DBApi)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DBApi)this.get$lzyINIT1();
    }

    private Object get$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.get$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultDBApi defaultDBApi = null;
                    try {
                        Config config = this.configuration.underlying();
                        String dbKey = config.getString("play.db.config");
                        ConnectionPool pool = (ConnectionPool)this.maybeInjector.map((Function1 & Serializable)injector -> ConnectionPool$.MODULE$.fromConfig(config.getString("play.db.pool"), (Injector)injector, this.environment, this.defaultConnectionPool)).getOrElse(() -> this.$anonfun$3(config));
                        Map configs = config.hasPath(dbKey) ? Configuration$.MODULE$.apply(config).getPrototypedMap(dbKey, "play.db.prototype").view().mapValues((Function1 & Serializable)_$1 -> _$1.underlying()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
                        DefaultDBApi db = new DefaultDBApi((Map<String, Config>)configs, pool, this.environment, (Injector)this.maybeInjector.getOrElse(DBApiProvider::$anonfun$5));
                        this.lifecycle.addStopHook((Function0 & Serializable)() -> Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
                            DBApiProvider.get$lzyINIT1$$anonfun$1$$anonfun$1(db);
                            return BoxedUnit.UNIT;
                        })));
                        Mode mode = this.environment.mode();
                        Mode.Test$ test$ = Mode.Test$.MODULE$;
                        db.initialize(mode == null ? test$ != null : !mode.equals(test$));
                        defaultDBApi = db;
                        object2 = defaultDBApi == null ? LazyVals.NullValue$.MODULE$ : defaultDBApi;
                        this.lifecycle = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return defaultDBApi;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final ConnectionPool $anonfun$3(Config config$2) {
        return ConnectionPool$.MODULE$.fromConfig(config$2.getString("play.db.pool"), this.environment, this.defaultConnectionPool);
    }

    private static final Injector $anonfun$5() {
        return NewInstanceInjector$.MODULE$;
    }

    private static final void get$lzyINIT1$$anonfun$1$$anonfun$1(DefaultDBApi db$2) {
        db$2.shutdown();
    }
}

