/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.sql.DataSource;
import play.api.Configuration$;
import play.api.Environment;
import play.api.MarkerContext$;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.DefaultDBApi$;
import play.api.db.PooledDatabase;
import play.api.inject.Injector;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class DefaultDBApi
implements DBApi {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultDBApi.class.getDeclaredField("databaseByName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultDBApi.class.getDeclaredField("_databases$lzy1"));
    private final Map<String, Config> configuration;
    private final ConnectionPool defaultConnectionPool;
    private final Environment environment;
    private final Injector injector;
    private volatile Object _databases$lzy1;
    private volatile Object databaseByName$lzy1;

    public static ConnectionPool $lessinit$greater$default$2() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$2();
    }

    public static Environment $lessinit$greater$default$3() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$3();
    }

    public static Injector $lessinit$greater$default$4() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$4();
    }

    public DefaultDBApi(Map<String, Config> configuration, ConnectionPool defaultConnectionPool, Environment environment, Injector injector) {
        this.configuration = configuration;
        this.defaultConnectionPool = defaultConnectionPool;
        this.environment = environment;
        this.injector = injector;
    }

    private Seq<Database> _databases() {
        Object object = this._databases$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this._databases$lzyINIT1();
    }

    private Object _databases$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this._databases$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = ((IterableOnceOps)this.configuration.map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Config config = (Config)tuple2._2();
                                ConnectionPool pool = ConnectionPool$.MODULE$.fromConfig(config.getString("pool"), this.injector, this.environment, this.defaultConnectionPool);
                                return new PooledDatabase(name, config, this.environment, pool);
                            }
                            throw new MatchError((Object)tuple2);
                        })).toSeq();
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this._databases$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Database> databases() {
        return this._databases();
    }

    private Map<String, Database> databaseByName() {
        Object object = this.databaseByName$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.databaseByName$lzyINIT1();
    }

    private Object databaseByName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.databaseByName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = this._databases().iterator().map((Function1 & Serializable)db -> Tuple2$.MODULE$.apply((Object)db.name(), db)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.databaseByName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Database database(String name) {
        return (Database)this.databaseByName().getOrElse((Object)name, () -> DefaultDBApi.database$$anonfun$1(name));
    }

    public void connect(boolean logConnection) {
        this._databases().foreach((Function1)(JProcedure1 & Serializable)db -> {
            try {
                db.getConnection().close();
                if (logConnection) {
                    DefaultDBApi$.play$api$db$DefaultDBApi$$$logger.info(() -> DefaultDBApi.connect$$anonfun$1$$anonfun$1(db), MarkerContext$.MODULE$.NoMarker());
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    throw Configuration$.MODULE$.apply((Config)this.configuration.apply((Object)db.name())).reportError("url", "Cannot connect to database [" + db.name() + "]", (Option)Some$.MODULE$.apply((Object)e));
                }
                throw throwable;
            }
        });
    }

    public boolean connect$default$1() {
        return false;
    }

    public void initialize(boolean logInitialization) {
        this._databases().foreach((Function1 & Serializable)db -> {
            DataSource dataSource;
            try {
                if (logInitialization) {
                    DefaultDBApi$.play$api$db$DefaultDBApi$$$logger.info(() -> DefaultDBApi.initialize$$anonfun$1$$anonfun$1(db), MarkerContext$.MODULE$.NoMarker());
                }
                dataSource = db.dataSource();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    throw Configuration$.MODULE$.apply((Config)this.configuration.apply((Object)db.name())).reportError("url", "Cannot initialize to database [" + db.name() + "]", (Option)Some$.MODULE$.apply((Object)e));
                }
                throw throwable;
            }
            return dataSource;
        });
    }

    public void shutdown() {
        this._databases().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.shutdown());
    }

    private static final Database database$$anonfun$1(String name$1) {
        throw new IllegalArgumentException("Could not find database for " + name$1);
    }

    private static final String connect$$anonfun$1$$anonfun$1(Database db$1) {
        return "Database [" + db$1.name() + "] connected";
    }

    private static final String initialize$$anonfun$1$$anonfun$1(Database db$2) {
        return "Database [" + db$2.name() + "] initialized";
    }
}

