/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.Serializable;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.evolutions.ApplicationEvolutions$;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsApi;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.InvalidDatabaseRevision$;
import play.api.db.evolutions.Script;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.BuildLink;
import play.core.HandleWebCommandSupport;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

@Singleton
public class EvolutionsWebCommands
implements HandleWebCommandSupport {
    private final DBApi dbApi;
    private final EvolutionsApi evolutions;
    private final EvolutionsReader reader;
    private final EvolutionsConfig config;
    private boolean checkedAlready;

    @Inject
    public EvolutionsWebCommands(DBApi dbApi, EvolutionsApi evolutions, EvolutionsReader reader, EvolutionsConfig config) {
        this.dbApi = dbApi;
        this.evolutions = evolutions;
        this.reader = reader;
        this.config = config;
        this.checkedAlready = false;
    }

    public boolean checkedAlready() {
        return this.checkedAlready;
    }

    public void checkedAlready_$eq(boolean x$1) {
        this.checkedAlready = x$1;
    }

    public Option<Result> handleWebCommand(RequestHeader request, BuildLink buildLink, File path) {
        LazyRef lazyRef = new LazyRef();
        Regex applyEvolutions = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("/@evolutions/apply/([a-zA-Z0-9_-]+)"));
        Regex resolveEvolutions = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("/@evolutions/resolve/([a-zA-Z0-9_-]+)/([0-9]+)"));
        String string = request.path().replaceFirst("^((?!/@evolutions).)*(/@evolutions.*$)", "$2");
        if (string != null) {
            List list;
            List list2;
            Option option = applyEvolutions.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list2 = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String db = string2 = (String)list2.apply(0);
                EvolutionsDatasourceConfig dbConfig = this.config.forDatasource(db);
                Seq<Script> scripts = this.evolutions.scripts(db, this.reader, dbConfig.schema(), dbConfig.metaTable());
                this.evolutions.evolve(db, scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
                buildLink.forceReload();
                return Some$.MODULE$.apply((Object)Results$.MODULE$.Redirect(EvolutionsWebCommands.redirectUrl$1(lazyRef, request), Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3()));
            }
            Option option2 = resolveEvolutions.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list = (List)option2.get()).lengthCompare(2) == 0) {
                String string3 = (String)list.apply(0);
                String string4 = (String)list.apply(1);
                String db = string3;
                String rev = string4;
                EvolutionsDatasourceConfig dbConfig = this.config.forDatasource(db);
                this.evolutions.resolve(db, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rev)), dbConfig.schema(), dbConfig.metaTable());
                buildLink.forceReload();
                return Some$.MODULE$.apply((Object)Results$.MODULE$.Redirect(EvolutionsWebCommands.redirectUrl$1(lazyRef, request), Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3()));
            }
        }
        EvolutionsWebCommands evolutionsWebCommands = this;
        synchronized (evolutionsWebCommands) {
            if (!this.checkedAlready()) {
                this.dbApi.databases().foreach((Function1)(JProcedure1 & Serializable)_$8 -> ApplicationEvolutions$.MODULE$.runEvolutions((Database)_$8, this.config, this.evolutions, this.reader, (Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit>)(Function4 & Serializable)(v1, v2, v3, v4) -> {
                    EvolutionsWebCommands.handleWebCommand$$anonfun$1$$anonfun$1((String)v1, (EvolutionsDatasourceConfig)v2, (Seq)v3, BoxesRunTime.unboxToBoolean((Object)v4));
                    return BoxedUnit.UNIT;
                }));
                this.checkedAlready_$eq(true);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
        return None$.MODULE$;
    }

    private static final String redirectUrl$lzyINIT1$1$$anonfun$3() {
        return "/";
    }

    private static final String redirectUrl$lzyINIT1$1(LazyRef redirectUrl$lzy1$1, RequestHeader request$1) {
        String string;
        LazyRef lazyRef = redirectUrl$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(redirectUrl$lzy1$1.initialized() ? redirectUrl$lzy1$1.value() : redirectUrl$lzy1$1.initialize((Object)((String)request$1.queryString().get((Object)"redirect").filterNot((Function1 & Serializable)_$6 -> _$6.isEmpty()).map((Function1 & Serializable)_$7 -> (String)_$7.head()).getOrElse(EvolutionsWebCommands::redirectUrl$lzyINIT1$1$$anonfun$3))));
        }
        return string;
    }

    private static final String redirectUrl$1(LazyRef redirectUrl$lzy1$2, RequestHeader request$2) {
        return (String)(redirectUrl$lzy1$2.initialized() ? redirectUrl$lzy1$2.value() : EvolutionsWebCommands.redirectUrl$lzyINIT1$1(redirectUrl$lzy1$2, request$2));
    }

    private static final /* synthetic */ void handleWebCommand$$anonfun$1$$anonfun$1(String db, EvolutionsDatasourceConfig dbConfig, Seq scripts, boolean hasDown) {
        throw InvalidDatabaseRevision$.MODULE$.apply(db, Evolutions$.MODULE$.toHumanReadableScript((Seq<Script>)scripts));
    }
}

