/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public final class EvolutionsHelper$
implements Serializable {
    public static final EvolutionsHelper$ MODULE$ = new EvolutionsHelper$();

    private EvolutionsHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EvolutionsHelper$.class);
    }

    public String substituteVariables(String sql, Map<String, String> substitutionsMappings, String prefix, String suffix, boolean escape) {
        ObjectRef result = ObjectRef.create((Object)sql);
        substitutionsMappings.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return true;
            }
            return false;
        }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                result$1.elem = ((String)result$1.elem).replaceAll("(?i)(^|[^!])" + Pattern.quote(prefix + k + suffix), "$1" + Matcher.quoteReplacement(v));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (escape) {
            return ((String)result.elem).replaceAll("(?i)" + Pattern.quote("!" + prefix) + "([^" + Pattern.quote(suffix) + "]*)" + Pattern.quote(suffix), Matcher.quoteReplacement(prefix) + "$1" + Matcher.quoteReplacement(suffix));
        }
        return (String)result.elem;
    }

    public String applySchemaAndTable(String sql, String schema, String table) {
        String withSchema = this.applySchema(sql, schema);
        return this.applyTableName(withSchema, table);
    }

    public String applyConfig(String sql, EvolutionsDatasourceConfig config) {
        return this.applySchemaAndTable(sql, config.schema(), config.metaTable());
    }

    public String applySchema(String sql, String schema) {
        return sql.replaceAll("\\$\\{schema}", (String)Option$.MODULE$.apply((Object)schema).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.trim()))).map((Function1 & Serializable)_$2 -> _$2.trim() + ".").getOrElse(EvolutionsHelper$::applySchema$$anonfun$3));
    }

    public String applyTableName(String sql, String table) {
        return sql.replaceAll("\\$\\{evolutions_table}", this.getPreparedTableName(table));
    }

    private String getPreparedTableName(String tableName) {
        return (String)Option$.MODULE$.apply((Object)tableName).filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3.trim()))).getOrElse(EvolutionsHelper$::getPreparedTableName$$anonfun$2);
    }

    private static final String applySchema$$anonfun$3() {
        return "";
    }

    private static final String getPreparedTableName$$anonfun$2() {
        return "play_evolutions";
    }
}

