/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.concurrent;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import jakarta.inject.Provider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.annotation.ApiMayChange;
import play.api.libs.concurrent.ActorModule;
import play.api.libs.concurrent.Pekko$;
import play.api.libs.concurrent.TypedActorRefProvider;
import play.api.libs.concurrent.TypedPekko$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag;

public interface PekkoGuiceSupport {
    private Binder accessBinder() {
        Method method = AbstractModule.class.getDeclaredMethod("binder", new Class[0]);
        if (!method.canAccess(this)) {
            method.setAccessible(true);
        }
        return (Binder)method.invoke((Object)this, new Object[0]);
    }

    public static void bindActor$(PekkoGuiceSupport $this, String name, Function1 props, ClassTag evidence$1) {
        $this.bindActor(name, (Function1<Props, Props>)props, evidence$1);
    }

    default public <T extends Actor> void bindActor(String name, Function1<Props, Props> props, ClassTag<T> evidence$1) {
        this.accessBinder().bind(ActorRef.class).annotatedWith((Annotation)Names.named((String)name)).toProvider(Providers.guicify((Provider)Pekko$.MODULE$.providerOf(name, props, evidence$1))).asEagerSingleton();
    }

    public static Function1 bindActor$default$2$(PekkoGuiceSupport $this) {
        return $this.bindActor$default$2();
    }

    default public <T extends Actor> Function1<Props, Props> bindActor$default$2() {
        return (Function1 & Serializable)x -> (Props)Predef$.MODULE$.identity(x);
    }

    public static void bindActorFactory$(PekkoGuiceSupport $this, ClassTag evidence$1, ClassTag evidence$2) {
        $this.bindActorFactory(evidence$1, evidence$2);
    }

    default public <ActorClass extends Actor, FactoryClass> void bindActorFactory(ClassTag<ActorClass> evidence$1, ClassTag<FactoryClass> evidence$2) {
        this.accessBinder().install(new FactoryModuleBuilder().implement(Actor.class, ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).build(((ClassTag)Predef$.MODULE$.implicitly(evidence$2)).runtimeClass()));
    }

    public static void bindTypedActor$(PekkoGuiceSupport $this, Behavior behavior, String name, ClassTag evidence$1) {
        $this.bindTypedActor(behavior, name, evidence$1);
    }

    @ApiMayChange
    default public <T> void bindTypedActor(Behavior<T> behavior, String name, ClassTag<T> evidence$1) {
        this.accessBinder().bind(TypedPekko$.MODULE$.behaviorOf(evidence$1)).toInstance(behavior);
        this.bindTypedActorRef(name, evidence$1);
    }

    public static void bindTypedActor$(PekkoGuiceSupport $this, ActorModule actorModule, String name, ClassTag evidence$1) {
        $this.bindTypedActor(actorModule, name, evidence$1);
    }

    @ApiMayChange
    default public <T> void bindTypedActor(ActorModule actorModule, String name, ClassTag<T> evidence$1) {
        this.accessBinder().install((Module)actorModule);
        this.bindTypedActorRef(name, evidence$1);
    }

    public static void bindTypedActorRef$(PekkoGuiceSupport $this, String name, ClassTag evidence$1) {
        $this.bindTypedActorRef(name, evidence$1);
    }

    default public <T> void bindTypedActorRef(String name, ClassTag<T> evidence$1) {
        this.accessBinder().bind(TypedPekko$.MODULE$.actorRefOf(evidence$1)).toProvider(new TypedActorRefProvider<T>(name, evidence$1)).asEagerSingleton();
    }
}

