/*
 * Decompiled with CFR 0.152.
 */
package play.api.inject.guice;

import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.Application;
import play.api.Configuration;
import play.api.Environment;
import play.api.Environment$;
import play.api.LoggerConfigurator$;
import play.api.OptionalDevContext;
import play.api.OptionalSourceMapper;
import play.api.OptionalSourceMapperProvider;
import play.api.Play$;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.inject.guice.AdditionalRouterProvider;
import play.api.inject.guice.BinderOption;
import play.api.inject.guice.FakeRouterConfig;
import play.api.inject.guice.FakeRouterConfig$;
import play.api.inject.guice.FakeRouterProvider;
import play.api.inject.guice.GuiceApplicationBuilder$;
import play.api.inject.guice.GuiceBuilder;
import play.api.inject.guice.GuiceableModule;
import play.api.inject.guice.GuiceableModule$;
import play.api.inject.package$;
import play.api.mvc.Handler;
import play.api.routing.Router;
import play.core.DefaultWebCommands;
import play.core.WebCommands;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class GuiceApplicationBuilder
extends GuiceBuilder<GuiceApplicationBuilder>
implements Product,
Serializable {
    private final Environment environment;
    private final Configuration configuration;
    private final Seq modules;
    private final Seq overrides;
    private final Seq disabled;
    private final Set binderOptions;
    private final boolean eagerly;
    private final Function1 loadConfiguration;
    private final Function2 loadModules;

    public static GuiceApplicationBuilder apply(Environment environment, Configuration configuration, Seq<GuiceableModule> seq, Seq<GuiceableModule> seq2, Seq<Class<?>> seq3, Set<BinderOption> set, boolean bl, Function1<Environment, Configuration> function1, Function2<Environment, Configuration, Seq<GuiceableModule>> function2) {
        return GuiceApplicationBuilder$.MODULE$.apply(environment, configuration, seq, seq2, seq3, set, bl, function1, function2);
    }

    public static GuiceApplicationBuilder fromProduct(Product product) {
        return GuiceApplicationBuilder$.MODULE$.fromProduct(product);
    }

    public static GuiceApplicationBuilder unapply(GuiceApplicationBuilder guiceApplicationBuilder) {
        return GuiceApplicationBuilder$.MODULE$.unapply(guiceApplicationBuilder);
    }

    public static Environment $lessinit$greater$default$1() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$1();
    }

    public static Configuration $lessinit$greater$default$2() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<GuiceableModule> $lessinit$greater$default$3() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<GuiceableModule> $lessinit$greater$default$4() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Class<?>> $lessinit$greater$default$5() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$5();
    }

    public static Set<BinderOption> $lessinit$greater$default$6() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$7();
    }

    public static Function1<Environment, Configuration> $lessinit$greater$default$8() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$8();
    }

    public static Function2<Environment, Configuration, Seq<GuiceableModule>> $lessinit$greater$default$9() {
        return GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$9();
    }

    public GuiceApplicationBuilder(Environment environment, Configuration configuration, Seq<GuiceableModule> modules, Seq<GuiceableModule> overrides, Seq<Class<?>> disabled, Set<BinderOption> binderOptions, boolean eagerly, Function1<Environment, Configuration> loadConfiguration, Function2<Environment, Configuration, Seq<GuiceableModule>> loadModules) {
        this.environment = environment;
        this.configuration = configuration;
        this.modules = modules;
        this.overrides = overrides;
        this.disabled = disabled;
        this.binderOptions = binderOptions;
        this.eagerly = eagerly;
        this.loadConfiguration = loadConfiguration;
        this.loadModules = loadModules;
        super(environment, configuration, modules, overrides, disabled, binderOptions, eagerly);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.environment()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.configuration()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.modules()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.overrides()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.disabled()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.binderOptions()));
        n = Statics.mix((int)n, (int)(this.eagerly() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.loadConfiguration()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.loadModules()));
        return Statics.finalizeHash((int)n, (int)9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GuiceApplicationBuilder)) return false;
        GuiceApplicationBuilder guiceApplicationBuilder = (GuiceApplicationBuilder)object;
        if (this.eagerly() != guiceApplicationBuilder.eagerly()) return false;
        Environment environment = this.environment();
        Environment environment2 = guiceApplicationBuilder.environment();
        if (environment == null) {
            if (environment2 != null) {
                return false;
            }
        } else if (!environment.equals(environment2)) return false;
        Configuration configuration = this.configuration();
        Configuration configuration2 = guiceApplicationBuilder.configuration();
        if (configuration == null) {
            if (configuration2 != null) {
                return false;
            }
        } else if (!configuration.equals(configuration2)) return false;
        Seq<GuiceableModule> seq = this.modules();
        Seq<GuiceableModule> seq2 = guiceApplicationBuilder.modules();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<GuiceableModule> seq3 = this.overrides();
        Seq<GuiceableModule> seq4 = guiceApplicationBuilder.overrides();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Class<?>> seq5 = this.disabled();
        Seq<Class<?>> seq6 = guiceApplicationBuilder.disabled();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        Set<BinderOption> set = this.binderOptions();
        Set<BinderOption> set2 = guiceApplicationBuilder.binderOptions();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Function1<Environment, Configuration> function1 = this.loadConfiguration();
        Function1<Environment, Configuration> function12 = guiceApplicationBuilder.loadConfiguration();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function2<Environment, Configuration, Seq<GuiceableModule>> function2 = this.loadModules();
        Function2<Environment, Configuration, Seq<GuiceableModule>> function22 = guiceApplicationBuilder.loadModules();
        if (function2 == null) {
            if (function22 == null) return true;
            return false;
        } else {
            if (!function2.equals(function22)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GuiceApplicationBuilder;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "GuiceApplicationBuilder";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "environment";
            }
            case 1: {
                return "configuration";
            }
            case 2: {
                return "modules";
            }
            case 3: {
                return "overrides";
            }
            case 4: {
                return "disabled";
            }
            case 5: {
                return "binderOptions";
            }
            case 6: {
                return "eagerly";
            }
            case 7: {
                return "loadConfiguration";
            }
            case 8: {
                return "loadModules";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Environment environment() {
        return this.environment;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Seq<GuiceableModule> modules() {
        return this.modules;
    }

    public Seq<GuiceableModule> overrides() {
        return this.overrides;
    }

    public Seq<Class<?>> disabled() {
        return this.disabled;
    }

    public Set<BinderOption> binderOptions() {
        return this.binderOptions;
    }

    public boolean eagerly() {
        return this.eagerly;
    }

    public Function1<Environment, Configuration> loadConfiguration() {
        return this.loadConfiguration;
    }

    public Function2<Environment, Configuration, Seq<GuiceableModule>> loadModules() {
        return this.loadModules;
    }

    public GuiceApplicationBuilder() {
        this(Environment$.MODULE$.simple(Environment$.MODULE$.simple$default$1(), Environment$.MODULE$.simple$default$2()), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$2(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$3(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$4(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$5(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$6(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$7(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$8(), GuiceApplicationBuilder$.MODULE$.$lessinit$greater$default$9());
    }

    public GuiceApplicationBuilder globalApp(boolean enabled) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Play$.MODULE$.GlobalAppConfigKey());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)enabled));
        return (GuiceApplicationBuilder)this.configure((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public GuiceApplicationBuilder loadConfig(Function1<Environment, Configuration> loader) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), loader, this.copy$default$9());
    }

    public GuiceApplicationBuilder loadConfig(Configuration conf) {
        return this.loadConfig((Function1<Environment, Configuration>)(Function1 & Serializable)env -> conf);
    }

    public GuiceApplicationBuilder load(Function2<Environment, Configuration, Seq<GuiceableModule>> loader) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), loader);
    }

    public GuiceApplicationBuilder load(Seq<GuiceableModule> modules) {
        return this.load((Function2<Environment, Configuration, Seq<GuiceableModule>>)(Function2 & Serializable)(env, conf) -> modules);
    }

    public GuiceApplicationBuilder appRoutes(Function1<Application, PartialFunction<Tuple2<String, String>, Handler>> routes) {
        return (GuiceApplicationBuilder)((GuiceBuilder)this.bindings((Seq<GuiceableModule>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(FakeRouterConfig.class)).to(() -> GuiceApplicationBuilder.appRoutes$$anonfun$1(routes)))}))).overrides((Seq<GuiceableModule>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(Router.class)).toProvider(ClassTag$.MODULE$.apply(FakeRouterProvider.class)).in(ClassTag$.MODULE$.apply(Singleton.class)))}));
    }

    public GuiceApplicationBuilder routes(PartialFunction<Tuple2<String, String>, Handler> routesFunc) {
        return this.appRoutes((Function1<Application, PartialFunction<Tuple2<String, String>, Handler>>)(Function1 & Serializable)_$1 -> routesFunc);
    }

    public GuiceApplicationBuilder router(Router router) {
        return (GuiceApplicationBuilder)this.overrides((Seq<GuiceableModule>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(Router.class)).toInstance((Object)router))}));
    }

    public GuiceApplicationBuilder additionalRouter(Router router) {
        return (GuiceApplicationBuilder)this.overrides((Seq<GuiceableModule>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(Router.class)).to((Provider)new AdditionalRouterProvider(router)))}));
    }

    @Override
    public Module applicationModule() {
        this.registerExceptionHandlers();
        Configuration initialConfiguration = (Configuration)this.loadConfiguration().apply((Object)this.environment());
        Configuration appConfiguration = this.configuration().withFallback(initialConfiguration);
        ILoggerFactory loggerFactory = this.configureLoggerFactory(appConfiguration);
        Seq loadedModules = (Seq)this.loadModules().apply((Object)this.environment(), (Object)appConfiguration);
        return ((GuiceBuilder)((GuiceBuilder)this.copy(this.copy$default$1(), appConfiguration, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9()).bindings((Seq<GuiceableModule>)loadedModules)).bindings((Seq<GuiceableModule>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GuiceableModule[]{GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(ILoggerFactory.class)).to(() -> GuiceApplicationBuilder.applicationModule$$anonfun$1(loggerFactory))), GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(OptionalDevContext.class)).to(GuiceApplicationBuilder::applicationModule$$anonfun$2)), GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(OptionalSourceMapper.class)).toProvider(ClassTag$.MODULE$.apply(OptionalSourceMapperProvider.class))), GuiceableModule$.MODULE$.fromPlayBinding(package$.MODULE$.bind(ClassTag$.MODULE$.apply(WebCommands.class)).to(GuiceApplicationBuilder::applicationModule$$anonfun$3).in(ClassTag$.MODULE$.apply(Singleton.class)))}))).createModule();
    }

    public void registerExceptionHandlers() {
        HttpErrorHandlerExceptions$.MODULE$.registerHandler("guice-provision-exception-handler", (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof ProvisionException) {
                    ProvisionException pe = (ProvisionException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ProvisionException) {
                    ProvisionException pe = (ProvisionException)throwable;
                    Collection wrappedErrorMessages = pe.getErrorMessages();
                    if (wrappedErrorMessages != null && wrappedErrorMessages.size() == 1) {
                        return Option$.MODULE$.apply((Object)((Message)wrappedErrorMessages.iterator().next()).getCause()).getOrElse(() -> GuiceApplicationBuilder.play$api$inject$guice$GuiceApplicationBuilder$$anon$1$$_$applyOrElse$$anonfun$1(pe));
                    }
                    return pe;
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$inject$guice$GuiceApplicationBuilder$$anon$1$$_$applyOrElse$$anonfun$1(com.google.inject.ProvisionException )}, serializedLambda);
            }
        });
    }

    public ILoggerFactory configureLoggerFactory(Configuration configuration) {
        ILoggerFactory loggerFactory = (ILoggerFactory)LoggerConfigurator$.MODULE$.apply(this.environment().classLoader()).map((Function1 & Serializable)lc -> {
            lc.configure(this.environment(), configuration, Predef$.MODULE$.Map().empty());
            return lc.loggerFactory();
        }).getOrElse(GuiceApplicationBuilder::$anonfun$2);
        if (this.shouldDisplayLoggerDeprecationMessage(configuration)) {
            Logger logger = loggerFactory.getLogger("application");
            logger.warn("Logger configuration in conf files is deprecated and has no effect. Use a logback configuration file instead.");
        }
        return loggerFactory;
    }

    public Application build() {
        return (Application)this.injector().instanceOf(ClassTag$.MODULE$.apply(Application.class));
    }

    private GuiceApplicationBuilder copy(Environment environment, Configuration configuration, Seq<GuiceableModule> modules, Seq<GuiceableModule> overrides, Seq<Class<?>> disabled, Set<BinderOption> binderOptions, boolean eagerly, Function1<Environment, Configuration> loadConfiguration, Function2<Environment, Configuration, Seq<GuiceableModule>> loadModules) {
        return new GuiceApplicationBuilder(environment, configuration, modules, overrides, disabled, binderOptions, eagerly, loadConfiguration, loadModules);
    }

    private Environment copy$default$1() {
        return this.environment();
    }

    private Configuration copy$default$2() {
        return this.configuration();
    }

    private Seq<GuiceableModule> copy$default$3() {
        return this.modules();
    }

    private Seq<GuiceableModule> copy$default$4() {
        return this.overrides();
    }

    private Seq<Class<?>> copy$default$5() {
        return this.disabled();
    }

    private Set<BinderOption> copy$default$6() {
        return this.binderOptions();
    }

    private boolean copy$default$7() {
        return this.eagerly();
    }

    private Function1<Environment, Configuration> copy$default$8() {
        return this.loadConfiguration();
    }

    private Function2<Environment, Configuration, Seq<GuiceableModule>> copy$default$9() {
        return this.loadModules();
    }

    @Override
    public GuiceApplicationBuilder newBuilder(Environment environment, Configuration configuration, Seq<GuiceableModule> modules, Seq<GuiceableModule> overrides, Seq<Class<?>> disabled, Set<BinderOption> binderOptions, boolean eagerly) {
        return this.copy(environment, configuration, modules, overrides, disabled, binderOptions, eagerly, this.copy$default$8(), this.copy$default$9());
    }

    public Set<BinderOption> newBuilder$default$6() {
        return this.binderOptions();
    }

    public boolean shouldDisplayLoggerDeprecationMessage(Configuration appConfiguration) {
        List deprecatedValues = (List)new .colon.colon((Object)"DEBUG", (List)new .colon.colon((Object)"WARN", (List)new .colon.colon((Object)"ERROR", (List)new .colon.colon((Object)"INFO", (List)new .colon.colon((Object)"TRACE", (List)new .colon.colon((Object)"OFF", (List)Nil$.MODULE$))))));
        if (appConfiguration.underlying().hasPath("logger")) {
            Object object = appConfiguration.underlying().getAnyRef("logger");
            if (object instanceof String) {
                String value = (String)object;
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"logger");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                return GuiceApplicationBuilder.hasDeprecatedValue$1(deprecatedValues, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            if (object instanceof Map) {
                Map value;
                Map v = value = (Map)object;
                return GuiceApplicationBuilder.hasDeprecatedValue$1(deprecatedValues, CollectionConverters$.MODULE$.MapHasAsScala(v).asScala());
            }
            return false;
        }
        return false;
    }

    public Environment _1() {
        return this.environment();
    }

    public Configuration _2() {
        return this.configuration();
    }

    public Seq<GuiceableModule> _3() {
        return this.modules();
    }

    public Seq<GuiceableModule> _4() {
        return this.overrides();
    }

    public Seq<Class<?>> _5() {
        return this.disabled();
    }

    public Set<BinderOption> _6() {
        return this.binderOptions();
    }

    public boolean _7() {
        return this.eagerly();
    }

    public Function1<Environment, Configuration> _8() {
        return this.loadConfiguration();
    }

    public Function2<Environment, Configuration, Seq<GuiceableModule>> _9() {
        return this.loadModules();
    }

    private static final FakeRouterConfig appRoutes$$anonfun$1(Function1 routes$1) {
        return FakeRouterConfig$.MODULE$.apply((Function1<Application, PartialFunction<Tuple2<String, String>, Handler>>)routes$1);
    }

    private static final ILoggerFactory applicationModule$$anonfun$1(ILoggerFactory loggerFactory$1) {
        return loggerFactory$1;
    }

    private static final OptionalDevContext applicationModule$$anonfun$2() {
        return new OptionalDevContext((Option)None$.MODULE$);
    }

    private static final DefaultWebCommands applicationModule$$anonfun$3() {
        return new DefaultWebCommands();
    }

    public static final Throwable play$api$inject$guice$GuiceApplicationBuilder$$anon$1$$_$applyOrElse$$anonfun$1(ProvisionException pe$1) {
        return pe$1;
    }

    private static final ILoggerFactory $anonfun$2() {
        return LoggerFactory.getILoggerFactory();
    }

    private static final boolean hasDeprecatedValue$1(List deprecatedValues$1, scala.collection.mutable.Map values) {
        return values.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String value;
                Object object = tuple2._2();
                if (object instanceof String && deprecatedValues$1.contains((Object)(value = (String)object))) {
                    return true;
                }
                if (object instanceof Map) {
                    Map value2;
                    Map v = value2 = (Map)object;
                    return GuiceApplicationBuilder.hasDeprecatedValue$1(deprecatedValues$1, CollectionConverters$.MODULE$.MapHasAsScala(v).asScala());
                }
            }
            return false;
        });
    }
}

