/*
 * Decompiled with CFR 0.152.
 */
package play.api.inject.guice;

import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.io.File;
import java.io.Serializable;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Mode;
import play.api.PlayException;
import play.api.inject.Binding;
import play.api.inject.Injector;
import play.api.inject.guice.BinderOption;
import play.api.inject.guice.BinderOption$DisableCircularProxies$;
import play.api.inject.guice.BinderOption$RequireAtInjectOnConstructors$;
import play.api.inject.guice.BinderOption$RequireExactBindingAnnotations$;
import play.api.inject.guice.BinderOption$RequireExplicitBindings$;
import play.api.inject.guice.GuiceClassLoader;
import play.api.inject.guice.GuiceInjector;
import play.api.inject.guice.GuiceInjectorWithClassLoaderProvider;
import play.api.inject.guice.GuiceableModule;
import play.api.inject.guice.GuiceableModule$;
import play.api.inject.package$;
import play.inject.DelegateInjector;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class GuiceBuilder<Self> {
    private final Environment environment;
    private final Configuration configuration;
    private final scala.collection.immutable.Seq<GuiceableModule> modules;
    private final scala.collection.immutable.Seq<GuiceableModule> overrides;
    private final scala.collection.immutable.Seq<Class<?>> disabled;
    private final Set<BinderOption> binderOptions;
    private final boolean eagerly;

    public GuiceBuilder(Environment environment, Configuration configuration, scala.collection.immutable.Seq<GuiceableModule> modules, scala.collection.immutable.Seq<GuiceableModule> overrides, scala.collection.immutable.Seq<Class<?>> disabled, Set<BinderOption> binderOptions, boolean eagerly) {
        this.environment = environment;
        this.configuration = configuration;
        this.modules = modules;
        this.overrides = overrides;
        this.disabled = disabled;
        this.binderOptions = binderOptions;
        this.eagerly = eagerly;
    }

    public final Self in(Environment env) {
        return this.copyBuilder(env, this.copyBuilder$default$2(), this.copyBuilder$default$3(), this.copyBuilder$default$4(), this.copyBuilder$default$5(), this.copyBuilder$default$6(), this.copyBuilder$default$7());
    }

    public final Self in(File path) {
        return this.copyBuilder(this.environment.copy(path, this.environment.copy$default$2(), this.environment.copy$default$3()), this.copyBuilder$default$2(), this.copyBuilder$default$3(), this.copyBuilder$default$4(), this.copyBuilder$default$5(), this.copyBuilder$default$6(), this.copyBuilder$default$7());
    }

    public final Self in(Mode mode) {
        return this.copyBuilder(this.environment.copy(this.environment.copy$default$1(), this.environment.copy$default$2(), mode), this.copyBuilder$default$2(), this.copyBuilder$default$3(), this.copyBuilder$default$4(), this.copyBuilder$default$5(), this.copyBuilder$default$6(), this.copyBuilder$default$7());
    }

    public final Self in(ClassLoader classLoader) {
        return this.copyBuilder(this.environment.copy(this.environment.copy$default$1(), classLoader, this.environment.copy$default$3()), this.copyBuilder$default$2(), this.copyBuilder$default$3(), this.copyBuilder$default$4(), this.copyBuilder$default$5(), this.copyBuilder$default$6(), this.copyBuilder$default$7());
    }

    public final Self eagerlyLoaded() {
        return this.copyBuilder(this.copyBuilder$default$1(), this.copyBuilder$default$2(), this.copyBuilder$default$3(), this.copyBuilder$default$4(), this.copyBuilder$default$5(), this.copyBuilder$default$6(), true);
    }

    public final Self configure(Configuration conf) {
        Configuration configuration = conf.withFallback(this.configuration);
        Environment environment = this.copyBuilder$default$1();
        scala.collection.immutable.Seq<GuiceableModule> seq = this.copyBuilder$default$3();
        scala.collection.immutable.Seq<GuiceableModule> seq2 = this.copyBuilder$default$4();
        scala.collection.immutable.Seq<Class<?>> seq3 = this.copyBuilder$default$5();
        Set<BinderOption> set = this.copyBuilder$default$6();
        boolean bl = this.copyBuilder$default$7();
        return this.copyBuilder(environment, configuration, seq, seq2, seq3, set, bl);
    }

    public final Self configure(Map<String, Object> conf) {
        return this.configure(Configuration$.MODULE$.from(conf));
    }

    public final Self configure(scala.collection.immutable.Seq<Tuple2<String, Object>> conf) {
        return this.configure((Map<String, Object>)conf.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Self withBinderOption(BinderOption opt, boolean enabled) {
        Set set = enabled ? (Set)this.binderOptions.$plus((Object)opt) : (Set)this.binderOptions.$minus((Object)opt);
        Environment environment = this.copyBuilder$default$1();
        Configuration configuration = this.copyBuilder$default$2();
        scala.collection.immutable.Seq<GuiceableModule> seq = this.copyBuilder$default$3();
        scala.collection.immutable.Seq<GuiceableModule> seq2 = this.copyBuilder$default$4();
        scala.collection.immutable.Seq<Class<?>> seq3 = this.copyBuilder$default$5();
        boolean bl = this.copyBuilder$default$7();
        return this.copyBuilder(environment, configuration, seq, seq2, seq3, (Set<BinderOption>)set, bl);
    }

    private boolean withBinderOption$default$2() {
        return false;
    }

    public final Self disableCircularProxies(boolean disable) {
        return this.withBinderOption(BinderOption$DisableCircularProxies$.MODULE$, disable);
    }

    public boolean disableCircularProxies$default$1() {
        return true;
    }

    public final Self requireExactBindingAnnotations(boolean require) {
        return this.withBinderOption(BinderOption$RequireExactBindingAnnotations$.MODULE$, require);
    }

    public boolean requireExactBindingAnnotations$default$1() {
        return true;
    }

    public final Self requireAtInjectOnConstructors(boolean require) {
        return this.withBinderOption(BinderOption$RequireAtInjectOnConstructors$.MODULE$, require);
    }

    public boolean requireAtInjectOnConstructors$default$1() {
        return true;
    }

    public final Self requireExplicitBindings(boolean require) {
        return this.withBinderOption(BinderOption$RequireExplicitBindings$.MODULE$, require);
    }

    public boolean requireExplicitBindings$default$1() {
        return true;
    }

    public final Self bindings(scala.collection.immutable.Seq<GuiceableModule> bindModules) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.modules.$plus$plus(bindModules);
        Environment environment = this.copyBuilder$default$1();
        Configuration configuration = this.copyBuilder$default$2();
        scala.collection.immutable.Seq<GuiceableModule> seq2 = this.copyBuilder$default$4();
        scala.collection.immutable.Seq<Class<?>> seq3 = this.copyBuilder$default$5();
        Set<BinderOption> set = this.copyBuilder$default$6();
        boolean bl = this.copyBuilder$default$7();
        return this.copyBuilder(environment, configuration, (scala.collection.immutable.Seq<GuiceableModule>)seq, seq2, seq3, set, bl);
    }

    public final Self overrides(scala.collection.immutable.Seq<GuiceableModule> overrideModules) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.overrides.$plus$plus(overrideModules);
        Environment environment = this.copyBuilder$default$1();
        Configuration configuration = this.copyBuilder$default$2();
        scala.collection.immutable.Seq<GuiceableModule> seq2 = this.copyBuilder$default$3();
        scala.collection.immutable.Seq<Class<?>> seq3 = this.copyBuilder$default$5();
        Set<BinderOption> set = this.copyBuilder$default$6();
        boolean bl = this.copyBuilder$default$7();
        return this.copyBuilder(environment, configuration, seq2, (scala.collection.immutable.Seq<GuiceableModule>)seq, seq3, set, bl);
    }

    public final Self disable(scala.collection.immutable.Seq<Class<?>> moduleClasses) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.disabled.$plus$plus(moduleClasses);
        Environment environment = this.copyBuilder$default$1();
        Configuration configuration = this.copyBuilder$default$2();
        scala.collection.immutable.Seq<GuiceableModule> seq2 = this.copyBuilder$default$3();
        scala.collection.immutable.Seq<GuiceableModule> seq3 = this.copyBuilder$default$4();
        Set<BinderOption> set = this.copyBuilder$default$6();
        boolean bl = this.copyBuilder$default$7();
        return this.copyBuilder(environment, configuration, seq2, seq3, seq, set, bl);
    }

    public final <T> Self disable(ClassTag<T> tag) {
        return this.disable((scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{tag.runtimeClass()}));
    }

    public Module applicationModule() {
        return this.createModule();
    }

    public Module createModule() {
        Module injectorModule = GuiceableModule$.MODULE$.guice((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Binding[]{package$.MODULE$.bind(ClassTag$.MODULE$.apply(GuiceInjector.class)).toSelf(), package$.MODULE$.bind(ClassTag$.MODULE$.apply(GuiceClassLoader.class)).to(this::$anonfun$1), package$.MODULE$.bind(ClassTag$.MODULE$.apply(Injector.class)).toProvider(ClassTag$.MODULE$.apply(GuiceInjectorWithClassLoaderProvider.class)), package$.MODULE$.bind(ClassTag$.MODULE$.apply(play.inject.Injector.class)).to(ClassTag$.MODULE$.apply(DelegateInjector.class))})), (Set)this.binderOptions);
        scala.collection.immutable.Seq enabledModules = (scala.collection.immutable.Seq)this.modules.map((Function1 & Serializable)_$1 -> _$1.disable(this.disabled));
        scala.collection.immutable.Seq bindingModules = (scala.collection.immutable.Seq)GuiceableModule$.MODULE$.guiced(this.environment, this.configuration, this.binderOptions, (scala.collection.immutable.Seq<GuiceableModule>)enabledModules).$colon$plus((Object)injectorModule);
        scala.collection.immutable.Seq<Module> overrideModules = GuiceableModule$.MODULE$.guiced(this.environment, this.configuration, this.binderOptions, this.overrides);
        return Modules.override((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindingModules).asJava()).with((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava(overrideModules).asJava());
    }

    public Injector injector() {
        Injector injector;
        try {
            Mode mode = this.environment.mode();
            Stage stage = Mode.Prod$.MODULE$.equals(mode) ? Stage.PRODUCTION : (this.eagerly ? Stage.PRODUCTION : Stage.DEVELOPMENT);
            com.google.inject.Injector guiceInjector = Guice.createInjector((Stage)stage, (Module[])new Module[]{this.applicationModule()});
            injector = (Injector)guiceInjector.getInstance(Injector.class);
        }
        catch (CreationException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PlayException) {
                PlayException p = (PlayException)throwable;
                throw p;
            }
            CollectionConverters$.MODULE$.CollectionHasAsScala(e.getErrorMessages()).asScala().foreach((Function1)(JProcedure1 & Serializable)_$2 -> {
                Throwable throwable = _$2.getCause();
                if (throwable instanceof PlayException) {
                    PlayException p = (PlayException)throwable;
                    throw p;
                }
            });
            throw e;
        }
        return injector;
    }

    private Self copyBuilder(Environment environment, Configuration configuration, scala.collection.immutable.Seq<GuiceableModule> modules, scala.collection.immutable.Seq<GuiceableModule> overrides, scala.collection.immutable.Seq<Class<?>> disabled, Set<BinderOption> binderOptions, boolean eagerly) {
        return this.newBuilder(environment, configuration, modules, overrides, disabled, binderOptions, eagerly);
    }

    private Environment copyBuilder$default$1() {
        return this.environment;
    }

    private Configuration copyBuilder$default$2() {
        return this.configuration;
    }

    private scala.collection.immutable.Seq<GuiceableModule> copyBuilder$default$3() {
        return this.modules;
    }

    private scala.collection.immutable.Seq<GuiceableModule> copyBuilder$default$4() {
        return this.overrides;
    }

    private scala.collection.immutable.Seq<Class<?>> copyBuilder$default$5() {
        return this.disabled;
    }

    private Set<BinderOption> copyBuilder$default$6() {
        return this.binderOptions;
    }

    private boolean copyBuilder$default$7() {
        return this.eagerly;
    }

    public abstract Self newBuilder(Environment var1, Configuration var2, scala.collection.immutable.Seq<GuiceableModule> var3, scala.collection.immutable.Seq<GuiceableModule> var4, scala.collection.immutable.Seq<Class<?>> var5, Set<BinderOption> var6, boolean var7);

    private final GuiceClassLoader $anonfun$1() {
        return new GuiceClassLoader(this.environment.classLoader());
    }
}

