/*
 * Decompiled with CFR 0.152.
 */
package play.grpc.testkit;

import javax.net.ssl.SSLContext;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.grpc.GrpcClientSettings;
import play.api.test.RunningServer;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoints;
import scala.collection.Iterable;

public final class JavaPekkoGrpcClientHelpers {
    private JavaPekkoGrpcClientHelpers() {
    }

    public static GrpcClientSettings grpcClientSettings(RunningServer runningServer) {
        ServerEndpoint serverEndpoint = JavaPekkoGrpcClientHelpers.getHttp2Endpoint(runningServer.endpoints());
        return JavaPekkoGrpcClientHelpers.grpcClientSettings(serverEndpoint, runningServer.app().actorSystem());
    }

    public static ServerEndpoint getHttp2Endpoint(ServerEndpoints serverEndpoints) {
        Iterable iterable = ((Iterable)serverEndpoints.endpoints().filter(serverEndpoint -> serverEndpoint.protocols().contains((Object)"HTTP/2.0"))).toIterable();
        if (iterable.isEmpty()) {
            throw new IllegalArgumentException(String.format("gRPC client can't automatically find HTTP/2 connection: no valid endpoints available. %s", serverEndpoints));
        }
        if (iterable.size() == 1) {
            return (ServerEndpoint)iterable.head();
        }
        Iterable iterable2 = ((Iterable)iterable.filter(serverEndpoint -> serverEndpoint.ssl().isDefined())).toIterable();
        return (ServerEndpoint)iterable2.head();
    }

    public static GrpcClientSettings grpcClientSettings(ServerEndpoint serverEndpoint, ActorSystem actorSystem) {
        SSLContext sSLContext = (SSLContext)serverEndpoint.ssl().getOrElse(() -> {
            throw new IllegalArgumentException("GrpcClientSettings requires a server endpoint with ssl, but none provided");
        });
        return JavaPekkoGrpcClientHelpers.grpcClientSettings(serverEndpoint, sSLContext, actorSystem);
    }

    public static GrpcClientSettings grpcClientSettings(ServerEndpoint serverEndpoint, SSLContext sSLContext, ActorSystem actorSystem) {
        return GrpcClientSettings.connectToServiceAt((String)serverEndpoint.host(), (int)serverEndpoint.port(), (ClassicActorSystemProvider)actorSystem).withSslContext(sSLContext);
    }
}

