/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import play.api.Environment$;
import play.api.Mode;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class Environment
implements Product,
Serializable {
    private final File rootPath;
    private final ClassLoader classLoader;
    private final Mode mode;

    public static Environment apply(File file, ClassLoader classLoader, Mode mode) {
        return Environment$.MODULE$.apply(file, classLoader, mode);
    }

    public static Environment fromProduct(Product product) {
        return Environment$.MODULE$.fromProduct(product);
    }

    public static Environment simple(File file, Mode mode) {
        return Environment$.MODULE$.simple(file, mode);
    }

    public static Environment unapply(Environment environment) {
        return Environment$.MODULE$.unapply(environment);
    }

    public static File simple$default$1() {
        return Environment$.MODULE$.simple$default$1();
    }

    public static Mode simple$default$2() {
        return Environment$.MODULE$.simple$default$2();
    }

    public Environment(File rootPath, ClassLoader classLoader, Mode mode) {
        this.rootPath = rootPath;
        this.classLoader = classLoader;
        this.mode = mode;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1599817226, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Environment)) return false;
        Environment environment = (Environment)object;
        File file = this.rootPath();
        File file2 = environment.rootPath();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        ClassLoader classLoader = this.classLoader();
        ClassLoader classLoader2 = environment.classLoader();
        if (classLoader == null) {
            if (classLoader2 != null) {
                return false;
            }
        } else if (!classLoader.equals(classLoader2)) return false;
        Mode mode = this.mode();
        Mode mode2 = environment.mode();
        if (mode == null) {
            if (mode2 != null) {
                return false;
            }
        } else if (!mode.equals(mode2)) return false;
        if (!environment.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Environment;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Environment";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "rootPath";
            }
            case 1: {
                return "classLoader";
            }
            case 2: {
                return "mode";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public File rootPath() {
        return this.rootPath;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public Mode mode() {
        return this.mode;
    }

    public File getFile(String relativePath) {
        return new File(this.rootPath(), relativePath);
    }

    public Option<File> getExistingFile(String relativePath) {
        return Some$.MODULE$.apply((Object)this.getFile(relativePath)).filter((Function1 & Serializable)_$1 -> _$1.exists());
    }

    public Option<URL> resource(String name) {
        String n = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(name), "/");
        return Option$.MODULE$.apply((Object)this.classLoader().getResource(n));
    }

    public Option<InputStream> resourceAsStream(String name) {
        String n = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(name), "/");
        return Option$.MODULE$.apply((Object)this.classLoader().getResourceAsStream(n));
    }

    public play.Environment asJava() {
        return new play.Environment(this);
    }

    public Environment copy(File rootPath, ClassLoader classLoader, Mode mode) {
        return new Environment(rootPath, classLoader, mode);
    }

    public File copy$default$1() {
        return this.rootPath();
    }

    public ClassLoader copy$default$2() {
        return this.classLoader();
    }

    public Mode copy$default$3() {
        return this.mode();
    }

    public File _1() {
        return this.rootPath();
    }

    public ClassLoader _2() {
        return this.classLoader();
    }

    public Mode _3() {
        return this.mode();
    }
}

