/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.Mode$Test$;
import play.api.PlayException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.io.Codec;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class Configuration$
implements Mirror.Product,
Serializable {
    private static final Logger logger;
    public static final Configuration$ MODULE$;

    private Configuration$() {
    }

    static {
        MODULE$ = new Configuration$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Configuration$.class);
    }

    public Configuration apply(Config underlying) {
        return new Configuration(underlying);
    }

    public Configuration unapply(Configuration x$1) {
        return x$1;
    }

    public Configuration load(ClassLoader classLoader, Properties properties, scala.collection.immutable.Map<String, Object> directSettings, boolean allowMissingApplicationConf) {
        Configuration configuration;
        try {
            Config userDefinedProperties = properties == System.getProperties() ? ConfigFactory.empty() : ConfigFactory.parseProperties((Properties)properties);
            Config directConfig = ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(directSettings).asJava());
            Config applicationConfig = (Config)this.setting$1(properties, directSettings, "config.resource").map((Function1 & Serializable)resource -> ConfigFactory.parseResources((ClassLoader)classLoader, (String)resource)).orElse(() -> this.$anonfun$2(properties, directSettings)).getOrElse(() -> this.$anonfun$3(classLoader, allowMissingApplicationConf));
            Config playOverridesConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"play/reference-overrides.conf");
            Config combinedConfig = (Config)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{userDefinedProperties, directConfig, applicationConfig, playOverridesConfig})).reduceLeft((Function2 & Serializable)(_$2, _$3) -> _$2.withFallback((ConfigMergeable)_$3));
            Config resolvedConfig = ConfigFactory.load((ClassLoader)classLoader, (Config)combinedConfig);
            configuration = this.apply(resolvedConfig);
        }
        catch (ConfigException e) {
            throw this.configError(e.getMessage(), (Option<ConfigOrigin>)Option$.MODULE$.apply((Object)e.origin()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), Codec$.MODULE$.fallbackSystemCodec());
        }
        return configuration;
    }

    public Configuration load(Environment environment, scala.collection.immutable.Map<String, Object> devSettings) {
        Mode mode = environment.mode();
        Mode$Test$ mode$Test$ = Mode$Test$.MODULE$;
        boolean allowMissingApplicationConf = !(mode != null ? !mode.equals(mode$Test$) : mode$Test$ != null);
        return this.load(environment.classLoader(), System.getProperties(), devSettings, allowMissingApplicationConf);
    }

    public Configuration load(Environment environment) {
        return this.load(environment, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public Configuration empty() {
        return this.apply(ConfigFactory.empty());
    }

    public Configuration reference() {
        return this.apply(ConfigFactory.defaultReference());
    }

    public Configuration from(scala.collection.immutable.Map<String, Object> data) {
        return this.apply(ConfigFactory.parseMap((java.util.Map)((java.util.Map)this.toJava$1(data))));
    }

    public Configuration apply(Seq<Tuple2<String, Object>> data) {
        return this.from((scala.collection.immutable.Map<String, Object>)data.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public PlayException configError(String message, Option<ConfigOrigin> origin, Option<Throwable> e, Codec codec) {
        return (PlayException)origin.map((Function1 & Serializable)o -> {
            Integer originLine = Predef$.MODULE$.int2Integer(o.lineNumber());
            String originSourceName = o.filename();
            Option originUrlOpt = Option$.MODULE$.apply((Object)o.url());
            return new PlayException.ExceptionSource(message, e, codec, originLine, originSourceName, originUrlOpt){
                private final Codec codec$3;
                private final Integer originLine$2;
                private final String originSourceName$2;
                private final Option originUrlOpt$2;
                {
                    this.codec$3 = codec$2;
                    this.originLine$2 = originLine$1;
                    this.originSourceName$2 = originSourceName$1;
                    this.originUrlOpt$2 = originUrlOpt$1;
                    super("Configuration error", message$2, (Throwable)e$2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }

                public Integer line() {
                    return this.originLine$2;
                }

                public Null$ position() {
                    return null;
                }

                public String input() {
                    return (String)this.originUrlOpt$2.map((Function1 & Serializable)url -> new String(Configuration$.MODULE$.play$api$Configuration$$$readStream(url.openStream()), this.codec$3.name())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                }

                public String sourceName() {
                    return this.originSourceName$2;
                }

                public String toString() {
                    return "Configuration error: " + this.getMessage();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{input$$anonfun$1(java.net.URL )}, serializedLambda);
                }
            };
        }).getOrElse(() -> this.configError$$anonfun$2(message, e));
    }

    public Option<ConfigOrigin> configError$default$2() {
        return None$.MODULE$;
    }

    public Option<Throwable> configError$default$3() {
        return None$.MODULE$;
    }

    public byte[] play$api$Configuration$$$readStream(InputStream stream) {
        byte[] byArray;
        try {
            byte[] buffer = new byte[8192];
            int len = stream.read(buffer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (len != -1) {
                out.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.logger().warn("Error closing stream", (Throwable)e);
            }
            throw throwable;
        }
        byte[] byArray2 = byArray;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            this.logger().warn("Error closing stream", (Throwable)e);
        }
        return byArray2;
    }

    public Logger logger() {
        return logger;
    }

    public Configuration fromProduct(Product x$0) {
        return new Configuration((Config)x$0.productElement(0));
    }

    private final Option setting$1$$anonfun$1(Properties properties$2, String key$1) {
        return Option$.MODULE$.apply((Object)properties$2.getProperty(key$1));
    }

    private final Option setting$1(Properties properties$1, scala.collection.immutable.Map directSettings$1, String key) {
        return directSettings$1.get((Object)key).orElse(() -> this.setting$1$$anonfun$1(properties$1, key)).map((Function1 & Serializable)_$1 -> _$1.toString());
    }

    private final Option $anonfun$2(Properties properties$3, scala.collection.immutable.Map directSettings$2) {
        return this.setting$1(properties$3, directSettings$2, "config.file").map((Function1 & Serializable)fileName -> ConfigFactory.parseFileAnySyntax((File)new File((String)fileName)));
    }

    private final Config $anonfun$3(ClassLoader classLoader$2, boolean allowMissingApplicationConf$1) {
        ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setClassLoader(classLoader$2).setAllowMissing(allowMissingApplicationConf$1);
        return ConfigFactory.defaultApplication((ConfigParseOptions)parseOptions);
    }

    private final Object toJava$1(Object data2) {
        Object object = data2;
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)map.view().mapValues((Function1 & Serializable)data -> this.toJava$1(data)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)iterable.map((Function1 & Serializable)data -> this.toJava$1(data))).asJava();
        }
        Object v = object;
        return v;
    }

    private final PlayException configError$$anonfun$2(String message$3, Option e$3) {
        return new PlayException("Configuration error", message$3, (Throwable)e$3.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

