/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.primitives.Primitives;
import jakarta.inject.Inject;
import java.io.Serializable;
import play.api.cache.SyncCacheApi;
import play.api.cache.caffeine.ExpirableCacheValue;
import play.api.cache.caffeine.ExpirableCacheValue$;
import play.cache.caffeine.NamedCaffeineCache;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;

public class SyncCaffeineCacheApi
implements SyncCacheApi {
    private final NamedCaffeineCache cache;
    private final Cache<Object, Object> syncCache;

    @Inject
    public SyncCaffeineCacheApi(NamedCaffeineCache<Object, Object> cache) {
        this.cache = cache;
        this.syncCache = cache.synchronous();
    }

    public NamedCaffeineCache<Object, Object> cache() {
        return this.cache;
    }

    public void set(String key, Object value, Duration expiration) {
        this.syncCache.put((Object)key, ExpirableCacheValue$.MODULE$.apply(value, (Option<Duration>)Some$.MODULE$.apply((Object)expiration)));
    }

    public void remove(String key) {
        this.syncCache.invalidate((Object)key);
    }

    public <A> A getOrElseUpdate(String key, Duration expiration, Function0<A> orElse, ClassTag<A> evidence$1) {
        return (A)((ExpirableCacheValue)this.syncCache.get((Object)key, _$10 -> ExpirableCacheValue$.MODULE$.apply(orElse.apply(), (Option<Duration>)Some$.MODULE$.apply((Object)expiration)))).value();
    }

    public <T> Option<T> get(String key, ClassTag<T> ct) {
        return Option$.MODULE$.apply((Object)((ExpirableCacheValue)this.syncCache.getIfPresent((Object)key))).filter((Function1 & Serializable)v -> {
            if (Primitives.wrap((Class)ct.runtimeClass()).isInstance(v.value())) return true;
            ClassTag classTag = ct;
            ClassTag classTag2 = ClassTag$.MODULE$.Nothing();
            if (classTag == null) {
                if (classTag2 == null) return true;
            } else if (classTag.equals(classTag2)) return true;
            ClassTag classTag3 = ct;
            ManifestFactory.UnitManifest unitManifest = ClassTag$.MODULE$.Unit();
            if (classTag3 == null) {
                if (unitManifest != null) {
                    return false;
                }
            } else if (!classTag3.equals(unitManifest)) return false;
            Object v2 = v.value();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (v2 == null) {
                if (boxedUnit == null) return true;
                return false;
            } else {
                if (!v2.equals(boxedUnit)) return false;
                return true;
            }
        }).map((Function1 & Serializable)_$11 -> _$11.value());
    }
}

