/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pekko.actor.ActorSystem;
import play.api.cache.caffeine.DefaultCaffeineExpiry;
import play.cache.caffeine.CaffeineParser;
import play.cache.caffeine.NamedCaffeineCache;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\b\u0001\u0003\u0006\u0004%IA\b\u0005\tQ\u0001\u0011\t\u0011)A\u0005?!A\u0011\u0006\u0001BC\u0002\u0013%!\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Ba\u0001\u0019\u0001!\u0002\u0013\u0001\u0005\"B6\u0001\t\u0003a\u0007\"B<\u0001\t\u0003A\b\"B?\u0001\t\u0003q\b\u0002CA\u0002\u0001\u0011\u0005Q\"!\u0002\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0015\tqq\"\u0001\u0005dC\u001a4W-\u001b8f\u0015\t\u0001\u0012#A\u0003dC\u000eDWM\u0003\u0002\u0013'\u0005\u0019\u0011\r]5\u000b\u0003Q\tA\u0001\u001d7bs\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u000611m\u001c8gS\u001e,\u0012a\b\t\u0003A\u0019j\u0011!\t\u0006\u0003;\tR!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014\"\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aC1di>\u00148+_:uK6,\u0012a\u000b\t\u0003YUj\u0011!\f\u0006\u0003]=\nQ!Y2u_JT!\u0001M\u0019\u0002\u000bA,7n[8\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0005\u0003m5\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006a\u0011m\u0019;peNK8\u000f^3nA\u00051A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u000e\u0011\u0015iR\u00011\u0001 \u0011\u0015IS\u00011\u0001,\u0003!\u0019\u0017m\u00195f\u001b\u0006\u0004X#\u0001!\u0011\t\u0005C%*V\u0007\u0002\u0005*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#G\u0003\u0011)H/\u001b7\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011J\u0011\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\u0005-\u0013fB\u0001'Q!\ti\u0015$D\u0001O\u0015\tyU#\u0001\u0004=e>|GOP\u0005\u0003#f\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011+\u0007\u0019\u0004-zK\u0007\u0003B,[9\"l\u0011\u0001\u0017\u0006\u0003\u001deS!\u0001E\n\n\u0005mC&A\u0005(b[\u0016$7)\u00194gK&tWmQ1dQ\u0016\u0004\"!\u00180\r\u0001\u0011IqlBA\u0001\u0002\u0003\u0015\t!\u0019\u0002\u0004?\u0012\n\u0014!C2bG\",W*\u00199!#\t\u0011W\r\u0005\u0002\u0019G&\u0011A-\u0007\u0002\b\u001d>$\b.\u001b8h!\tAb-\u0003\u0002h3\t\u0019\u0011I\\=\u0011\u0005uKG!\u00036\b\u0003\u0003\u0005\tQ!\u0001b\u0005\ryFEM\u0001\tO\u0016$8)Y2iKV\u0019Q\u000e]:\u0015\u00059,\b\u0003B,[_J\u0004\"!\u00189\u0005\u000bED!\u0019A1\u0003\u0003-\u0003\"!X:\u0005\u000bQD!\u0019A1\u0003\u0003YCQA\u001e\u0005A\u0002)\u000b\u0011bY1dQ\u0016t\u0015-\\3\u0002\u001b\u001d,GoQ1dQ\u0016t\u0015-\\3t)\u0005I\bc\u0001>|\u00156\tA)\u0003\u0002}\t\n\u00191+\u001a;\u0002\u0015\r\f7\r[3OC6,7/F\u0001\u0000!\u0011Y\u0015\u0011\u0001&\n\u0005q$\u0016aD4fi\u000e\u000b7\r[3Ck&dG-\u001a:\u0015\t\u0005\u001d\u0011\u0011\u0006\u0019\u0007\u0003\u0013\ty\"!\n\u0011\u0011\u0005-\u0011\u0011DA\u000f\u0003Gi!!!\u0004\u000b\u0007A\tyAC\u0002\u000f\u0003#QA!a\u0005\u0002\u0016\u0005A!-\u001a8nC:,7OC\u0002\u0002\u0018\u0011\naaZ5uQV\u0014\u0017\u0002BA\u000e\u0003\u001b\u0011\u0001bQ1gM\u0016Lg.\u001a\t\u0004;\u0006}AACA\u0011\u0017\u0005\u0005\t\u0011!B\u0001C\n\u0019q\fJ\u001b\u0011\u0007u\u000b)\u0003\u0002\u0006\u0002(-\t\t\u0011!A\u0003\u0002\u0005\u00141a\u0018\u00137\u0011\u001518\u00021\u0001K\u0001")
public class CaffeineCacheManager {
    private final Config config;
    private final ActorSystem actorSystem;
    private final ConcurrentMap<String, NamedCaffeineCache<?, ?>> cacheMap;

    private Config config() {
        return this.config;
    }

    private ActorSystem actorSystem() {
        return this.actorSystem;
    }

    private ConcurrentMap<String, NamedCaffeineCache<?, ?>> cacheMap() {
        return this.cacheMap;
    }

    public <K, V> NamedCaffeineCache<K, V> getCache(String cacheName2) {
        return this.cacheMap().computeIfAbsent(cacheName2, cacheName -> {
            Caffeine<?, ?> cacheBuilder = this.getCacheBuilder((String)cacheName);
            NamedCaffeineCache namedCache = new NamedCaffeineCache((String)cacheName, cacheBuilder.buildAsync());
            return namedCache;
        });
    }

    public Set<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap().keySet());
    }

    public scala.collection.immutable.Set<String> cacheNames() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.cacheMap().keySet()).asScala().toSet();
    }

    public Caffeine<?, ?> getCacheBuilder(String cacheName) {
        DefaultCaffeineExpiry defaultExpiry = new DefaultCaffeineExpiry();
        Config caches = this.config().getConfig("caches");
        Config defaults = this.config().getConfig("defaults");
        Config cacheConfig = caches.hasPath(cacheName) ? caches.getConfig(cacheName).withFallback((ConfigMergeable)defaults) : defaults;
        return CaffeineParser.from(cacheConfig, this.actorSystem()).expireAfter((Expiry)defaultExpiry);
    }

    public CaffeineCacheManager(Config config, ActorSystem actorSystem) {
        this.config = config;
        this.actorSystem = actorSystem;
        this.cacheMap = new ConcurrentHashMap(16);
    }
}

