/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache;

import java.io.Serializable;
import java.time.Instant;
import org.apache.pekko.Done;
import org.apache.pekko.stream.Materializer;
import play.api.cache.AsyncCacheApi;
import play.api.cache.SerializableResult;
import play.api.http.HeaderNames$;
import play.api.libs.Codecs$;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialAction$;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.Execution;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CachedBuilder {
    private final AsyncCacheApi cache;
    private final Function1<RequestHeader, String> key;
    private final PartialFunction<ResponseHeader, Duration> caching;
    private final Materializer materializer;
    private final PartialFunction<ResponseHeader, Duration> cachingWithEternity;

    public CachedBuilder(AsyncCacheApi cache, Function1<RequestHeader, String> key, PartialFunction<ResponseHeader, Duration> caching, Materializer materializer) {
        this.cache = cache;
        this.key = key;
        this.caching = caching;
        this.materializer = materializer;
        this.cachingWithEternity = caching.andThen((Function1 & Serializable)duration -> {
            boolean zeroDuration = duration.neg().equals(duration);
            if (zeroDuration) {
                return Duration$.MODULE$.apply(31536000L, package$.MODULE$.SECONDS());
            }
            return duration;
        });
    }

    public EssentialAction apply(EssentialAction action) {
        return this.build(action);
    }

    public EssentialAction build(EssentialAction action) {
        return EssentialAction$.MODULE$.apply((Function1 & Serializable)request -> {
            String resultKey = (String)this.key.apply(request);
            String etagKey = resultKey + "-etag";
            return Accumulator$.MODULE$.flatten(Future$.MODULE$.successful((Object)request.headers().get(HeaderNames$.MODULE$.IF_NONE_MATCH())).flatMap((Function1 & Serializable)x$12 -> {
                Option option = x$12;
                if (option instanceof Some) {
                    String requestEtag = (String)((Some)option).value();
                    return this.cache.get(etagKey, ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            String etag = (String)((Some)option).value();
                            String string = requestEtag;
                            String string2 = "*";
                            if (!(string == null ? string2 != null : !string.equals(string2)) || CachedBuilder.parseEtag$1(requestEtag).contains((Object)etag)) {
                                return Some$.MODULE$.apply((Object)Accumulator$.MODULE$.done((Object)Results$.MODULE$.NotModified()));
                            }
                        }
                        return None$.MODULE$;
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                }
                if (None$.MODULE$.equals(option)) {
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).flatMap((Function1 & Serializable)x$12 -> {
                Option option = x$12;
                if (option instanceof Some) {
                    Accumulator result2 = (Accumulator)((Some)option).value();
                    return Future$.MODULE$.successful((Object)result2);
                }
                if (None$.MODULE$.equals(option)) {
                    return this.cache.get(resultKey, ClassTag$.MODULE$.apply(SerializableResult.class)).map((Function1 & Serializable)result -> result.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(SerializableResult x) {
                            SerializableResult serializableResult = x;
                            if (serializableResult != null) {
                                SerializableResult sr = serializableResult;
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(SerializableResult x, Function1 function1) {
                            SerializableResult serializableResult = x;
                            if (serializableResult != null) {
                                SerializableResult sr = serializableResult;
                                return Accumulator$.MODULE$.done((Object)sr.result());
                            }
                            return function1.apply((Object)x);
                        }
                    }), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).map((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            Accumulator cachedResource = (Accumulator)((Some)option).value();
                            return cachedResource;
                        }
                        if (None$.MODULE$.equals(option)) {
                            Accumulator accumulatorResult = (Accumulator)action.apply(request);
                            return accumulatorResult.mapFuture((Function1 & Serializable)_$2 -> this.handleResult((Result)_$2, etagKey, resultKey), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                        }
                        throw new MatchError((Object)option);
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()), this.materializer);
        });
    }

    private Future<Result> handleResult(Result result, String etagKey, String resultKey) {
        return (Future)this.cachingWithEternity.andThen((Function1 & Serializable)duration -> {
            String expirationDate = play.api.http.package$.MODULE$.dateFormat().format(Instant.ofEpochMilli(System.currentTimeMillis() + duration.toMillis()));
            String etag = "\"" + Codecs$.MODULE$.sha1(expirationDate) + "\"";
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ETAG());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)etag);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.EXPIRES());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)expirationDate);
            Result resultWithHeaders = result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return this.cache.set(etagKey, etag, (Duration)duration).flatMap((Function1 & Serializable)x$12 -> {
                Done done = x$12;
                return this.cache.set(resultKey, new SerializableResult(resultWithHeaders), (Duration)duration).map((Function1 & Serializable)x$1 -> {
                    Done done = x$1;
                    return resultWithHeaders;
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }).applyOrElse((Object)result.header(), (Function1 & Serializable)_$3 -> Future$.MODULE$.successful((Object)result));
    }

    public CachedBuilder includeStatus(int status) {
        return this.includeStatus(status, (Duration)Duration$.MODULE$.Zero());
    }

    public CachedBuilder includeStatus(int status, int duration) {
        return this.includeStatus(status, (Duration)Duration$.MODULE$.apply(Int$.MODULE$.int2long(duration), package$.MODULE$.SECONDS()));
    }

    public CachedBuilder includeStatus(int status, Duration duration) {
        return this.compose((PartialFunction<ResponseHeader, Duration>)new Serializable(status, duration){
            private final int status$1;
            private final Duration duration$4;
            {
                this.status$1 = status$2;
                this.duration$4 = duration$8;
            }

            public final boolean isDefinedAt(ResponseHeader x) {
                ResponseHeader responseHeader = x;
                ResponseHeader e = responseHeader;
                return e.status() == this.status$1;
            }

            public final Object applyOrElse(ResponseHeader x, Function1 function1) {
                ResponseHeader responseHeader = x;
                ResponseHeader e = responseHeader;
                if (e.status() == this.status$1) {
                    return this.duration$4;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public CachedBuilder default(Duration duration) {
        return this.compose((PartialFunction<ResponseHeader, Duration>)new Serializable(duration){
            private final Duration duration$5;
            {
                this.duration$5 = duration$9;
            }

            public final boolean isDefinedAt(ResponseHeader x) {
                ResponseHeader responseHeader = x;
                return responseHeader != null;
            }

            public final Object applyOrElse(ResponseHeader x, Function1 function1) {
                ResponseHeader responseHeader = x;
                if (responseHeader != null) {
                    return this.duration$5;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public CachedBuilder default(int duration) {
        return this.default((Duration)Duration$.MODULE$.apply(Int$.MODULE$.int2long(duration), package$.MODULE$.SECONDS()));
    }

    public CachedBuilder compose(PartialFunction<ResponseHeader, Duration> alternative) {
        return new CachedBuilder(this.cache, this.key, (PartialFunction<ResponseHeader, Duration>)this.caching.orElse(alternative), this.materializer);
    }

    private static final List parseEtag$1(String etag) {
        Regex Etag = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:W/)?(\"[^\"]*\")"));
        return Etag.findAllMatchIn((CharSequence)etag).map((Function1 & Serializable)m -> m.group(1)).toList();
    }
}

