/*
 * Decompiled with CFR 0.152.
 */
package play.cache;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import play.cache.SyncCacheApi;
import play.libs.Scala;
import scala.concurrent.duration.Duration;
import scala.jdk.javaapi.OptionConverters;

public class SyncCacheApiAdapter
implements SyncCacheApi {
    private final play.api.cache.SyncCacheApi scalaApi;

    public SyncCacheApiAdapter(play.api.cache.SyncCacheApi syncCacheApi) {
        this.scalaApi = syncCacheApi;
    }

    @Override
    public <T> Optional<T> get(String string) {
        return OptionConverters.toJava(this.scalaApi.get(string, Scala.classTag()));
    }

    @Override
    public <T> T getOrElseUpdate(String string, Callable<T> callable, int n) {
        return (T)this.scalaApi.getOrElseUpdate(string, this.intToDuration(n), Scala.asScala(callable), Scala.classTag());
    }

    @Override
    public <T> T getOrElseUpdate(String string, Callable<T> callable) {
        return (T)this.scalaApi.getOrElseUpdate(string, (Duration)Duration.Inf(), Scala.asScala(callable), Scala.classTag());
    }

    @Override
    public void set(String string, Object object, int n) {
        this.scalaApi.set(string, object, this.intToDuration(n));
    }

    @Override
    public void set(String string, Object object) {
        this.scalaApi.set(string, object, (Duration)Duration.Inf());
    }

    @Override
    public void remove(String string) {
        this.scalaApi.remove(string);
    }

    private Duration intToDuration(int n) {
        return n == 0 ? Duration.Inf() : Duration.apply((long)n, (TimeUnit)TimeUnit.SECONDS);
    }
}

