/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.http.Port;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSRequest;
import play.api.libs.ws.ahc.AhcWSClient;
import play.api.libs.ws.ahc.AhcWSClient$;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig$;
import play.api.mvc.Call;
import play.api.test.WsTestClient$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public interface WsTestClient {
    public static void $init$(WsTestClient $this) {
        $this.play$api$test$WsTestClient$_setter_$play$api$test$WsTestClient$$clientProducer_$eq((Function2 & Serializable)(port, scheme) -> WsTestClient.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)port), (String)scheme));
    }

    public Function2<Object, String, WSClient> play$api$test$WsTestClient$$clientProducer();

    public void play$api$test$WsTestClient$_setter_$play$api$test$WsTestClient$$clientProducer_$eq(Function2 var1);

    public static WSRequest wsCall$(WsTestClient $this, Call call, int port, Function2 client, String scheme) {
        return $this.wsCall(call, port, (Function2<Object, String, WSClient>)client, scheme);
    }

    default public WSRequest wsCall(Call call, int port, Function2<Object, String, WSClient> client, String scheme) {
        return this.wsUrl(call.url(), port, client, scheme);
    }

    public static Function2 wsCall$default$3$(WsTestClient $this, Call call) {
        return $this.wsCall$default$3(call);
    }

    default public Function2<Object, String, WSClient> wsCall$default$3(Call call) {
        return this.play$api$test$WsTestClient$$clientProducer();
    }

    public static String wsCall$default$4$(WsTestClient $this, Call call) {
        return $this.wsCall$default$4(call);
    }

    default public String wsCall$default$4(Call call) {
        return "http";
    }

    public static WSRequest wsUrl$(WsTestClient $this, String url, int port, Function2 client, String scheme) {
        return $this.wsUrl(url, port, (Function2<Object, String, WSClient>)client, scheme);
    }

    default public WSRequest wsUrl(String url, int port, Function2<Object, String, WSClient> client, String scheme) {
        return ((WSClient)client.apply((Object)BoxesRunTime.boxToInteger((int)port), (Object)scheme)).url(scheme + "://localhost:" + port + url);
    }

    public static Function2 wsUrl$default$3$(WsTestClient $this, String url) {
        return $this.wsUrl$default$3(url);
    }

    default public Function2<Object, String, WSClient> wsUrl$default$3(String url) {
        return this.play$api$test$WsTestClient$$clientProducer();
    }

    public static String wsUrl$default$4$(WsTestClient $this, String url) {
        return $this.wsUrl$default$4(url);
    }

    default public String wsUrl$default$4(String url) {
        return "http";
    }

    public static Object withClient$(WsTestClient $this, Function1 block, int port, String scheme) {
        return $this.withClient(block, port, scheme);
    }

    default public <T> T withClient(Function1<WSClient, T> block, int port, String scheme) {
        Object object;
        try (WSClient client = (WSClient)this.play$api$test$WsTestClient$$clientProducer().apply((Object)BoxesRunTime.boxToInteger((int)port), (Object)scheme);){
            object = block.apply((Object)client);
        }
        return (T)object;
    }

    public static int withClient$default$2$(WsTestClient $this, Function1 block) {
        return $this.withClient$default$2(block);
    }

    default public <T> int withClient$default$2(Function1<WSClient, T> block) {
        return -1;
    }

    public static String withClient$default$3$(WsTestClient $this, Function1 block) {
        return $this.withClient$default$3(block);
    }

    default public <T> String withClient$default$3(Function1<WSClient, T> block) {
        return "http";
    }

    private static /* synthetic */ WSClient $init$$$anonfun$1(int port, String scheme) {
        return new InternalWSClient(scheme, port);
    }

    public static class InternalWSClient
    implements WSClient {
        private final String scheme;
        private final int port;

        public InternalWSClient(String scheme, int port) {
            this.scheme = scheme;
            this.port = port;
            WsTestClient$.play$api$test$WsTestClient$$$singletonClient.addReference(this);
        }

        public <T> T underlying() {
            return WsTestClient$.play$api$test$WsTestClient$$$singletonClient.underlying();
        }

        public WSRequest url(String url) {
            if (url.startsWith("/") && this.port != -1) {
                int httpPort = this.port;
                return WsTestClient$.play$api$test$WsTestClient$$$singletonClient.url(this.scheme + "://localhost:" + new Port(httpPort) + url);
            }
            return WsTestClient$.play$api$test$WsTestClient$$$singletonClient.url(url);
        }

        public void close() {
            WsTestClient$.play$api$test$WsTestClient$$$singletonClient.removeReference(this);
        }
    }

    public static class SingletonWSClient
    implements WSClient {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final AtomicReference<WSClient> ref = new AtomicReference();
        private final AtomicInteger count = new AtomicInteger(1);
        private final ConcurrentLinkedQueue<WSClient> references = new ConcurrentLinkedQueue();
        private final FiniteDuration idleDuration = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
        private Option<Cancellable> idleCheckTask = None$.MODULE$;

        public boolean removeReference(InternalWSClient client) {
            return this.references.remove(client);
        }

        public boolean addReference(InternalWSClient client) {
            return this.references.add(client);
        }

        private Future<Terminated> closeIdleResources(WSClient client, ActorSystem system) {
            this.ref.compareAndSet(client, null);
            client.close();
            return system.terminate();
        }

        private WSClient wsClientInstance() {
            WSClient wSClient;
            while ((wSClient = this.ref.get()) == null) {
                Tuple2<WSClient, ActorSystem> tuple2 = this.createNewClient();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                WSClient newInstance = (WSClient)tuple2._1();
                ActorSystem system = (ActorSystem)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newInstance, (Object)system);
                WSClient newInstance2 = (WSClient)tuple22._1();
                ActorSystem system2 = (ActorSystem)tuple22._2();
                if (this.ref.compareAndSet(null, newInstance2)) {
                    this.scheduleIdleCheck(newInstance2, system2);
                    return newInstance2;
                }
                this.closeIdleResources(newInstance2, system2);
            }
            WSClient client = wSClient;
            return client;
        }

        private Tuple2<WSClient, ActorSystem> createNewClient() {
            String name = "ws-test-client-" + this.count.getAndIncrement();
            this.logger.info("createNewClient: name = " + name);
            ActorSystem system = ActorSystem$.MODULE$.apply(name);
            Materializer materializer = Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system);
            AhcWSClientConfig config = AhcWSClientConfig$.MODULE$.apply(AhcWSClientConfig$.MODULE$.$lessinit$greater$default$1(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$2(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$3(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$4(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$5(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$6(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$7(), 0, AhcWSClientConfig$.MODULE$.$lessinit$greater$default$9(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$10(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$11(), AhcWSClientConfig$.MODULE$.$lessinit$greater$default$12());
            AhcWSClient client = AhcWSClient$.MODULE$.apply(config, AhcWSClient$.MODULE$.apply$default$2(), materializer);
            return Tuple2$.MODULE$.apply((Object)client, (Object)system);
        }

        private Object scheduleIdleCheck(WSClient client, ActorSystem system) {
            Scheduler scheduler = system.scheduler();
            Option<Cancellable> option = this.idleCheckTask;
            if (option instanceof Some) {
                Cancellable cancellable = (Cancellable)((Some)option).value();
                this.logger.error("scheduleIdleCheck: looks like a race condition of WsTestClient...");
                return this.closeIdleResources(client, system);
            }
            if (None$.MODULE$.equals(option)) {
                this.idleCheckTask = Option$.MODULE$.apply((Object)scheduler.scheduleAtFixedRate(this.idleDuration, this.idleDuration, () -> {
                    if (this.references.size() == 0) {
                        this.logger.debug("check: no references found on client " + client + ", system " + system);
                        this.idleCheckTask.map(WsTestClient$::play$api$test$WsTestClient$SingletonWSClient$$_$scheduleIdleCheck$$anonfun$1$$anonfun$1);
                        this.idleCheckTask = None$.MODULE$;
                        this.closeIdleResources(client, system);
                        return;
                    }
                    Object object = Predef$.MODULE$.refArrayOps(this.references.toArray());
                    this.logger.debug("check: client references = " + ArrayOps$.MODULE$.toSeq$extension(object));
                }, (ExecutionContext)system.dispatcher()));
                return BoxedUnit.UNIT;
            }
            throw new MatchError(option);
        }

        public <T> T underlying() {
            return (T)this.wsClientInstance().underlying();
        }

        public WSRequest url(String url) {
            return this.wsClientInstance().url(url);
        }

        public void close() {
        }
    }
}

