/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.Configuration;
import play.api.Environment;
import play.api.inject.ApplicationLifecycle;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.WSConfigParser;
import play.api.libs.ws.ahc.AhcConfigBuilder;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfigParser;
import play.api.libs.ws.ahc.OptionalAhcHttpCacheProvider;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.CachingAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@Singleton
public class AsyncHttpClientProvider
implements Provider<AsyncHttpClient> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AsyncHttpClientProvider.class.getDeclaredField("get$lzy1"));
    private final Environment environment;
    private final Configuration configuration;
    private final ApplicationLifecycle applicationLifecycle;
    private final ExecutionContext executionContext;
    private volatile Object get$lzy1;
    private final AsyncHttpClientConfig asyncHttpClientConfig;

    @Inject
    public AsyncHttpClientProvider(Environment environment, Configuration configuration, ApplicationLifecycle applicationLifecycle, ExecutionContext executionContext) {
        this.environment = environment;
        this.configuration = configuration;
        this.applicationLifecycle = applicationLifecycle;
        this.executionContext = executionContext;
        WSClientConfig wsClientConfig = new WSConfigParser(configuration.underlying(), environment.classLoader()).parse();
        AhcWSClientConfig ahcWsClientConfig = new AhcWSClientConfigParser(wsClientConfig, configuration.underlying(), environment.classLoader()).parse();
        this.asyncHttpClientConfig = new AhcConfigBuilder(ahcWsClientConfig).build();
        applicationLifecycle.addStopHook((Function0 & Serializable)() -> {
            this.get().close();
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        });
    }

    public AsyncHttpClient get() {
        Object object = this.get$lzy1;
        if (object instanceof AsyncHttpClient) {
            return (AsyncHttpClient)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AsyncHttpClient)this.get$lzyINIT1();
    }

    private Object get$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.get$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultAsyncHttpClient defaultAsyncHttpClient = null;
                    try {
                        DefaultAsyncHttpClient defaultAsyncHttpClient2;
                        OptionalAhcHttpCacheProvider cacheProvider = new OptionalAhcHttpCacheProvider(this.environment, this.configuration, this.applicationLifecycle, this.executionContext);
                        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(this.asyncHttpClientConfig);
                        Option<AhcHttpCache> option = cacheProvider.get();
                        if (option instanceof Some) {
                            AhcHttpCache ahcHttpCache = (AhcHttpCache)((Some)option).value();
                            defaultAsyncHttpClient2 = new CachingAsyncHttpClient((AsyncHttpClient)client, ahcHttpCache);
                        } else if (None$.MODULE$.equals(option)) {
                            defaultAsyncHttpClient2 = client;
                        } else {
                            throw new MatchError(option);
                        }
                        defaultAsyncHttpClient = defaultAsyncHttpClient2;
                        object2 = defaultAsyncHttpClient == null ? LazyVals.NullValue$.MODULE$ : defaultAsyncHttpClient;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return defaultAsyncHttpClient;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

