/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.stream.Materializer;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.ahc.StandaloneAhcWSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.ahc.AhcWSClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class WSTestClient {
    private static AtomicInteger instanceNumber = new AtomicInteger(1);

    public static play.libs.ws.WSClient newClient(final int n) {
        DefaultAsyncHttpClientConfig defaultAsyncHttpClientConfig = new DefaultAsyncHttpClientConfig.Builder().setMaxRequestRetry(0).setShutdownQuietPeriod(0).setShutdownTimeout(0).build();
        String string = "ws-test-client-" + instanceNumber.getAndIncrement();
        final ActorSystem actorSystem = ActorSystem.create((String)string);
        Materializer materializer = Materializer.matFromSystem((ClassicActorSystemProvider)actorSystem);
        DefaultAsyncHttpClient defaultAsyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)defaultAsyncHttpClientConfig);
        final AhcWSClient ahcWSClient = new AhcWSClient((AsyncHttpClient)defaultAsyncHttpClient, materializer);
        return new play.libs.ws.WSClient(){
            final /* synthetic */ AsyncHttpClient val$asyncHttpClient;
            final /* synthetic */ Materializer val$materializer;
            {
                this.val$asyncHttpClient = asyncHttpClient;
                this.val$materializer = materializer;
            }

            public Object getUnderlying() {
                return ahcWSClient.getUnderlying();
            }

            public WSRequest url(String string) {
                if (string.startsWith("/") && n != -1) {
                    return ahcWSClient.url("http://localhost:" + n + string);
                }
                return ahcWSClient.url(string);
            }

            public void close() throws IOException {
                try {
                    try {
                        ahcWSClient.close();
                    }
                    finally {
                        Future future = actorSystem.terminate();
                        Await.result((Awaitable)future, (Duration)Duration.Inf());
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }

            public WSClient asScala() {
                return new play.api.libs.ws.ahc.AhcWSClient(new StandaloneAhcWSClient(this.val$asyncHttpClient, this.val$materializer));
            }
        };
    }
}

