/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import com.typesafe.config.Config;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.apache.pekko.stream.Materializer;
import play.Environment;
import play.inject.Binding;
import play.inject.Module;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.WSClient;
import play.libs.ws.ahc.AhcWSClient;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;

public class AhcWSModule
extends Module {
    public List<Binding<?>> bindings(Environment environment, Config config) {
        return Arrays.asList(AhcWSModule.bindClass(StandaloneWSClient.class).toProvider(StandaloneWSClientProvider.class), AhcWSModule.bindClass(WSClient.class).toProvider(AhcWSClientProvider.class));
    }

    @Singleton
    public static class StandaloneWSClientProvider
    implements Provider<StandaloneWSClient> {
        private final StandaloneWSClient standaloneWSClient;

        @Inject
        public StandaloneWSClientProvider(AsyncHttpClient asyncHttpClient, Materializer materializer) {
            this.standaloneWSClient = new StandaloneAhcWSClient(asyncHttpClient, materializer);
        }

        public StandaloneWSClient get() {
            return this.standaloneWSClient;
        }
    }

    @Singleton
    public static class AhcWSClientProvider
    implements Provider<WSClient> {
        private final AhcWSClient client;

        @Inject
        public AhcWSClientProvider(StandaloneWSClient standaloneWSClient, Materializer materializer) {
            this.client = new AhcWSClient((StandaloneAhcWSClient)standaloneWSClient, materializer);
        }

        public WSClient get() {
            return this.client;
        }
    }
}

