/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseBodyPart;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseStatus;
import play.api.libs.ws.ahc.cache.CacheableResponse$;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;

public class CacheableResponse
implements Response,
Product,
Serializable {
    private final CacheableHttpResponseStatus status;
    private final HttpHeaders headers;
    private final List bodyParts;
    private final AsyncHttpClientConfig ahcConfig;
    private List<Cookie> cookies;
    private final Uri uri;

    public static CacheableResponse apply(CacheableHttpResponseStatus cacheableHttpResponseStatus, HttpHeaders httpHeaders, List<CacheableHttpResponseBodyPart> list, AsyncHttpClientConfig asyncHttpClientConfig) {
        return CacheableResponse$.MODULE$.apply(cacheableHttpResponseStatus, httpHeaders, list, asyncHttpClientConfig);
    }

    public static CacheableResponse apply(int n, String string, AsyncHttpClientConfig asyncHttpClientConfig) {
        return CacheableResponse$.MODULE$.apply(n, string, asyncHttpClientConfig);
    }

    public static CacheableResponse apply(int n, String string, String string2, AsyncHttpClientConfig asyncHttpClientConfig) {
        return CacheableResponse$.MODULE$.apply(n, string, string2, asyncHttpClientConfig);
    }

    public static CacheableResponse fromProduct(Product product) {
        return CacheableResponse$.MODULE$.fromProduct(product);
    }

    public static CacheableResponse unapply(CacheableResponse cacheableResponse) {
        return CacheableResponse$.MODULE$.unapply(cacheableResponse);
    }

    public CacheableResponse(CacheableHttpResponseStatus status, HttpHeaders headers, List<CacheableHttpResponseBodyPart> bodyParts, AsyncHttpClientConfig ahcConfig) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        this.ahcConfig = ahcConfig;
        this.uri = status.getUri();
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1025735343, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CacheableResponse)) return false;
        CacheableResponse cacheableResponse = (CacheableResponse)object;
        CacheableHttpResponseStatus cacheableHttpResponseStatus = this.status();
        CacheableHttpResponseStatus cacheableHttpResponseStatus2 = cacheableResponse.status();
        if (cacheableHttpResponseStatus == null) {
            if (cacheableHttpResponseStatus2 != null) {
                return false;
            }
        } else if (!((Object)((Object)cacheableHttpResponseStatus)).equals((Object)cacheableHttpResponseStatus2)) return false;
        HttpHeaders httpHeaders = this.headers();
        HttpHeaders httpHeaders2 = cacheableResponse.headers();
        if (httpHeaders == null) {
            if (httpHeaders2 != null) {
                return false;
            }
        } else if (!httpHeaders.equals(httpHeaders2)) return false;
        List<CacheableHttpResponseBodyPart> list = this.bodyParts();
        List<CacheableHttpResponseBodyPart> list2 = cacheableResponse.bodyParts();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!((Object)list).equals(list2)) return false;
        AsyncHttpClientConfig asyncHttpClientConfig = this.ahcConfig();
        AsyncHttpClientConfig asyncHttpClientConfig2 = cacheableResponse.ahcConfig();
        if (asyncHttpClientConfig == null) {
            if (asyncHttpClientConfig2 != null) {
                return false;
            }
        } else if (!asyncHttpClientConfig.equals(asyncHttpClientConfig2)) return false;
        if (!cacheableResponse.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof CacheableResponse;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "CacheableResponse";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "status";
            }
            case 1: {
                return "headers";
            }
            case 2: {
                return "bodyParts";
            }
            case 3: {
                return "ahcConfig";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CacheableHttpResponseStatus status() {
        return this.status;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public List<CacheableHttpResponseBodyPart> bodyParts() {
        return this.bodyParts;
    }

    public AsyncHttpClientConfig ahcConfig() {
        return this.ahcConfig;
    }

    public HttpResponseStatus ahcStatus() {
        return this.status();
    }

    public HttpHeaders ahcHeaders() {
        return this.headers();
    }

    public List<HttpResponseBodyPart> ahcbodyParts() {
        return this.bodyParts();
    }

    public CacheableResponse withHeaders(Seq<Tuple2<String, String>> tuple) {
        HttpHeaders headerMap = new DefaultHttpHeaders().add(this.headers());
        tuple.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return headerMap.add(k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        return this.copy(this.copy$default$1(), headerMap, this.copy$default$3(), this.copy$default$4());
    }

    public int getStatusCode() {
        return this.status().getStatusCode();
    }

    public String getStatusText() {
        return this.status().getStatusText();
    }

    public byte[] getResponseBodyAsBytes() throws IOException {
        return this.getResponseBodyAsByteBuffer().array();
    }

    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        int length = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.bodyParts()).asScala().map((Function1 & Serializable)_$2 -> _$2.length())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer target = ByteBuffer.wrap(new byte[length]);
        CollectionConverters$.MODULE$.ListHasAsScala(this.bodyParts()).asScala().foreach((Function1 & Serializable)part -> target.put(part.getBodyPartBytes()));
        target.flip();
        return target;
    }

    private Charset computeCharset(Charset charset) {
        return (Charset)Option$.MODULE$.apply((Object)charset).orElse(this::computeCharset$$anonfun$1).getOrElse(CacheableResponse::computeCharset$$anonfun$2);
    }

    public String getResponseBody() throws IOException {
        if (CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.isTraceEnabled()) {
            CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.trace("getResponseBody: ");
        }
        return this.getResponseBody(null);
    }

    public String getResponseBody(Charset charset) throws IOException {
        if (CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.isTraceEnabled()) {
            CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.trace("getResponseBody: ");
        }
        return new String(this.getResponseBodyAsBytes(), this.computeCharset(charset));
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        if (CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.isTraceEnabled()) {
            CacheableResponse$.play$api$libs$ws$ahc$cache$CacheableResponse$$$logger.trace("getResponseBodyAsStream: ");
        }
        return new ByteArrayInputStream(this.getResponseBodyAsBytes());
    }

    public Uri getUri() throws MalformedURLException {
        return this.uri;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getHeader(CharSequence name) {
        return this.headers().get(name);
    }

    public List<String> getHeaders(CharSequence name) {
        return this.headers().getAll(name);
    }

    public HttpHeaders getHeaders() {
        return this.headers();
    }

    public boolean isRedirected() {
        int n = this.status().getStatusCode();
        switch (n) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public List<Cookie> getCookies() {
        if (this.headers() == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            this.cookies = this.buildCookies();
        }
        return this.cookies;
    }

    public boolean hasResponseStatus() {
        return this.status() != null;
    }

    public boolean hasResponseHeaders() {
        return this.headers() != null;
    }

    public boolean hasResponseBody() {
        return !this.bodyParts().isEmpty();
    }

    private List<Cookie> buildCookies() {
        List setCookieHeaders = this.headers().getAll("Set-Cookie2");
        if (!MiscUtils.isNonEmpty((Collection)setCookieHeaders)) {
            setCookieHeaders = this.headers().getAll("Set-Cookie");
        }
        if (MiscUtils.isNonEmpty((Collection)setCookieHeaders)) {
            ArrayList cookies = new ArrayList(1);
            CollectionConverters$.MODULE$.IteratorHasAsScala(setCookieHeaders.iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)value -> {
                Cookie c;
                Cookie cookie = c = this.ahcConfig().isUseLaxCookieEncoder() ? ClientCookieDecoder.LAX.decode(value) : ClientCookieDecoder.STRICT.decode(value);
                if (c != null) {
                    cookies.add(c);
                    return;
                }
            });
            return Collections.unmodifiableList(cookies);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "CacheableResponse(status = " + this.status() + ", headers = " + this.headers() + ", bodyParts size = " + this.bodyParts().size() + ")";
    }

    public SocketAddress getLocalAddress() {
        return this.status().getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.status().getRemoteAddress();
    }

    public CacheableResponse copy(CacheableHttpResponseStatus status, HttpHeaders headers, List<CacheableHttpResponseBodyPart> bodyParts, AsyncHttpClientConfig ahcConfig) {
        return new CacheableResponse(status, headers, bodyParts, ahcConfig);
    }

    public CacheableHttpResponseStatus copy$default$1() {
        return this.status();
    }

    public HttpHeaders copy$default$2() {
        return this.headers();
    }

    public List<CacheableHttpResponseBodyPart> copy$default$3() {
        return this.bodyParts();
    }

    public AsyncHttpClientConfig copy$default$4() {
        return this.ahcConfig();
    }

    public CacheableHttpResponseStatus _1() {
        return this.status();
    }

    public HttpHeaders _2() {
        return this.headers();
    }

    public List<CacheableHttpResponseBodyPart> _3() {
        return this.bodyParts();
    }

    public AsyncHttpClientConfig _4() {
        return this.ahcConfig();
    }

    private final Option computeCharset$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.getContentType()).flatMap((Function1 & Serializable)ct -> Option$.MODULE$.apply((Object)HttpUtils.extractContentTypeCharsetAttribute((String)ct)));
    }

    private static final Charset computeCharset$$anonfun$2() {
        return StandardCharsets.UTF_8;
    }
}

